function Filters()
{
	this.glowbuf = new Framebuffer(128, 128, 0, PixelFormatR8G8B8A8, false, false);
	this.fb1 = new Framebuffer(128, 128, 0, PixelFormatR8G8B8A8, false, false);
	this.fb2 = new Framebuffer(128, 128, 0, PixelFormatR8G8B8A8, false, false);
	
	this.DirectionalBlur = function(src, dx, dy, pass)
	{
		PushFramebuffer(this.fb1);
		src.Blit();
		PopFramebuffer();
		
		for (var i = 0; i < pass; i++)
		{
			PushFramebuffer(this.fb2);
			this.fb1.Blit(BlendModeNone, -1, -1, "fscriptlib/directional_blur.cg", {"Delta":[dx, dy, 0, 0]});
			PopFramebuffer();
			PushFramebuffer(this.fb1);
			this.fb2.Blit(BlendModeNone, -1, -1, "fscriptlib/directional_blur.cg", {"Delta":[dx, dy, 0, 0]});
			PopFramebuffer();
		}
		
		PushFramebuffer(src);
		this.fb1.Blit();
		PopFramebuffer();
	}
	this.Blur = function(src, amount, pass)
	{
		this.DirectionalBlur(src, amount / 128.0, 0, pass);	
		this.DirectionalBlur(src, 0, amount / 128.0, pass);
	}
	this.Glow = function(src, blurAmount, pass)
	{
		PushFramebuffer(this.glowbuf);
		src.Blit();
		PopFramebuffer();
		
		this.Blur(this.glowbuf, blurAmount, pass);
		
		PushFramebuffer(src);
		this.glowbuf.Blit(BlendModeScreen);
		PopFramebuffer();
	}
}
