#include <stdio.h>
#include <string.h>
#include <sys/types.h>

#ifndef _WIN32
#include <sys/socket.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <unistd.h>
#endif
#include <fcntl.h>
#include <errno.h>
#include <cassert>

#include <iostream>
#include <sstream>

#include "TCPConnection.h"

using namespace std;


#ifdef _WIN32

#include <BaseTsd.h>
#include <WS2tcpip.h>

class winsock
{
public:
    winsock();
    ~winsock();
    WSADATA wsa_data;
};

winsock::winsock()
{
    const int initres = WSAStartup(MAKEWORD(2,2), &wsa_data);
    printf("WSAStartup result: %d\n", initres);
}

winsock::~winsock()
{
    WSACleanup();
    printf("WSACleanup done\n");
}

winsock ws;



#ifdef _WIN64
typedef __int64         ssize_t;
#else
typedef _w64 int        ssize_t;
#endif

#endif /* _WIN32 */




TCPConnection::TCPConnection() {
}

void TCPConnection::connect(const char *hostname, const char *port) {
    int status;
    struct addrinfo hints, *res;

    memset(&hints, 0, sizeof hints); // make sure the struct is empty
    hints.ai_family = AF_UNSPEC;     // don't care IPv4 or IPv6
    hints.ai_socktype = SOCK_STREAM; // TCP stream sockets
    hints.ai_flags = AI_PASSIVE;     // fill in my IP for me

    cout << "Connecting to " << hostname << ":" << port << endl;

    status = getaddrinfo(hostname, port, &hints, &res);
    if (status != 0) {
        std::cerr << status << gai_strerror(status) << std::endl;
        throw ConnectException("Could not find hostname");
        //fprintf(stderr, "Could not find hostname: %s:%s\n", hostname, port);
    }
	fd = 0;
    fd = socket(res->ai_family, res->ai_socktype, res->ai_protocol);
    if (fd < 0) {
        throw ConnectException("Could not create local socket");
    }
	cout << "fd: " << fd << endl;

    //status = fcntl(fd, F_SETFL, O_NONBLOCK);
    //if (status == -1) {
        //::close(fd);
        //throw ConnectException("Could not enter non-blocking mode");
    //}

    status = ::connect(fd, res->ai_addr, res->ai_addrlen);
    if (status == -1 && errno != EINPROGRESS) {
        cerr << "errno: " << errno << endl;
        cerr << "error: " << strerror(errno) << endl;
        this->close();
        throw ConnectException("Could not connect to host");
    }
    //freeaddrinfo(res); // TODO
}

TCPConnection::~TCPConnection() {
    if (fd >= 0)
        this->close();
}

int TCPConnection::write(char *buf, int len) {
    ssize_t res, pos = 0;

    while (pos < len) {
		res = ::send(fd, buf, len, 0);
        //res = ::write(fd, buf, len);
        //std::cout << "Write " << res << " " << buf << endl;
        if (res == -1) {
            cerr << "errno: " << errno << endl;
            cerr << "error: " << strerror(errno) << endl;
            if (errno == EAGAIN || errno == EWOULDBLOCK || errno == EINTR) {
                continue;
            }
#ifdef _WIN32
            cerr << "wsaerror: " << WSAGetLastError() << endl;
#endif
            throw ConnectException("write error");
        } else if (res == 0) {
            return res;
        } else {
            pos += res;
        }
    }
    return pos;
}

int TCPConnection::write(std::string string) {
    return write((char*)string.c_str(), string.size());
}

int TCPConnection::read(char *buf, int len) {
	ssize_t t = ::recv(fd, buf, len, 0);
    //ssize_t t = ::read(fd, buf, len);
    //std::cout << "RECEIVED: " << buf << endl;
    return t;
}

std::string TCPConnection::readall() {
    char tmp[512];
    std::stringstream buffer;
    size_t bytes = 0;
    while (1) {
        int n = ::recv(fd, tmp, sizeof tmp, 0);
        if (n < 0) break;
        if (n == 0) break;
        buffer.write(tmp, n);
        bytes += n;
    }
    assert(bytes == buffer.str().length());
    return buffer.str();
}


std::string TCPConnection::readLine() {
    char tmp[1024];
    int i = 0;
    while (i < sizeof tmp) {
        //int n = ::recv(fd, tmp, sizeof tmp, 0);
        int n = ::recv(fd, tmp+i, 1, 0);
        if (n == -1) {
            //cerr << "errno: " << errno << endl;
            //cerr << "error: " << strerror(errno) << endl;
            if (errno == EAGAIN || errno == EWOULDBLOCK || errno == EINTR) {
                continue;
            }
            throw ConnectException("read failed");
        } else if (n == 0) {
            // End of file
            throw ConnectException("Disconnected");
        }
        //cout << "RECEIVED: " << n << " \"" << string(tmp, n) << "\"" << endl;

        if (tmp[i] == '\n') {
            tmp[i] = '\0';
            return std::string(tmp, i);
            //return i;
        }
        // ignore \r
        if (tmp[i] != '\r') {
            i++;
        }
    }
    return std::string(tmp, sizeof(tmp));
}


int TCPConnection::readLine2(char* const buf, int max)
{
    if (fd == -1)
        return 0;
    int i = 0;
    for (i = 0; i < max; )
    {
        const int len = ::recv(fd, buf+i, 1, 0);
        if (len <= 0) {
            if (len == -1 && (errno == EAGAIN || errno == EWOULDBLOCK || errno == EINTR)) {
                continue;
            }
            if (len == 0)
                printf("connection closed while waiting for data\n");
            else
                printf("socket recv failed, disabling socket\n");
            close();
            buf[0] = 0;
            return 0;
        }
        if (buf[i] == '\n') {
            buf[i] = 0;
            return i;
        }
        if (buf[i] != '\r')
            i++;
    }
    return max;
}

void TCPConnection::close() {
#ifdef _WIN32
    closesocket(fd);
#else
    ::close(fd);
#endif
    fd = -1;
}

void TCPConnection::flush() {
#ifndef _WIN32
    ::fsync(fd);
#endif
}

bool TCPConnection::isConnected() const {
    return fd >= 0;
}
