#ifndef _RENDERWINDOW_H_
#define _RENDERWINDOW_H_

#ifdef RENDER
#include <SDL.h>
#include <GL/glew.h>
#include <GL/glut.h>
#endif

class RenderWindow {
public:
    int width, height;
	#ifdef RENDER
    SDL_Surface *window;
#endif

    RenderWindow(int &argc, char **argv) {
        width = 1280;
        height = 720;

#ifdef RENDER
        SDL_Init(SDL_INIT_VIDEO);

        window = SDL_SetVideoMode(width, height, 32, SDL_OPENGL | SDL_DOUBLEBUF);
        SDL_WM_SetCaption("CloudWars", 0);

 
        glutInit(&argc, argv);

        glEnable(GL_TEXTURE_2D);
        glEnable(GL_BLEND);

        glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
#endif
    }
};

#endif
