public class Vector {

    public float x;
    public float y;
    
    public Vector(float x, float y) {
    	this.x = x;
    	this.y = y;
    }
    
    public static Vector byAngle(float angle, float length){
    	float x = (float) Math.cos(angle) * length;
    	float y = (float) Math.sin(angle) * length;
    	return new Vector(x,y);
    }
    

    public float length(){
    	return (float) Math.sqrt((x*x+y*y));
    }
    
    public void lengthen(Vector v){
    	this.x += v.x;
    	this.y += v.y;
    }
    
    public float angle(){
    	float angle;
    	if(x == 0){
    		angle = (float) (y<0? 3*Math.PI /2 : Math.PI /2 );
    	}else if(x>0){
    		angle = (float) Math.atan((y)/(x));
    	}else if(x<0){
    		angle = (float) (Math.PI + Math.atan((y)/(x)) );
    	}else{
    		throw new AssertionError();
    	}
    	
    	while(angle >= 2* Math.PI){
    		angle -= 2 * Math.PI;
    	}
    	while (angle < 0){
    		angle += 2 * Math.PI;
    	}
    	return angle;
    }
    
    public float getDistanceTo(Vector v){
    	long time = -System.currentTimeMillis();
    	float distance = (float) Math.sqrt(Math.pow(Math.abs(this.x - v.x), 2) + Math.pow(Math.abs(this.y - v.y), 2));
    	time += System.currentTimeMillis();
    	//Log.debug("getDistance took " + time + "ms");
    	return distance;
    }
    
    @Override
    public String toString() {
    	return "(" + x + "," + y + ")";
    }
}
