/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;

public abstract class Client {
    private Socket client;
    private BufferedReader reader;
    private PrintWriter writer;
    private byte[] data = new byte[256];
    private InetSocketAddress endPoint;
    private boolean started = false;
    private int iteration = 0;

    public GameState getState() {
        try {
            String line = "";
            if (!this.started) {
                line = this.reader.readLine();
                while (line == null || !line.equals("START")) {
                    line = this.reader.readLine();
                }
                this.started = true;
            }
            this.writer.println("GET_STATE");
            this.writer.flush();
            GameState state = new GameState();
            boolean end = false;
            int c = 0;
            while (!end && c < 500) {
                ++c;
                line = this.reader.readLine();
                if (line == null) continue;
                String[] msg = line.split("\\s+");
                String key = msg[0];
                if (key.equals("BEGIN_STATE")) {
                    state.iteration = this.iteration = Integer.parseInt(msg[1]);
                    continue;
                }
                if (key.equals("END_STATE")) {
                    end = true;
                    continue;
                }
                if (key.equals("THUNDERSTORM")) {
                    state.thunderstorms.add(new Cloud(Float.parseFloat(msg[1]), Float.parseFloat(msg[2]), Float.parseFloat(msg[3]), Float.parseFloat(msg[4]), Float.parseFloat(msg[5]), true));
                    continue;
                }
                if (key.equals("RAINCLOUD")) {
                    float vapor = Float.parseFloat(msg[5]);
                    if (!(vapor > 0.0f)) continue;
                    state.rainclouds.add(new Cloud(Float.parseFloat(msg[1]), Float.parseFloat(msg[2]), Float.parseFloat(msg[3]), Float.parseFloat(msg[4]), Float.parseFloat(msg[5]), false));
                    continue;
                }
                if (!key.equals("YOU")) continue;
                state.meIndex = Integer.parseInt(msg[1]);
            }
            return state;
        }
        catch (Exception e) {
            System.out.println("Error: " + e);
            return null;
        }
    }

    public void setName(String name) {
        this.writer.println("NAME " + name);
        this.writer.flush();
    }

    public boolean wind(double x, double y) throws IOException {
        this.writer.println("WIND " + x + " " + y);
        this.writer.flush();
        String response = this.reader.readLine();
        boolean ok = response.equals("OK");
        return ok;
    }

    protected boolean Connected() {
        return this.client.isConnected() && !this.client.isClosed() && !this.writer.checkError();
    }

    protected void disconnect() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Client() throws Exception {
        this.client = new Socket();
        this.endPoint = new InetSocketAddress("127.0.0.1", 1986);
        this.client.connect(this.endPoint);
        this.reader = new BufferedReader(new InputStreamReader(this.client.getInputStream()));
        this.writer = new PrintWriter(this.client.getOutputStream(), true);
    }

    public abstract void RunAi() throws Exception;
}

