import java.io.IOException;
import java.util.ArrayList;

import javax.swing.text.AbstractDocument.BranchElement;

public class MyAi extends Client {

	public MyAi() throws IOException, InterruptedException {
		super();
	}

	// Implement your AI here
	// Use these functions to communicate with server:
	//    SetName(name) - Sets your name to appear in the simulator
	//    GetState() - returns the current GameState object
	//    Wind(x, y) - applies a wind in the given direction (returns true if OK, false if IGNORED)
	@Override
	public void RunAi() throws IOException, InterruptedException {
		SetName("Fredrikstad AI");

		while (Connected()) {
			// Poll the game state
			GameState state = GetState();
			if (state == null) break;
			if(state.Thunderstorms.size() == 1){ System.out.println("I WIN!!!!!!"); break;}
			// Ignore game state and do something random!
			ArrayList<Cloud> biggerclouds = new ArrayList<Cloud>();
			Cloud me = state.Me();
			Cloud cl = state.Me();
			double s_dist = Double.MAX_VALUE;
			//Find enemies to eat
			for(Cloud c : state.Thunderstorms){
				s_dist = Math.sqrt(Math.pow(me.Position.x-c.Position.x,2.0)+Math.pow(me.Position.y-c.Position.y,2.0));
				if(c.Radius() > me.Radius())
					biggerclouds.add(c);
				if(c.Radius()+(s_dist*0.01) < me.Radius() && c.Radius() < cl.Radius()){
					cl = c;
				}
			}
			//if there are no enemies to eat, find a raincloud
			if(cl == state.Me()){
				cl = null;
				s_dist = Double.MAX_VALUE;
				for (Cloud c : state.Rainclouds) {
					if(c.Radius() > me.Radius())
						biggerclouds.add(c);
					double temp = Math.sqrt(Math.pow(me.Position.x-c.Position.x,2.0)+Math.pow(me.Position.y-c.Position.y,2.0))*(1/c.Radius())*Math.sqrt(Math.pow(me.Velocity.x-c.Velocity.x,2.0)+Math.pow(me.Velocity.y-c.Velocity.y,2.0));
					if(c.Radius() < me.Radius() && c.Radius() > 8.0 && temp < s_dist ){
						s_dist = temp;
						cl = c;
					}	
				}
			}
			//If you are to small, just loop over
			if(cl == null){
				continue;
			}
			System.err.println("My pos : " + me.Position.x + " y : " + me.Position.y );
			System.err.println("Cloud pos : " + cl.Position.x + " y : " + cl.Position.y );
			System.err.println("My radius : " + me.Radius());
			System.err.println("Cloud radius : " + cl.Radius());
			System.err.println("My Velocity : " + me.Velocity.x + " y : " + me.Velocity.y);
			System.err.println("Cloud Velocity : " + cl.Velocity.x + " y : " + cl.Velocity.y);
			float diff_x = me.Position.x-cl.Position.x;
			float diff_y = me.Position.y-cl.Position.y;
			float mov_x = (float) 0.0;
			float mov_y = (float) 0.0;
			float u_diff_x = Math.abs(diff_x);
			float u_diff_y = Math.abs(diff_y);

			if(u_diff_x < u_diff_y){
				float diff_ratio = u_diff_x/u_diff_y;
				mov_y = (float) (s_dist/25+8.0);
				mov_x = mov_y*diff_ratio;
			}else {
				float diff_ratio = u_diff_y/u_diff_x;
				mov_x = (float) (s_dist/25+8.0);
				mov_y = mov_x*diff_ratio;
			}

			if(diff_x > 0){
				mov_x = -mov_x;
			}
			if(diff_y > 0){
				mov_y = -mov_y;
			}
			
			if(!(Math.abs(me.Velocity.x) > Math.abs(diff_x*0.999) - 10 && Math.abs(me.Velocity.y) > Math.abs(diff_x*0.999) - 10 && Math.abs(me.Velocity.y) < Math.abs(diff_y*0.999) + 10 && Math.abs(me.Velocity.y) > Math.abs(diff_y*0.999) - 10)){
				float this_mv_x = mov_x-me.Velocity.x; 
				float this_mv_y = mov_y-me.Velocity.y;

				if(((this_mv_x < 0 && mov_x > 0) || (this_mv_x > 0 && mov_x < 0)) && ((this_mv_y < 0 && mov_y > 0) || (this_mv_y > 0 && mov_y < 0))){
					this_mv_x = (float) 0.0;
					System.err.println("X going something");
					this_mv_y = (float) 0.0;
					System.err.println("Y going something");
				}
				//Check if you are heading towards a bigger cloud, and turn around
				boolean breakit = false;
				float send_x = Float.MAX_VALUE;
				float send_y = Float.MAX_VALUE;
				float close_bigbad = Float.MAX_VALUE;
				for(Cloud c:biggerclouds){
					diff_x = me.Position.x-c.Position.x;
					diff_y = me.Position.y-c.Position.y;
					float dist = (float) Math.sqrt(Math.pow(diff_x,2.0)+Math.pow(diff_y,2.0)); 
					if(dist<15.0 && dist<close_bigbad && ((int)Math.abs(diff_x/(me.Velocity.x))-Math.abs(c.Radius()/(me.Velocity.x)) < (int)Math.abs(diff_y/(me.Velocity.y)) && (int)Math.abs(diff_x/(me.Velocity.x))+Math.abs(c.Radius()/(me.Velocity.x)) > (int)Math.abs(diff_y/(me.Velocity.y)))){
						send_x = (float) (c.Velocity.x - me.Velocity.x);
						send_y = (float) (c.Velocity.y - me.Velocity.y);
						close_bigbad = dist;
						breakit = true;
						continue;
					}
					if((int)Math.abs(diff_x/(me.Velocity.x+this_mv_x))-Math.abs(c.Radius()/(me.Velocity.x+this_mv_x)) < (int)Math.abs(diff_y/(me.Velocity.y+this_mv_y)) && (int)Math.abs(diff_x/(me.Velocity.x+this_mv_x))+Math.abs(c.Radius()/(me.Velocity.x+this_mv_x)) > (int)Math.abs(diff_y/(me.Velocity.y+this_mv_y))){
						System.err.println("FUCK IT");
						breakit = true;
					}
				}
				if(breakit){
					if(close_bigbad < Float.MAX_VALUE)
						Wind(send_x, send_y);
					continue;
				}
				//Send wind in the calculated x, y
				boolean a = Wind(this_mv_x,this_mv_y);

				System.err.println(((a)?"OK":"NOT OK"));
				//No small wind? Try to make it bigger
				while(!a && me.Radius() > 5.0 && this_mv_x != 0.0 && this_mv_y != 0.0 && this_mv_y < 100.0 && this_mv_y > -100.0 && this_mv_x < 100.0 && this_mv_x > -100.0){
					this_mv_x = 2*this_mv_x;
					this_mv_y = 2*this_mv_y;
					System.out.println("Try again");
					a = Wind(this_mv_x,this_mv_y);
				}
				System.err.println("DO SOMETHING");
			}        	

			Thread.sleep(500);
		}
	}

	public static void main(String[] args) {
		try {
			MyAi ai = new MyAi();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}


