import time, socket
from math import sqrt
import random
import copy
width, height = 1280, 720

class Cloud(object):
	def __init__(self, x, y, vx, vy, m, type='rain'):
		self.type = type
		self.m = m
		self.x = x
		self.y = y
		self.vx = vx
		self.vy = vy
		self.dead = False
		
	def bounce_check(self):
		r = sqrt(self.m)
		if self.x < r:
			self.vx = 0.6 * abs(self.vx)
			self.x = r
		if self.y < r:
			self.vy = 0.6 * abs(self.vy)
			self.y = r
		if self.x > width-r:
			self.vx = -0.6 * abs(self.vx)
			self.x = width-r
		if self.y > height-r:
			self.vy = -0.6 * abs(self.vy)
			self.y = height-r

	def iterate(self, clouds):
		self.x += self.vx * 0.1
		self.y += self.vy * 0.1
		self.vx *= 0.999
		self.vy *= 0.999
		
		for i in clouds:
			if i is self: continue
			if self.m > i.m or (self.m == i.m and random.choice((True, False))):
				while sqrt((self.x-i.x)**2+(self.y-i.y)**2) < sqrt(self.m)+sqrt(i.m):
					i.m -= 1.0
					self.m += 1.0
					if i.m < 1.0:
						clouds.remove(i)
						break
			else:
				while sqrt((self.x-i.x)**2+(self.y-i.y)**2) < sqrt(self.m)+sqrt(i.m):
					i.m += 1.0
					self.m -= 1.0
					if self.m < 1.0:
						clouds.remove(self)
						return
		self.bounce_check()
		
	def __repr__(self):
		return "<Cloud t:%s, m:%s>" % (self.type, self.m)

class Heaven:
	def __init__(self):
		self.clouds=[]
		
	def iterate(self):
		for i in self.clouds:
			i.iterate(self.clouds)
			
	def wind(self, cloud, x, y):
		strength = sqrt(x*x+y*y)
		if strength < 1.0 or strength > cloud.m/2:
			return False
		r = sqrt(cloud.m)
		cloud.vx += x*5/r
		cloud.vy += y*5/r
		cloud.m -= strength
		distance = (r + sqrt(strength)) * 1.1
		px = cloud.x - x * distance / strength
		py = cloud.y - y * distance / strength
		vx = -x*20/strength+cloud.vx
		vy = -y*20/strength+cloud.vy
		fart = Cloud(px, py, vx, vy, strength, type='rain')
		self.clouds.append(fart)
		return fart
		
class Client:
	def __init__(self, host, port, name='spectator'):
		s = socket.socket()
		s.connect((host, port))
		self.fd = s.makefile()
		if name=='spectator':
			self.fd.write("SPECTATOR\n")
		else:
			self.fd.write("NAME " + name + "\n")
		self.fd.flush()
		while (self.fd.readline().split()[0] != "START"): pass # Kanskje ikke helt optimalt
		self.heaven=Heaven()
		self.me = None
		
	def refresh(self):
		self.fd.write("GET_STATE\n")
		self.fd.flush()
		tsi = 0
		clouds = []
		me = None
		mec = None
		line = self.fd.readline().split()
		while line[0] != 'END_STATE':
			#print line, ","
			if line[0] == 'BEGIN_STATE': statenum = int(line[1])
			if line[0] == 'YOU': me = int(line[1])
			if line[0] == 'THUNDERSTORM' or line[0] == 'RAINCLOUD':
				x, y, vx, vy, m = float(line[1]), float(line[2]), float(line[3]), float(line[4]), float(line[5])
				if m == 0: # Official simulator don't seem to be removing these. 
					line = self.fd.readline().split()
					continue 
				if line[0] == 'THUNDERSTORM':
					if tsi == me: 
						type = 'me'
					else: type = 'thunder'
					tsi +=1
				else: type= 'rain'
				cloud = Cloud(x, y, vx, vy, m, type)
				clouds.append(cloud)
				if type == 'me':
					mec = cloud
			line = self.fd.readline().split()
		if mec:
			self.me = mec
		self.heaven.clouds = copy.copy(clouds)
		return statenum
		
	def run(self, getrate=10):
		rate = 60
		start_statenum = self.refresh()
		start_time = last_get = time.time()
		last_iter=time.time()-1.0/rate
		while True:
			sleep = min(last_iter-time.time()+1.0/rate, last_get-time.time()+1.0/getrate)
			if sleep > 0:
				time.sleep(sleep)
			elif sleep < -0.05:
				print "Lagging %f seconds" % (-sleep)
			if last_get-time.time()+1.0/getrate<=0:
				statenum = self.refresh()
				rate = (statenum-start_statenum)/(time.time()-start_time)
				if rate < 1 or rate > 1000: rate = 100
				last_get = time.time()
			if last_iter-time.time()+1.0/rate<=0:
				self.heaven.iterate()
				last_iter = time.time()
				
	def wind(self, x, y):
		self.fd.write("WIND %f %f\n" % (x, y))
		self.fd.flush()
		print self.fd.readline()
		fart = self.heaven.wind(self.me, x, y)
		if fart:
			fart.bounce_check()
		return
		