import time, random
import thread, socket
import copy
from math import sqrt, sin, cos

import cloudwars

#host, port = '188.0.58.176', 1986
host, port = '127.0.0.1', 1986
name = 'Pong'

client = cloudwars.Client(host, port, name)

base_list = []

def interception(x1, x2, y1, y2, vx1, vx2, vy1, vy2, r1, r2, i, j):
	try:
		t1 = (-x1*vx1+x1*vx2+x2*vx1-x2*vx2-y1*vy1+y1*vy2+y2*vy1-y2*vy2)/((vx1-vx2)**2+(vy1-vy2)**2)
		
		x = x2+t1*vx2
		if x < r2:
			t1 += 1.2*(r2-x)/vx2 #vx1 er negativ
		if x > 1280-r1:
			t1 += 1.2*(1280-r2-x)/vx12
		
		y = y2+t1*vy2
		if y < r2:
			t1 += 1.2*(r2-y)/vy2 #vy1 er negativ
		if y > 720-r2:
			t1 += 1.2*(720-r2-y)/vy2
		if t1 < 0:
			t1 = 0
			
		d = sqrt((x1-x2+t1*(vx1-vx2))**2+(y1-y2+t1*(vy1-vy2))**2)
		t0 = t1 - sqrt((r1+r2)**2+d**2)/sqrt((vx1-vx2)**2+(vy1-vy2)**2)
		if t0 < 0:
			t0 = 0
		if d > r1 + r2:
			resultat =  i, j, -1, -1, 1000
		resultat =  i, j, t0, t1, d
	except:
		resultat = i, j, -1, -1, 1000
	return resultat
		
def bounce(c1, c2):
		
	x1, x2, y1, y2, vx1, vx2, vy1, vy2, r1, r2 = c1.x, c2.x, c1.y, c2.y, c1.vx, c2.vx, c1.vy, c2.vy, sqrt(c1.m), sqrt(c2.m)
	
	if vx1 < 0:
		bx1 = [x1, 1.6*r1-0.6*x1, x1, 1.6*r1-0.6*x1]
	else:
		bx1 = [x1, 1.6*(1280-r1)-0.6*x1, x1, 1.6*(1280-r1)-0.6*x1]
	bvx1 = [vx1, -0.6*vx1, vx1, -0.6*vx1]
	
	if vx2 < 0:
		bx2 = [x2, 1.6*r2-0.6*x2, x2, 1.6*r2-0.6*x2]
	else:
		bx2 = [x2, 1.6*(1280-r2)-0.6*x2, x2, 1.6*(1280-r2)-0.6*x2] 
	bvx2 = [vx2, -0.6*vx2, vx2, -0.6*vx2]
	
	if vy1 < 0:
		by1 = [y1, y1, 1.6*r1-0.6*y1, 1.6*r1-0.6*y1]
	else:
		by1 = [y1, y1, 1.6*(720-r1)-0.6*y1, 1.6*(720-r1)-0.6*y1]
	bvy1 = [vy1, vy1, -0.6*vy1, -0.6*vy1]
	
	if vy2 < 0:
		by2 = [y2, y2, 1.6*r2-0.6*y2, 1.6*r2-0.6*y2]
	else:
		by2 = [y2, y2, 1.6*(720-r2)-0.6*y2, 1.6*(720-r2)-0.6*y2]
	bvy2 = [vy2, vy2, -0.6*vy2, -0.6*vy2]
	
	bounces = []
		
	for i in range(4):
		for j in range(4):
			bounce = interception(bx1[i], bx2[j], by1[i], by2[j], bvx1[i], bvx2[j], bvy1[i], bvy2[j], r1, r2, c1, c2)
			if bounce[2]>=0:
				bounces.append(bounce)
	
	return bounces
	
def getscore(clouds, me, wind):
	
	intercepts = [i for i in base_list]
	done_clouds = []
	m = {}
	score = me.m
	
	if wind:
		for i in clouds:
			if i is wind or i is me: continue
			intercepts.extend(bounce(i, wind))
	for i in clouds:
		m[i] = i.m
		if i is me: continue
		intercepts.extend(bounce(i, me))
	
	intercepts.sort(key=lambda c: c[2])
	
	for i in intercepts:
		#TODO: Kalkuler reell t0 etter endringer av storrelser
		c1, c2, t0, t1, d = i
		if d > sqrt(m[c1]) + sqrt(m[c2]): continue
		if m[c1] == m[c2]: print m[c1], m[c2]
		if d < sqrt(m[c1]) + sqrt(m[c2]):
			if m[c1] < m[c2]:
				ab1 = -m[c1]
			else:
				ab1 = m[c2]
		else:
			try:
				if m[c1] < m[c2]:
					ab1 = -(m[c1]+m[c2]+sqrt(2*d**2*(m[c1]+m[c2])-d**4))/2+m[c2]
				else:
					ab1 = (m[c1]+m[c2]+sqrt(2*d**2*(m[c1]+m[c2])-d**4))/2-m[c1]
			except:
				ab1 = 0
		if c2 is me:
			close = [icpt for icpt in intercepts if (icpt[2] < t1 + 0.1 and icpt[1] is not me)]
			for cl in close:
				if (cl[0] is c1 and cl[1].m + c1.m > c2.m) or (cl[1] is c1 and cl[0].m + c1.m > c2.m):
					score -= c2.m * 0.3 * 0.970**((t0+t1)*5) #Juster
			if ab1 < 0:
				if c1.type == 'rain':
					score -= ab1 * 0.8 * 0.993**((t0+t1)*5) #Juster
				else:
					if m[c1]/m[c2] < 0.5: #Spiser en liten fiende
						score -= ab1 * 2.0 * 0.990**((t0+t1)*5) #Juster
					elif m[c1]/m[c2] < 0.9: # Spiser en mellomstor fiende
						score -= ab1 * 1.5 * 0.990**((t0+t1)*5) #Juster
					else: # Spiser en stor fiende
						score -= ab1 * 0.8 * 0.990**((t0+t1)*5) #Juster
			else:
				if c1.type == 'rain':
					score -= ab1 * 1.2 * 0.970**((t0+t1)*5) #Juster
				else:
					score -= ab1 * 2.0 * 0.970**((t0+t1)*5) #Juster
		if c1.type == 'thunder':
			score -= ab1 * 0.2 * 0.970**((t0+t1)*5) #Juster
		m[c1], m[c2] = m[c1] + ab1, m[c2] - ab1
	return score, m[me]
	
def getwindscore(x, y):
		heaven = copy.copy(client.heaven)
		heaven.clouds = copy.copy(client.heaven.clouds)
		m2 = copy.deepcopy(client.me)
		try:
			heaven.clouds.remove(client.me)
		except:
			print "ERROR!"
			print heaven.clouds
			print client.me
		heaven.clouds.append(m2)
		wind = heaven.wind(m2, x, y)
		return getscore(heaven.clouds, m2, wind)

def build_base_list(clouds):
	done_clouds = []
	base_list = []
	
	base_clouds = [cloud for cloud in clouds if cloud != client.me]
	for i in base_clouds:
		done_clouds.append(i)
		for j in base_clouds:
			if j in done_clouds: continue
			base_list.extend(bounce(i, j))
		
angles = range(0, 360, 360/8)

timep = 0.1
phase = 0
last_statenum = -60

while True:
	phase = (phase + 1) % (360/8)
	wxs = [cos(x+phase) for x in angles]
	wys = [sin(x+phase) for x in angles]
	
	tries = tries2 = 0
	statenum = client.refresh()
	start = time.time()
	states = statenum - last_statenum
	last_statenum = statenum
	
	for i in range(states-1):
		client.heaven.iterate()
		
	build_base_list(client.heaven.clouds)
	
	me = client.me
	best = (getwindscore(0, 0), 0, 0)
	print "Vapor: ", client.me.m, " Nominal: ", best
	
	for strength in [me.m/8, me.m/4]:
		for v in range(len(wxs)):
			wx, wy = wxs[v] * strength, wys[v] * strength
			score = getwindscore(wx, wy)
			if score[0] > best[0][0]:
				best = (score, wx, wy)
			tries +=1
	while time.time()<start + 0.1:
		wx, wy = random.gauss(best[1], client.me.m/20), random.gauss(best[2], client.me.m/20)
		wm = sqrt(wx**2+wy**2)
		if wm < 1.0 or wm>me.m/2: continue
		tries +=1
		tries2 +=1
		score = getwindscore(wx, wy)
		if score[0] > best[0][0]:
			best = (score, wx, wy)
	print "Best: ", best
#	timep = time.time()-start
#	print "Tries: %d, Tries2: %d, T: %f, 1/T: %f, num: %d itrate: %f" % (tries, tries2, timep, 1/timep, states, states/timep)
	if (best[1] != 0 or best[2] != 0):
		client.wind(best[1], best[2])
