static int PULSE_COLOUR =#787878;
static int ALIVE_COLOUR = #000000;
static int DEAD_COLOUR = #ffffff;
static int EYE_COLOUR = #00b4ff;
static int HIGHLIGHT_COLOUR = #969696;

public class Cell {
  public PVector Position;
  public int Size;

  private boolean _alive;
  private boolean _newalive;
  private boolean _changed;
  private float _elapsedtime;
  private Cell[] _neighbours = new Cell[8];
  private int _colour;

  public Cell(int csize) {
    Position = new PVector(0,0,0);
    Size = csize;

    _colour = color(200,200,200);
  }

  public void Draw() {
    if (_alive) 
    {
      noStroke();

      fill(120,120,120,120);
      ellipse(Position.x,Position.y, Size + sin(_elapsedtime) * Size * 4, Size + sin(_elapsedtime) * Size * 4);

      fill(_colour);
      ellipse(Position.x,Position.y,Size,Size);

      stroke(EYE_COLOUR);
      point(Position.x, Position.y);
    }
  }

  public void Update() {
    if (_changed) {
      _alive = _newalive;
      _changed = false;
    }

    if (_alive) {
      float r = lerp(red(_colour),0, 0.05f);
      float g = lerp(green(_colour),0, 0.05);
      float b = lerp(blue(_colour),0, 0.05);
      _colour = color(r,g,b);
    }

  }

  public void SurroundingCells(Cell[] neighbours) {
    // maybe add some safety
    _neighbours = neighbours;
  }

  // how many cells surrounding us are alive?
  public int SurroundingCellsAlive() {
    int alive_cells = 0;

    for (int i=0; i < _neighbours.length; i++) {
      if (_neighbours[i].isAlive())
        alive_cells += 1;
    }

    return alive_cells;
  }

  public void Underpopulated() {
    death();
  }

  public void Overcrowded() {
    death();
  }

  public void Reproduced() {
    alive();
  }

  public void Survived() {
    _elapsedtime += 0.05;
  }

  // creation via mouse click
  public void Spawn() {
    _alive = true;
  }

  // removal via mouse click
  public void Despawn() {
    _alive = false;
  }
  
  // mouse is hovering over us
  public void Highlight() {
    _colour = color(HIGHLIGHT_COLOUR);
  }

  public boolean isAlive() {
    return _alive;
  }

  // this cell will become alive on the next update
  private void alive() {
    _changed = true;
    _newalive = true;
  }

  // this cell will die on the next update
  private void death() {
    _changed = true;
    _newalive = false;

    _elapsedtime = 0;
  }
}

