const char* sound_render_source = 
"out vec4 color;"
"float t=(gl_FragCoord.s+time*4096)/44100.0;"
"float sample_pos=t*"TIMERES";"
"float kick(){"
"vec4 x=channel(t,"KICK");"
"if (x.x<1) return 0;"
"float tt=t-x.y;"
"float v=cos(pow(1-tt*4,3)*100);"
"float m=bcos(0.3,tt/x.z*pi2)*-0.5+0.5;"
"return v*m*0.7;"
"}"
"float kosh(){"
"vec4 x=channel(t,"KOSH");"
"if (x.x<1) return 0;"
"float tt=t-x.y;"
"float v=rand(vec2(tt,tt));"
"float m=bcos(0.1,tt/x.z*pi2)*-0.5+0.5;"
"return v*m*0.3;"
"}"
"float noise(){"
"vec4 x=channel(t,"NOISE");"
"if (x.x<1) return 0;"
"float tt=t-x.y;"
"float v=sin(rand(vec2(floor(tt*10),0))*tt*1000);"
"float m=bcos(0.1,tt/x.z*pi2*20)*-0.5+0.5;"
"return v*m*0.3;"
"}"
"void main(){"
"float t=(gl_FragCoord.s/4096+time);"
"float f=0;"
"for (int i=0;i<10;++i){"
"f+=texture2DRect(tex,vec2((t*4096)/44100*"TIMERES",i)).y;"
"}"
"vec4 k=texture2DRect(tex,vec2((t*4096)/44100*"TIMERES",0));"
"color=(vec4(kick()+kosh()+noise())*0.5+0.5);"
"}"
;

const char* sound_source = 
"in Fragment{"
"vec4 pos;"
"}frag;"
"out vec4 color;"
"void main(){"
"color=frag.pos;"
"}"
;

const char* vertex_source = 
"in vec4 vertex;"
"void main(){"
"gl_Position=vertex;"
"}"
;

const char* display_source = 
"out vec4 color;"
"void main(){"
"vec2 coord=gl_FragCoord.st;"
"color=texture2DRect(tex,coord*"SCALE");"
"}"
;

const char* filter_source = 
"float w(float x){"
"return (pow(2.718281828,-(x*x)))/7.3;"
"}"
"out vec4 color;"
"void main(){"
"vec2 coord=gl_FragCoord.st;"
"vec2 m;"
"if (textureSize(tex).x == " FB_W ") m=vec2(1,0);"
"else m=vec2(0,1);"
"coord*=m*3+1;"
"float x=-1.625;"
"for (int i=-8;i<8;++i){"
"color+=w(x)*texture2DRect(tex,coord+vec2(i,i)*m);"
"x+=0.25;"
"}"
"}"
;

const char* sound_geom_source = 
"layout(points) in;"
"layout(line_strip,max_vertices=4) out;"
"out Fragment{"
"vec4 pos;"
"}frag;"
"void note(float ch,float pos,float l,float f){"
"vec4 v=vec4(pos,ch,0,1)*vec4(2.0/"RUNTIME",2.0/"CHANNELS",0,1)-vec4(1,0.95,0,0);"
"gl_Position=v;"
"frag.pos=vec4(1,pos,l,f);"
"EmitVertex();"
"gl_Position=v+vec4(l*2/"RUNTIME",0,0,0);"
"frag.pos=vec4(1,pos,l,f);"
"EmitVertex();"
"}"
"void kick(int id){"
"note("KICK",id*0.5,0.25,0);"
"}"
"void kosh(int id){"
"note("KOSH",id*0.5+0.3,0.1,0);"
"}"
"void noise(int id){"
"note("NOISE",id*2,2,0);"
"}"
"void main(){"
"int id=int(gl_in[0].gl_Position.x);"
"if (id<30){"
"kick(id);"
"return;"
"}"
"if (id<60){"
"kosh(id-30);"
"return;"
"}"
"if (id<70){"
"noise(id-52);"
"return;"
"}"
"if (id<110){"
"kick(id-30);"
"return;"
"}"
"if (id<120){"
"kosh(id-60);"
"return;"
"}"
"}"
;

const char* transform_source = 
"out Vertex{"
"vec3 pos1;"
"vec3 pos2;"
"vec3 color;"
"float size;"
"float cull;"
"}vertex;"
"vec3 tr(vec4 p){"
"float r=length(p);"
"float i=acos(p.z/r)*0.8;"
"float a=atan(p.x,p.y);"
"return vec3(sin(a)*i,cos(a)*i,pow(r/5000.0,0.25));"
"}"
"vec3 la(float p){"
"return vec3(bcos(0,p*0.5+time*10),bsin(1,p*0.5+time*sin(time*10))*2,0);"
"}"
"int chars[28]=int[](0,131618,630678,497559,430486,498071,988959,71455,433430,630681,139810,432264,611161,987409,629241,630201,432534,71575,678294,628631,1019678,139823,432537,305561,653721,628377,280217,988815);"
"int greet1[22]=int[](8,19,6,6,21,10,15,8,20,0,20,21,19,6,2,14,13,10,15,8,20,1);"
"int greet2[18]=int[](21,9,6,0,9,16,19,19,16,19,0,10,20,0,16,23,6,19);"
"vec3 g1(){"
"int word=gl_VertexID/20;"
"int dot=gl_VertexID % 20;"
"int x=dot % 4;"
"int y=dot/4;"
"int l=chars[greet1[word % 22]];"
"vertex.cull=1;"
"if (bool(l & (1<<dot))) vertex.cull=0;"
"return vec3(word*5+x-11*5,y+bcos(0.2,time*pi2*2),150+(-time*20))*0.01;"
"}"
"vec3 g2(){"
"int word=gl_VertexID/20;"
"int dot=gl_VertexID % 20;"
"int x=dot % 4;"
"int y=dot/4;"
"int l=chars[greet2[word % 23]];"
"vertex.cull=1;"
"if (bool(l & (1<<dot))) vertex.cull=0;"
"return vec3(word*5+x-9*5,y+bcos(0.2,time*pi2*4),800+(-time*20))*0.01;"
"}"
"vec3 rand3(float x){"
"return vec3(rand(vec2(x,0)),rand(vec2(0,x)),rand(vec2(x,x)));"
"}"
"vec3 turntable(vec3 p,float t1,float t2){"
"mat4 m=mat4(cos(t1),0,sin(t2),0,  0,1,0,0, -sin(t1),0,cos(t2),0, 0,0,0,1) *"
"mat4(1000,0,0,0, 0,-1000*"ASPECT",0,0,0,0,1000,1000,0,0,0,1);"
"return tr(vec4(p,1)*m);"
"}"
"vec3 animate(float p,float t){"
"vec3 p1=vec3(0);"
"vertex.cull=0;"
"if (t<20){"
"if (gl_VertexID<20*22){"
"p1=g1();"
"vertex.color=vec3(0);"
"vertex.size=0.015;"
"return turntable(p1,0,0);"
"}"
"}"
"if (t>35 && t<100){"
"if (gl_VertexID<20*18){"
"p1=g2();"
"vertex.color=vec3(0);"
"vertex.size=0.015;"
"return turntable(p1,0,0);"
"}"
"}"
"if (gl_VertexID<20*27) vertex.cull=1;"
"if (t>0 && t<20){"
"p1=rand3(p)*2-1;"
"vertex.color=vec3(0);"
"vertex.size=0.03;"
"return turntable(p1,t,t);"
"}"
"if (t>20 && t<25){"
"p1=rand3(p)*2-1;"
"vertex.color=rand3(p*2);"
"vertex.size=0.1;"
"return turntable(p1+p1*bcos(0.1,t*pi2*2)*0.2,t,t);"
"}"
"if (t>25 && t<27){"
"p1=rand3(p)*2-1;"
"vertex.color=rand3(p*2);"
"vertex.size=0.1;"
"return turntable(p1,bcos(0.2,t*pi2*2),bsin(0.2,t*pi2*2));"
"}"
"if (t>27 && t<35){"
"p1=rand3(p)*2 -1;"
"vertex.color=rand3(p*2);"
"vertex.size=0.1;"
"return turntable(p1,-t*2,t+cos(t*5));"
"}"
"if (t>35){"
"p1=rand3(p)*2-1;"
"vertex.color=rand3(p*2);"
"vertex.size=0.1/(t-34);"
"return turntable(p1/(t-34),t,bcos(0.1,t));"
"}"
"vertex.cull=1;"
"return turntable(p1,0,0);"
"}"
"void main(){"
"float p=gl_VertexID/"POINTS"*pi2;"
"vec3 p1=animate(p,time);"
"vec3 p2=animate(p,time+1.0/60.0);"
"vec3 r=vec3(p*1.1,p*2.3,p*4.7);"
"vertex.pos1=p1;"
"vertex.pos2=p2;"
"}"
;

const char* bound_source = 
"layout(points) in;"
"layout(triangle_strip,max_vertices=4) out;"
"in Vertex{"
"vec3 pos1;"
"vec3 pos2;"
"vec3 color;"
"float size;"
"float cull;"
"}vertex[];"
"out Fragment{"
"vec3 pos1;"
"vec3 pos2;"
"vec3 color;"
"float size;"
"}frag;"
"void main(){"
"if (vertex[0].cull>0) return;"
"vec4 p1=vec4(vertex[0].pos1,1.0);"
"vec4 p2=vec4(vertex[0].pos2,1.0);"
"vec4 d=vec4(normalize(p2.xy-p1.xy),0,0);"
"if (distance(p2.xy,p1.xy)<0.0001) d=vec4(1,0,0,0);"
"vec4 n=vec4(-d.y,d.x,0,0);"
"float size=vertex[0].size;"
"float z1=distance(p1.z,focus.x)*focus.y+size*(1.0-p1.z);"
"float z2=distance(p2.z,focus.x)*focus.y+size*(1.0-p2.z);"
"frag.pos1=p1.xyz*vec3("ASPECT",1,1);"
"frag.pos2=p2.xyz*vec3("ASPECT",1,1);"
"frag.color=vertex[0].color;"
"frag.size=size;"
"gl_Position=p1-n*z1-d*z1;"
"EmitVertex();"
"gl_Position=p1+n*z1-d*z1;"
"EmitVertex();"
"gl_Position=p2-n*z2+d*z2;"
"EmitVertex();"
"gl_Position=p2+n*z2+d*z2;"
"EmitVertex();"
"}"
;

const char* sample_source = 
"in Fragment{"
"vec3 pos1;"
"vec3 pos2;"
"vec3 color;"
"float size;"
"}frag;"
"out vec4 color;"
"void main(){"
"vec2 xy=(gl_FragCoord.xy/"FB"*2-1)*vec2("ASPECT",1);"
"float t=rand(xy+time);"
"float a=6.3*rand(xy*1.1+time);"
"float r=rand(xy*1.2+time);"
"vec2 lens=vec2(sin(a)*r,cos(a)*r);"
"vec3 pos=mix(frag.pos1,frag.pos2,t);"
"vec2 m=pos.st-xy+lens*distance(pos.z,focus.x)*focus.y;"
"float d=length(m);"
"if (d<frag.size*(1.0-pos.z)){"
"color=vec4(frag.color,1);"
"gl_FragDepth=clamp(pos.z,0.0,0.99);"
"}else{"
"gl_FragDepth=1.95;"
"color=vec4(0.05);"
"}"
"}"
;

const char* common_source = 
"#version 150\n"
"#extension GL_ARB_texture_rectangle : enable\n"
"uniform sampler2DRect tex;"
"uniform float time;"
"vec2 focus=vec2(0.7,0.3);"
"float rand(vec2 co){"
"return fract(sin(dot(co.xy,vec2(12.9898,78.233)))*43758.5453);"
"}"
"float bcos(float s,float x){"
"return cos(x)/(s+abs(cos(x)))*(1+s);"
"}"
"float bsin(float s,float x){"
"return sin(x)/(s+abs(sin(x)))*(1+s);"
"}"
"vec4 channel(float t,float i){"
"return texture2DRect(tex,vec2(t*"TIMERES",i));"
"}"
"float pi=acos(-1.0);"
"float pi2=pi*2;"
;

const char* id_source = 
"in vec4 vertex;"
"void main(){"
"gl_Position=vec4(gl_VertexID,0,0,1);"
"}"
;

