var loadDone=0;
var demoDone=0;
var gl;
var windowWidth;
var windowHeight;
var windowAspect;

function engineStart() {
	//init (and load, duh) audio if needed.
	if (audioLoaded == 0) {audioInit();}

	//init WebGL
	loadMessage("Initing WebGL...")
	var canvas = document.getElementById("webglcanvas");
	glInit(canvas);
	if (loadDone == -1) {return;}

	loadMessage("Loading demo...")
	//init demo-specific stuff
	demoInit();
	if (loadDone == -1) {return;}

	//clear
	gl.clearColor(0.0, 0.0, 0.0, 1.0);
	gl.enable(gl.DEPTH_TEST);

	//ready to go
	if (audioLoaded && loadDone == 0) {
		prepareIndex();
	} else {
		loadMessage("Loading audio...")
	}

	loadDone=1;
}

function prepareIndex() {
	document.getElementById("playbutton").style.display = 'block';
	document.getElementById("status").style.display = 'none';
}

function glInit(canvas) {
	//self-explanatory
	//TODO: should probably change to the suggested init-way (check google's way)
	try {
		gl = canvas.getContext("experimental-webgl");
	} catch (e) {
	}
	if (!gl) {
		loadError("WebGL init failed.");
	}
}

function loadMessage(msg) {
	//don't update if load finished or error has occured
	if (loadDone == 0) {
		statusLabel = document.getElementById('status');
		statusLabel.innerHTML = msg;
	}
}

function loadError(msg) {
	statusLabel = document.getElementById('status');
	//on first error, clear loading messages, else add error after previous
	if (loadDone == 0) {
		statusLabel.innerHTML = "ERROR: "+ msg + "<br/>";
	} else {
		statusLabel.innerHTML += msg + "<br />";
	}
	loadDone = -1;
}

function demoStart() {
	var canvas = document.getElementById("webglcanvas");

	//get and set width and height -stuff
	windowWidth = window.innerWidth;
	windowHeight = window.innerHeight;
	windowAspect = windowWidth/windowHeight;

	canvas.height = windowHeight;
	canvas.width = windowWidth;

  gl.viewportWidth = windowWidth;
  gl.viewportHeight = windowHeight;

	//hide menus, show demo canvas
	document.getElementById('playbutton').style.display = 'none';
	document.getElementById('status').style.display = 'none';
	document.getElementById("header").style.display = 'none';
	canvas.style.display = 'block';

	//dev-mode buttons
	if (devmode) {
//		document.addEventListener("keypress", debugKeys, false);
		document.onkeydown = debugKeys;
	}

	//I need a rising sound.
	audioPlay();

	//c'mon baby, run my "designz"!
	demoMain();
}
