#version 330
#define GL_core_profile 1

/*
	L: Directional vector from point to light
	N: Vertex/fragment normal vector
	R: Vertex/Fragment reflected vector
	V: Vertex/fragment to camera vector
*/

in vec3 fNormal; // fragment normal (N)
in vec3 V;
in vec3 lp;
in vec3 lightDirection;
in vec3 eyeVector;
in vec3 vColor;

out vec3 color;

const vec3 ambient = vec3(0.075, 0.075, 0.075);
const vec3 diffuse = vec3(0.3, 0.3, 0.3);


void main(void)
{
	color = ambient * vColor;
	vec3 N = normalize(fNormal);
	vec3 L = normalize(lightDirection);
	float lambertTerm = dot(N, L);

	if (lambertTerm > 0.0) {
		color += vColor * lambertTerm;
		vec3 E = normalize(eyeVector);
		vec3 R = reflect(-L, N);
		float specular = pow( max( dot(R,E), 0.0), 8.0);
		color += specular;
	}
}
