#include <stdio.h>
#include <math.h>

#define XOFF    50
#define XRES    160
#define RINGD   15      //diameter of rings
#define R       9       //radius of rotation
#define DIST    145     //distance

int xz_to_flags(int x, int z) {
    int w = XRES/2 * RINGD / z;
    int bright = 15 - 15 * (z - DIST + R) / (2*R);

    //convert width to CTRLPF/NUSIZx flags
    if      (w < 2) return 0x30 | bright;
    else if (w < 4) return 0x30 | bright;
    else if (w < 8) return 0x30 | bright;
    else            return 0x30 | bright;
}


int xz_to_x(int x, int z) {
    int w = 1 << (xz_to_flags(x,z) >> 4);
    return XOFF + XRES/2 * x / z - w/2;
}

int main() {
    int i, tabsize = 64;

    printf("TABSIZE equ %i\n", tabsize);
    printf("TABMASK equ %i\n", tabsize-1);

    printf("XTab\n");

    for (i = 0; i < tabsize; i++) {
        float a = i * 2*M_PI / tabsize;
        int x = cosf(a) * R;
        int z = sinf(a) * R + DIST;

        printf("\t.byte %i\n", xz_to_x(x, z));
    }

    printf("Palette\n");

    for (i = 0; i < tabsize; i++)
        printf("\t.byte %i\n", (int)((1 + sinf((i + tabsize/2) * 2*M_PI/tabsize))/2 * 9 + 6));

    return 0;
}
