    MAC ROTOZOOM_VARS
rotoline    ds  1
grp0next    ds  1
grp1next    ds  1
x0          ds  1
y0          ds  1
x           ds  1
dx          ds  1
dy          ds  1
dx0         ds  1
dy0         ds  1
    ENDM

    MAC ROTOZOOM_LOGIC
RotozoomLogic
    lda #0
    sta grp0next
    sta grp1next

    ldx frame
    lda SinTab,X
    asl
    asl
    sta x0
    txa
    clc
    adc #90
    tax
    lda SinTab,X
    asl
    asl
    sta y0

    lda SinTab,X
    lsr
    lsr
    lsr
    sec
    sbc #10
    sta dx
    sta dy0
    txa
    clc
    adc #64
    tax
    lda SinTab,X
    lsr
    lsr
    lsr
    sec
    sbc #16
    sta dx0
    eor #$FF
    sta dy

XPOS    equ 50
    lda #XPOS+32
    ldx #0
    jsr PositionObject
    lda #XPOS
    ldx #1
    jsr PositionObject

    sta WSYNC
    sta HMOVE

    lda #$07
    sta NUSIZ0      ;quad sized players
    sta NUSIZ1

    rts
    ENDM

    MAC ROTOZOOM_KERNEL
    lda measure
    sec
    sbc #INTROLEN-4
    asl
    asl
    and #$F0
    eor #$56
    sta COLUBK
    lda measure
    sec
    sbc #INTROLEN-4
    asl
    and #$F8
    eor #$D6
    sta COLUP0
    sta COLUP1

.TRIANGLES SET {1}
    lda #LINES/7
    sta rotoline
.RotozoomKernel_Loop
    lda x0
    clc
    adc dx0
    sta x0
    sta x
    lda y0
    clc
    adc dy0
    sta y0
    tay

    ;setting the first bit is easier
    IF .TRIANGLES
    cmp x
    ror grp0next
    ELSE
    eor x
    and #%10000000
    sta grp0next
    ENDIF

    ldx #7          ;bits
.DoBit0
    lda x
    adc dx
    sta x

    tya
    adc dy
    tay

    IF .TRIANGLES
    cmp x
    ELSE
    eor x
    cmp #%10000000
    ENDIF
    ror grp0next

    dex
    bne .DoBit0

    ldx #8          ;bits
.DoBit1
    lda x
    adc dx
    sta x

    tya
    adc dy
    tay

    IF .TRIANGLES
    cmp x
    ELSE
    eor x
    cmp #%10000000
    ENDIF
    ror grp1next

    dex
    bne .DoBit1

    sta WSYNC
    lda grp1next
    sta GRP1
    lda grp0next
    sta GRP0

    dec rotoline
    bne .RotozoomKernel_Loop

#if PAL
    sta WSYNC
    sta WSYNC
    sta WSYNC
    sta WSYNC
#endif

    lda #0
    sta GRP0
    sta GRP1

    jmp DoneKernel
    ENDM
