NHORISZCLR  equ 11   ;number of horizontal colors per line
                     ;with the interlacing and staggering we're doing this comes out as 22 pixels

;    MAC PLASMA_VARS
;ramkernel   ds  KERNELSIZE
;    ENDM

    MAC PLASMA_LOGIC
PlasmaLogic
    ;copy kernel to RAM
    ldx #KERNELSIZE-1
CopyKernel
    lda PlasmaRAMKernel,X
    sta ramkernel,X
    dex
    bpl CopyKernel

    ;circular camera path
    ldx #4*(NHORISZCLR-1)
    ldy frame
    lda SinTab,Y
    lsr
    lsr
    tay

    ;update the delta values in the RAM kernel
LoadHorizClr
    lda PlasmaTabDelta,y
    sta DeltaBaseA,X
    iny
    dex
    dex
    dex
    dex
    bpl LoadHorizClr

    ldx #4*(NHORISZCLR-1)
    ldy frame
    lda SinTab,Y
    lsr
    lsr
    adc #0                  ;round odd line offsets up, resulting in smoother horizontal scroll
    tay
LoadHorizClr2
    lda PlasmaTabDelta,y
    sta DeltaBaseB,X
    iny
    dex
    dex
    dex
    dex
    bpl LoadHorizClr2
    rts
    ENDM

PlasmaRAMKernel
    ;2x dec temp is cheaper on ROM than 5x NOP
    dec temp
    dec temp

    lda PlasmaTab,Y
DeltaBaseA equ * - PlasmaRAMKernel + ramkernel + 1
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK

    sta WSYNC

    dec temp            ;cheaper on ROM than SLEEP
    dec temp

    dey

    lda PlasmaTab,Y
DeltaBaseB equ * - PlasmaRAMKernel + ramkernel + 1
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK
    adc #02
    sta COLUBK

    dex
    bne PlasmaRAMKernel
    rts

KERNELSIZE  equ *-PlasmaRAMKernel
    echo "PlasmaRAMKernel:",*-PlasmaRAMKernel
    echo "DeltaBaseA (in RAM):",DeltaBaseA
    echo "DeltaBaseB (in RAM):",DeltaBaseB

PlasmaKernel
    lda frame
    adc #64
    tax
    ldy SinTab,X
    ldx #LINES/2
    jsr ramkernel
    lda #0
    sta COLUBK
    jmp DoneKernel
