
uniform float time;

//uniform vec3 lightDir;

//varying float intensity;


void main(void){
	gl_FrontColor = gl_Color; //set color to that what was in glColor() in opengl
	
	gl_Position = ftransform(); //default vertex position
	
	//gl_Position = gl_ProjectionMatrix * gl_ModelViewMatrix * gl_Vertex;
	//gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
	//gl_Position = ftransform();
	
	//make sin of all screen
	vec4 v = gl_ModelViewProjectionMatrix * vec4(gl_Vertex);
	//v.z = sin(5.0*v.x + time*10.0)*0.25;
	v.y += sin(5.0*v.x + time*10.0)*0.05;
	gl_Position = v;
	
	//light
	vec3 normal, lightDir;
	vec4 diffuse;
	float NdotL;
	normal = normalize(gl_NormalMatrix * gl_Normal);
	lightDir = normalize(vec3(gl_LightSource[0].position));
	NdotL = max(dot(normal, lightDir), 0.0);
	diffuse = gl_FrontMaterial.diffuse * gl_LightSource[0].diffuse;
	gl_FrontColor =  NdotL * diffuse;
}
