#!/bin/ksh

MPLAYER_PID=0;
MPLAYER_PATH=""

########################################################################
#               ---+++###  U N R E A L I S E D  ###+++---              #
#                                                                      #
#                                                         by mec, MMXI #
########################################################################

quit()
{
	if [ "${MPLAYER_PID}" != "0" ]; then
		kill -9 ${MPLAYER_PID}
	fi
	clear
	echo "Thank you for watching..."
	echo "unrealised by mec - MMXI"
	if [ "`uname`" = "Linux" ]; then
		setterm -cursor on
	fi
	exit 0
}

########################################################################

play()
{
	for TEMP in `whereis mplayer`; do
		if [ -x ${TEMP} ]; then
			MPLAYER_PATH=${TEMP}
			break;
		fi
	done
	if [ "${MPLAYER_PATH}" = "" ]; then
		echo "No mplayer - no sound"
		echo "Please wait..."
		sleep 5
	else
# load all required libs firstly
		mplayer -really-quiet
# and now play the music
		mplayer -really-quiet heavybutterfly.mp3 2> /dev/null &
		MPLAYER_PID=$!
	fi
}

########################################################################

check()
{
	tput cup 1 0 2> /dev/null
	if [ "$?" != "0" ]; then
		if [ "${TERM}" = "" ]; then
			TERM="<unknown>"
		fi
		echo "Unknown terminal type: ${TERM}."
		exit 1
	fi
	if [ "${SystemRoot}" != "" ]; then
		# Windows (UWIN)
		CURSHLVL=${SHLVL}
		SHLVL=1
		export SHLVL
		STTY=`stty -a`
		COLS=`echo ${STTY} | grep columns | cut -d ' ' -f 7 | cut -d ';' -f 1`
		SHLVL=${CURSHLVL}
		export SHLVL
		MINWIDTH="80"
	elif [ "${SYSTEMROOT}" != "" ]; then
		# Windows (Cygwin)
		COLS=`tput cols`
		MINWIDTH="81"
	else
		# Unixes
		COLS=`tput cols`
		MINWIDTH="80"
		if [ "`uname`" = "Linux" ]; then
			setterm -cursor off
		fi
	fi
	if [ "${COLS}" = "" ]; then
		COLS=0
	fi
	if [ "${COLS}" -lt "${MINWIDTH}" ]; then
		echo "Terminal width must have at least ${MINWIDTH} characters per line."
		echo "Now is ${COLS}."
		exit 1
	fi
}

########################################################################

fire_init()
{
	FIRE_CHARACTERS[7]="#"
	FIRE_CHARACTERS[6]="#"
	FIRE_CHARACTERS[5]="*"
	FIRE_CHARACTERS[4]="+"
	FIRE_CHARACTERS[3]="."
	FIRE_CHARACTERS[2]=" "
	FIRE_CHARACTERS[1]=" "
	FIRE_CHARACTERS[0]=" "
	FIRE_BUFFER1=""
	FIRE_BUFFER2=""
	LINE=""
	for A in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39" "40" "41" "42" "43" "44" "45" "46" "47" "48" "49" "50" "51" "52" "53" "54" "55" "56" "57" "58" "59" "60" "61" "62" "63" "64" "65" "66" "67" "68" "69" "70" "71" "72" "73" "74" "75" "76" "77" "78" "79" "80" "81" "82" "83" "84" "85" "86" "87" "88" "89" "90" "91" "92" "93" "94" "95" "96" "97" "98" "99" "100" "101" "102" "103" "104" "105" "106" "107" "108" "109" "110" "111" "112" "113" "114" "115" "116" "117" "118" "119" "120" "121" "122" "123" "124" "125" "126" "127" "128" "129" "130" "131" "132" "133" "134" "135" "136" "137" "138" "139" "140" "141" "142" "143" "144" "145" "146" "147" "148" "149" "150" "151" "152" "153" "154" "155" "156" "157" "158" "159" "160" "161" "162" "163" "164" "165" "166" "167" "168" "169" "170" "171" "172" "173" "174" "175" "176" "177" "178" "179" "180" "181" "182" "183" "184" "185" "186" "187" "188" "189" "190" "191" "192" "193" "194" "195" "196" "197" "198" "199" "200" "201" "202" "203" "204" "205" "206" "207" "208" "209" "210" "211" "212" "213" "214" "215" "216" "217" "218" "219" "220" "221" "222" "223" "224" "225" "226" "227" "228" "229" "230" "231" "232" "233" "234" "235" "236" "237" "238" "239" "240" "241" "242" "243" "244" "245" "246" "247" "248" "249" "250" "251" "252" "253" "254" "255" "256" "257" "258" "259" "260" "261" "262" "263" "264" "265" "266" "267" "268" "269" "270" "271" "272" "273" "274" "275" "276" "277" "278" "279" "280" "281" "282" "283" "284" "285" "286" "287" "288" "289" "290" "291" "292" "293" "294" "295" "296" "297" "298" "299" "300" "301" "302" "303" "304" "305" "306" "307" "308" "309" "310" "311" "312" "313" "314" "315" "316" "317" "318" "319" "320" "321" "322" "323" "324" "325" "326" "327" "328" "329" "330" "331" "332" "333" "334" "335" "336" "337" "338" "339" "340" "341" "342" "343" "344" "345" "346" "347" "348" "349" "350" "351" "352" "353" "354" "355" "356" "357" "358" "359" "360" "361" "362" "363" "364" "365" "366" "367" "368" "369" "370" "371" "372" "373" "374" "375" "376" "377" "378" "379" "380" "381" "382" "383" "384" "385" "386" "387" "388" "389" "390" "391" "392" "393" "394" "395" "396" "397" "398" "399" "400" "401" "402" "403" "404" "405" "406" "407" "408" "409" "410" "411" "412" "413" "414" "415" "416" "417" "418" "419" "420" "421" "422" "423" "424" "425" "426" "427" "428" "429" "430" "431" "432" "433" "434" "435" "436" "437" "438" "439" "440" "441" "442" "443" "444" "445" "446" "447" "448" "449" "450" "451" "452" "453" "454" "455" "456" "457" "458" "459" "460" "461" "462" "463" "464" "465" "466" "467" "468" "469" "470" "471" "472" "473" "474" "475" "476" "477" "478" "479" "480" "481" "482" "483" "484" "485" "486" "487" "488" "489" "490" "491" "492" "493" "494" "495" "496" "497" "498" "499" "500" "501" "502" "503" "504" "505" "506" "507" "508" "509" "510" "511" "512" "513" "514" "515" "516" "517" "518" "519" "520" "521" "522" "523" "524" "525" "526" "527" "528" "529" "530" "531" "532" "533" "534" "535" "536" "537" "538" "539" "540" "541" "542" "543" "544" "545" "546" "547" "548" "549" "550" "551" "552" "553" "554" "555" "556" "557" "558" "559" "560" "561" "562" "563" "564" "565" "566" "567" "568" "569" "570" "571" "572" "573" "574" "575" "576" "577" "578" "579" "580" "581" "582" "583" "584" "585" "586" "587" "588" "589" "590" "591" "592" "593" "594" "595" "596" "597" "598" "599" "600" "601" "602" "603" "604" "605" "606" "607" "608" "609" "610" "611" "612" "613" "614" "615" "616" "617" "618" "619" "620" "621" "622" "623" "624" "625" "626" "627" "628" "629" "630" "631" "632" "633" "634" "635" "636" "637" "638" "639" "640" "641" "642" "643" "644" "645" "646" "647" "648" "649" "650" "651" "652" "653" "654" "655" "656" "657" "658" "659" "660" "661" "662" "663" "664" "665" "666" "667" "668" "669" "670" "671" "672" "673" "674" "675" "676" "677" "678" "679" "680" "681" "682" "683" "684" "685" "686" "687" "688" "689" "690" "691" "692" "693" "694" "695" "696" "697" "698" "699" "700" "701" "702" "703" "704" "705" "706" "707" "708" "709" "710" "711" "712" "713" "714" "715" "716" "717" "718" "719" "720" "721" "722" "723" "724" "725" "726" "727" "728" "729" "730" "731" "732" "733" "734" "735" "736" "737" "738" "739" "740" "741" "742" "743" "744" "745" "746" "747" "748" "749" "750" "751" "752" "753" "754" "755" "756" "757" "758" "759" "760" "761" "762" "763" "764" "765" "766" "767" "768" "769" "770" "771" "772" "773" "774" "775" "776" "777" "778" "779" "780" "781" "782" "783" "784" "785" "786" "787" "788" "789" "790" "791" "792" "793" "794" "795" "796" "797" "798" "799" "800" "801" "802" "803" "804" "805" "806" "807" "808" "809" "810" "811" "812" "813" "814" "815" "816" "817" "818" "819" "820" "821" "822" "823" "824" "825" "826" "827" "828" "829" "830" "831" "832" "833" "834" "835" "836" "837" "838" "839" "840" "841" "842" "843" "844" "845" "846" "847" "848" "849" "850" "851" "852" "853" "854" "855" "856" "857" "858" "859" "860" "861" "862" "863" "864" "865" "866" "867" "868" "869" "870" "871" "872" "873" "874" "875" "876" "877" "878" "879" "880" "881" "882" "883" "884" "885" "886" "887" "888" "889" "890" "891" "892" "893" "894" "895" "896" "897" "898" "899" "900" "901" "902" "903" "904" "905" "906" "907" "908" "909" "910" "911" "912" "913" "914" "915" "916" "917" "918" "919" "920" "921" "922" "923" "924" "925" "926" "927" "928" "929" "930" "931" "932" "933" "934" "935" "936" "937" "938" "939" "940" "941" "942" "943" "944" "945" "946" "947" "948" "949" "950" "951" "952" "953" "954" "955" "956" "957" "958" "959" "960" "961" "962" "963" "964" "965" "966" "967" "968" "969" "970" "971" "972" "973" "974" "975" "976" "977" "978" "979" "980" "981" "982" "983" "984" "985" "986" "987" "988" "989" "990" "991" "992" "993" "994" "995" "996" "997" "998" "999" "1000" "1001" "1002" "1003" "1004" "1005" "1006" "1007" "1008" "1009" "1010" "1011" "1012" "1013" "1014" "1015" "1016" "1017" "1018" "1019" "1020" "1021" "1022" "1023" ; do
		FIRE_BUFFER1[${A}]=0
		FIRE_BUFFER2[${A}]=0
	done
}

########################################################################

fire_render()
{
	FIRE_COUNTER="0"
	FINISH=$((`date +%s`+$1))

	tput cup 12 0
	LINE="         #####    ++       ++++           ##  ++++      ...   ++++++  ....  ####\n"
	LINE="${LINE}#####    #####+++ ++....   ++++  ...   +++##  ++++      ...   ++++++  ....  ####\n"
	LINE="${LINE}#####++  #####+++ ####..  ##+++  ... ####+##  ++++  ++  ...   ++++######..  ####\n"
	LINE="${LINE}#####++  #####+++ ####..  ##+++  ... ####+##  ++++  ++  ...   ++++######..  ####\n"
	LINE="${LINE}#####++..#####+++ ####..  ##+++  ... ####+#####+++  ++  ##### ++++######.. +####\n"
	LINE="${LINE}#####++..#####+++ ####.. +##+++  ... ####+#####+++  ++  ##### ++++######.. +####\n"
	LINE="${LINE}#####++..#####+++ ####.. +##+++  .#######+#####+++###+  ##### ++++######.. +####\n"
	LINE="${LINE}#####++..#####+++ ####.. +##+++ ..#######+#####+++###+  ##### ++++######.. +####\n"
	LINE="${LINE}#####++..#####+++ ####.. +##+++ ..#######+#####+++###+  ##### ++++######.. +####\n"
	LINE="${LINE}################################################################################\n"
	LINE="${LINE}################################################################################"
	print "${LINE}"

	while [ ${FINISH} -ge `date +%s` ]; do
# buffer 1 - calculate
		for X in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39" "40" "41" "42" "43" "44" "45" "46" "47" "48" "49" "50" "51" "52" "53" "54" "55" "56" "57" "58" "59" "60" "61" "62" "63" "64" "65" "66" "67" "68" "69" "70" "71" "72" "73" "74" "75" "76" "77" "78" "79" "80" "81" "82" "83" "84" "85" "86" "87" "88" "89" "90" "91" "92" "93" "94" "95" "96" "97" "98" "99" "100" "101" "102" "103" "104" "105" "106" "107" "108" "109" "110" "111" "112" "113" "114" "115" "116" "117" "118" "119" "120" "121" "122" "123" "124" "125" "126" "127" "128" "129" "130" "131" "132" "133" "134" "135" "136" "137" "138" "139" "140" "141" "142" "143" "144" "145" "146" "147" "148" "149" "150" "151" "152" "153" "154" "155" "156" "157" "158" "159" "160" "161" "162" "163" "164" "165" "166" "167" "168" "169" "170" "171" "172" "173" "174" "175" "176" "177" "178" "179" "180" "181" "182" "183" "184" "185" "186" "187" "188" "189" "190" "191" "192" "193" "194" "195" "196" "197" "198" "199" "200" "201" "202" "203" "204" "205" "206" "207" "208" "209" "210" "211" "212" "213" "214" "215" "216" "217" "218" "219" "220" "221" "222" "223" "224" "225" "226" "227" "228" "229" "230" "231" "232" "233" "234" "235" "236" "237" "238" "239" "240" "241" "242" "243" "244" "245" "246" "247" "248" "249" "250" "251" "252" "253" "254" "255" "256" "257" "258" "259" "260" "261" "262" "263" "264" "265" "266" "267" "268" "269" "270" "271" "272" "273" "274" "275" "276" "277" "278" "279" "280" "281" "282" "283" "284" "285" "286" "287" "288" "289" "290" "291" "292" "293" "294" "295" "296" "297" "298" "299" "300" "301" "302" "303" "304" "305" "306" "307" "308" "309" "310" "311" "312" "313" "314" "315" "316" "317" "318" "319" "320" "321" "322" "323" "324" "325" "326" "327" "328" "329" "330" "331" "332" "333" "334" "335" "336" "337" "338" "339" "340" "341" "342" "343" "344" "345" "346" "347" "348" "349" "350" "351" "352" "353" "354" "355" "356" "357" "358" "359" "360" "361" "362" "363" "364" "365" "366" "367" "368" "369" "370" "371" "372" "373" "374" "375" "376" "377" "378" "379" "380" "381" "382" "383" "384" "385" "386" "387" "388" "389" "390" "391" "392" "393" "394" "395" "396" "397" "398" "399" "400" "401" "402" "403" "404" "405" "406" "407" "408" "409" "410" "411" "412" "413" "414" "415" "416" "417" "418" "419" "420" "421" "422" "423" "424" "425" "426" "427" "428" "429" "430" "431" "432" "433" "434" "435" "436" "437" "438" "439" "440" "441" "442" "443" "444" "445" "446" "447" "448" "449" "450" "451" "452" "453" "454" "455" "456" "457" "458" "459" "460" "461" "462" "463" "464" "465" "466" "467" "468" "469" "470" "471" "472" "473" "474" "475" "476" "477" "478" "479" "480" "481" "482" "483" "484" "485" "486" "487" "488" "489" "490" "491" "492" "493" "494" "495" "496" "497" "498" "499" "500" "501" "502" "503" "504" "505" "506" "507" "508" "509" "510" "511" "512" "513" "514" "515" "516" "517" "518" "519" "520" "521" "522" "523" "524" "525" "526" "527" "528" "529" "530" "531" "532" "533" "534" "535" "536" "537" "538" "539" "540" "541" "542" "543" "544" "545" "546" "547" "548" "549" "550" "551" "552" "553" "554" "555" "556" "557" "558" "559" "560" "561" "562" "563" "564" "565" "566" "567" "568" "569" "570" "571" "572" "573" "574" "575" "576" "577" "578" "579" "580" "581" "582" "583" "584" "585" "586" "587" "588" "589" "590" "591" "592" "593" "594" "595" "596" "597" "598" "599" "600" "601" "602" "603" "604" "605" "606" "607" "608" "609" "610" "611" "612" "613" "614" "615" "616" "617" "618" "619" "620" "621" "622" "623" "624" "625" "626" "627" "628" "629" "630" "631" "632" "633" "634" "635" "636" "637" "638" "639" "640" "641" "642" "643" "644" "645" "646" "647" "648" "649" "650" "651" "652" "653" "654" "655" "656" "657" "658" "659" "660" "661" "662" "663" "664" "665" "666" "667" "668" "669" "670" "671" "672" "673" "674" "675" "676" "677" "678" "679" "680" "681" "682" "683" "684" "685" "686" "687" "688" "689" "690" "691" "692" "693" "694" "695" "696" "697" "698" "699" "700" "701" "702" "703" "704" "705" "706" "707" "708" "709" "710" "711" "712" "713" "714" "715" "716" "717" "718" "719" "720" "721" "722" "723" "724" "725" "726" "727" "728" "729" "730" "731" "732" "733" "734" "735" "736" "737" "738" "739" "740" "741" "742" "743" "744" "745" "746" "747" "748" "749" "750" "751" "752" "753" "754" "755" "756" "757" "758" "759" "760" "761" "762" "763" "764" "765" "766" "767" "768" "769" "770" "771" "772" "773" "774" "775" "776" "777" "778" "779" "780" "781" "782" "783" "784" "785" "786" "787" "788" "789" "790" "791" "792" "793" "794" "795" "796" "797" "798" "799" "800" "801" "802" "803" "804" "805" "806" "807" "808" "809" "810" "811" "812" "813" "814" "815" "816" "817" "818" "819" "820" "821" "822" "823" "824" "825" "826" "827" "828" "829" "830" "831" "832" "833" "834" "835" "836" "837" "838" "839" "840" "841" "842" "843" "844" "845" "846" "847" "848" "849" "850" "851" "852" "853" "854" "855" "856" "857" "858" "859" "860" "861" "862" "863" "864" "865" "866" "867" "868" "869" "870" "871" "872" "873" "874" "875" "876" "877" "878" "879" ; do
			X1=$((X+79))
			X2=$((X+81))
			FIRE_BUFFER1[${X}]=$(((${FIRE_BUFFER2[${X1}]}+${FIRE_BUFFER2[${X2}]})>>1))
		done

		for X in "880" "881" "882" "883" "884" "885" "886" "887" "888" "889" "890" "891" "892" "893" "894" "895" "896" "897" "898" "899" "900" "901" "902" "903" "904" "905" "906" "907" "908" "909" "910" "911" "912" "913" "914" "915" "916" "917" "918" "919" "920" "921" "922" "923" "924" "925" "926" "927" "928" "929" "930" "931" "932" "933" "934" "935" "936" "937" "938" "939" "940" "941" "942" "943" "944" "945" "946" "947" "948" "949" "950" "951" "952" "953" "954" "955" "956" "957" "958" "959"; do
			FIRE_BUFFER1[${X}]=$((${RANDOM}&7))
		done

# buffer 1 - display
		tput cup 0 0
		INDEX=0
		SCREEN=""
		for Y in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11"; do
			LINE=""
			for X in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39" "40" "41" "42" "43" "44" "45" "46" "47" "48" "49" "50" "51" "52" "53" "54" "55" "56" "57" "58" "59" "60" "61" "62" "63" "64" "65" "66" "67" "68" "69" "70" "71" "72" "73" "74" "75" "76" "77" "78" "79"; do
				LINE="${LINE}${FIRE_CHARACTERS[${FIRE_BUFFER1[${INDEX}]}]}"
				INDEX=$((${INDEX}+1))
			done
			if [ "${Y}" != "11" ]; then
				SCREEN="${SCREEN}${LINE}\n"
			else
				SCREEN="${SCREEN}${LINE}"
			fi
		done
		FIRE_COUNTER=$((${FIRE_COUNTER}+1))
		print "${SCREEN}"

# buffer 2 - calculate
		for X in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39" "40" "41" "42" "43" "44" "45" "46" "47" "48" "49" "50" "51" "52" "53" "54" "55" "56" "57" "58" "59" "60" "61" "62" "63" "64" "65" "66" "67" "68" "69" "70" "71" "72" "73" "74" "75" "76" "77" "78" "79" "80" "81" "82" "83" "84" "85" "86" "87" "88" "89" "90" "91" "92" "93" "94" "95" "96" "97" "98" "99" "100" "101" "102" "103" "104" "105" "106" "107" "108" "109" "110" "111" "112" "113" "114" "115" "116" "117" "118" "119" "120" "121" "122" "123" "124" "125" "126" "127" "128" "129" "130" "131" "132" "133" "134" "135" "136" "137" "138" "139" "140" "141" "142" "143" "144" "145" "146" "147" "148" "149" "150" "151" "152" "153" "154" "155" "156" "157" "158" "159" "160" "161" "162" "163" "164" "165" "166" "167" "168" "169" "170" "171" "172" "173" "174" "175" "176" "177" "178" "179" "180" "181" "182" "183" "184" "185" "186" "187" "188" "189" "190" "191" "192" "193" "194" "195" "196" "197" "198" "199" "200" "201" "202" "203" "204" "205" "206" "207" "208" "209" "210" "211" "212" "213" "214" "215" "216" "217" "218" "219" "220" "221" "222" "223" "224" "225" "226" "227" "228" "229" "230" "231" "232" "233" "234" "235" "236" "237" "238" "239" "240" "241" "242" "243" "244" "245" "246" "247" "248" "249" "250" "251" "252" "253" "254" "255" "256" "257" "258" "259" "260" "261" "262" "263" "264" "265" "266" "267" "268" "269" "270" "271" "272" "273" "274" "275" "276" "277" "278" "279" "280" "281" "282" "283" "284" "285" "286" "287" "288" "289" "290" "291" "292" "293" "294" "295" "296" "297" "298" "299" "300" "301" "302" "303" "304" "305" "306" "307" "308" "309" "310" "311" "312" "313" "314" "315" "316" "317" "318" "319" "320" "321" "322" "323" "324" "325" "326" "327" "328" "329" "330" "331" "332" "333" "334" "335" "336" "337" "338" "339" "340" "341" "342" "343" "344" "345" "346" "347" "348" "349" "350" "351" "352" "353" "354" "355" "356" "357" "358" "359" "360" "361" "362" "363" "364" "365" "366" "367" "368" "369" "370" "371" "372" "373" "374" "375" "376" "377" "378" "379" "380" "381" "382" "383" "384" "385" "386" "387" "388" "389" "390" "391" "392" "393" "394" "395" "396" "397" "398" "399" "400" "401" "402" "403" "404" "405" "406" "407" "408" "409" "410" "411" "412" "413" "414" "415" "416" "417" "418" "419" "420" "421" "422" "423" "424" "425" "426" "427" "428" "429" "430" "431" "432" "433" "434" "435" "436" "437" "438" "439" "440" "441" "442" "443" "444" "445" "446" "447" "448" "449" "450" "451" "452" "453" "454" "455" "456" "457" "458" "459" "460" "461" "462" "463" "464" "465" "466" "467" "468" "469" "470" "471" "472" "473" "474" "475" "476" "477" "478" "479" "480" "481" "482" "483" "484" "485" "486" "487" "488" "489" "490" "491" "492" "493" "494" "495" "496" "497" "498" "499" "500" "501" "502" "503" "504" "505" "506" "507" "508" "509" "510" "511" "512" "513" "514" "515" "516" "517" "518" "519" "520" "521" "522" "523" "524" "525" "526" "527" "528" "529" "530" "531" "532" "533" "534" "535" "536" "537" "538" "539" "540" "541" "542" "543" "544" "545" "546" "547" "548" "549" "550" "551" "552" "553" "554" "555" "556" "557" "558" "559" "560" "561" "562" "563" "564" "565" "566" "567" "568" "569" "570" "571" "572" "573" "574" "575" "576" "577" "578" "579" "580" "581" "582" "583" "584" "585" "586" "587" "588" "589" "590" "591" "592" "593" "594" "595" "596" "597" "598" "599" "600" "601" "602" "603" "604" "605" "606" "607" "608" "609" "610" "611" "612" "613" "614" "615" "616" "617" "618" "619" "620" "621" "622" "623" "624" "625" "626" "627" "628" "629" "630" "631" "632" "633" "634" "635" "636" "637" "638" "639" "640" "641" "642" "643" "644" "645" "646" "647" "648" "649" "650" "651" "652" "653" "654" "655" "656" "657" "658" "659" "660" "661" "662" "663" "664" "665" "666" "667" "668" "669" "670" "671" "672" "673" "674" "675" "676" "677" "678" "679" "680" "681" "682" "683" "684" "685" "686" "687" "688" "689" "690" "691" "692" "693" "694" "695" "696" "697" "698" "699" "700" "701" "702" "703" "704" "705" "706" "707" "708" "709" "710" "711" "712" "713" "714" "715" "716" "717" "718" "719" "720" "721" "722" "723" "724" "725" "726" "727" "728" "729" "730" "731" "732" "733" "734" "735" "736" "737" "738" "739" "740" "741" "742" "743" "744" "745" "746" "747" "748" "749" "750" "751" "752" "753" "754" "755" "756" "757" "758" "759" "760" "761" "762" "763" "764" "765" "766" "767" "768" "769" "770" "771" "772" "773" "774" "775" "776" "777" "778" "779" "780" "781" "782" "783" "784" "785" "786" "787" "788" "789" "790" "791" "792" "793" "794" "795" "796" "797" "798" "799" "800" "801" "802" "803" "804" "805" "806" "807" "808" "809" "810" "811" "812" "813" "814" "815" "816" "817" "818" "819" "820" "821" "822" "823" "824" "825" "826" "827" "828" "829" "830" "831" "832" "833" "834" "835" "836" "837" "838" "839" "840" "841" "842" "843" "844" "845" "846" "847" "848" "849" "850" "851" "852" "853" "854" "855" "856" "857" "858" "859" "860" "861" "862" "863" "864" "865" "866" "867" "868" "869" "870" "871" "872" "873" "874" "875" "876" "877" "878" "879"; do
			X1=$((X+79))
			X2=$((X+81))
			FIRE_BUFFER2[${X}]=$(((${FIRE_BUFFER1[${X1}]}+${FIRE_BUFFER1[${X2}]})>>1))
		done

		for X in "880" "881" "882" "883" "884" "885" "886" "887" "888" "889" "890" "891" "892" "893" "894" "895" "896" "897" "898" "899" "900" "901" "902" "903" "904" "905" "906" "907" "908" "909" "910" "911" "912" "913" "914" "915" "916" "917" "918" "919" "920" "921" "922" "923" "924" "925" "926" "927" "928" "929" "930" "931" "932" "933" "934" "935" "936" "937" "938" "939" "940" "941" "942" "943" "944" "945" "946" "947" "948" "949" "950" "951" "952" "953" "954" "955" "956" "957" "958" "959"; do
			FIRE_BUFFER2[${X}]=$((${RANDOM}&7))
		done

# buffer 2 - display
		tput cup 0 0
		INDEX=0
		SCREEN=""
		for Y in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11"; do
			LINE=""
			for X in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39" "40" "41" "42" "43" "44" "45" "46" "47" "48" "49" "50" "51" "52" "53" "54" "55" "56" "57" "58" "59" "60" "61" "62" "63" "64" "65" "66" "67" "68" "69" "70" "71" "72" "73" "74" "75" "76" "77" "78" "79"; do
				LINE="${LINE}${FIRE_CHARACTERS[${FIRE_BUFFER2[${INDEX}]}]}"
				INDEX=$((${INDEX}+1))
			done
			if [ "${Y}" != "11" ]; then
				SCREEN="${SCREEN}${LINE}\n"
			else
				SCREEN="${SCREEN}${LINE}"
				fi
		done
		FIRE_COUNTER=$((${FIRE_COUNTER}+1))
		print "${SCREEN}"
	done

}

########################################################################

zoom_init()
{
	set -A ZOOM_TEXTURE "#" "#" "#" "#" "." "." "." "." "#" "+" "+" "#" "." " " " " "." "#" "+" "+" "#" "." " " " " "." "#" "#" "#" "#" "." "." "." "." "." "." "." "." "#" "#" "#" "#" "." ":" ":" "." "#" "*" "*" "#"  "." ":" ":" "." "#" "*" "*" "#" "." "." "." "." "#" "#" "#" "#"

	set -A ZOOM_SINUS "0" "402" "804" "1205" "1606" "2006" "2404" "2801" "3196" "3590" "3981" "4370" "4756" "5139" "5520" "5897" "6270" "6639" "7005" "7366" "7723" "8076" "8423" "8765" "9102" "9434" "9760" "10080" "10394" "10702" "11003" "11297" "11585" "11866" "12140" "12406" "12665" "12916" "13160" "13395" "13623" "13842" "14053" "14256" "14449" "14635" "14811" "14978" "15137" "15286" "15426" "15557" "15679" "15791" "15893" "15986" "16069" "16143" "16207" "16261" "16305" "16340" "16364" "16379" "16384" "16379" "16364" "16340" "16305" "16261" "16207" "16143" "16069" "15986" "15893" "15791" "15679" "15557" "15426" "15286" "15137" "14978" "14811" "14635" "14449" "14255" "14053" "13842" "13623" "13395" "13160" "12916" "12665" "12406" "12140" "11866" "11585" "11297" "11003" "10702" "10394" "10080" "9760" "9434" "9102" "8765" "8423" "8076" "7723" "7366" "7005" "6639" "6270" "5897" "5520" "5139" "4756" "4370" "3981" "3590" "3196" "2801" "2404" "2006" "1606" "1205" "804" "402" "0" "-402" "-804" "-1205" "-1606" "-2006" "-2404" "-2801" "-3196" "-3590" "-3981" "-4370" "-4756" "-5139" "-5520" "-5897" "-6270" "-6639" "-7005" "-7366" "-7723" "-8076" "-8423" "-8765" "-9102" "-9434" "-9760" "-10080" "-10394" "-10702" "-11003" "-11297" "-11585" "-11866" "-12140" "-12406" "-12665" "-12916" "-13160" "-13395" "-13623" "-13842" "-14053" "-14256" "-14449" "-14635" "-14811" "-14978" "-15137" "-15286" "-15426" "-15557" "-15679" "-15791" "-15893" "-15986" "-16069" "-16143" "-16207" "-16261" "-16305" "-16340" "-16364" "-16379" "-16384" "-16379" "-16364" "-16340" "-16305" "-16261" "-16207" "-16143" "-16069" "-15986" "-15893" "-15790" "-15679" "-15557" "-15426" "-15286" "-15137" "-14978" "-14811" "-14635" "-14449" "-14255" "-14053" "-13842" "-13623" "-13395" "-13160" "-12916" "-12665" "-12406" "-12140" "-11866" "-11585" "-11297" "-11003" "-10702" "-10394" "-10080" "-9760" "-9434" "-9102" "-8765" "-8423" "-8076" "-7723" "-7366" "-7005" "-6639" "-6270" "-5896" "-5520" "-5139" "-4756" "-4370" "-3981" "-3590" "-3196" "-2801" "-2404" "-2006" "-1606" "-1205" "-804" "-402"

	set -A ZOOM_COSINUS "16384" "16379" "16364" "16340" "16305" "16261" "16207" "16143" "16069" "15986" "15893" "15791" "15679" "15557" "15426" "15286" "15137" "14978" "14811" "14635" "14449" "14256" "14053" "13842" "13623" "13395" "13160" "12916" "12665" "12406" "12140" "11866" "11585" "11297" "11003" "10702" "10394" "10080" "9760" "9434" "9102" "8765" "8423" "8076" "7723" "7366" "7005" "6639" "6270" "5897" "5520" "5139" "4756" "4370" "3981" "3590" "3196" "2801" "2404" "2006" "1606" "1205" "804" "402" "0" "-402" "-804" "-1205" "-1606" "-2006" "-2404" "-2801" "-3196" "-3590" "-3981" "-4370" "-4756" "-5139" "-5520" "-5897" "-6270" "-6639" "-7005" "-7366" "-7723" "-8076" "-8423" "-8765" "-9102" "-9434" "-9760" "-10080" "-10394" "-10702" "-11003" "-11297" "-11585" "-11866" "-12140" "-12406" "-12665" "-12916" "-13160" "-13395" "-13623" "-13842" "-14053" "-14256" "-14449" "-14635" "-14811" "-14978" "-15137" "-15286" "-15426" "-15557" "-15679" "-15791" "-15893" "-15986" "-16069" "-16143" "-16207" "-16261" "-16305" "-16340" "-16364" "-16379" "-16384" "-16379" "-16364" "-16340" "-16305" "-16261" "-16207" "-16143" "-16069" "-15986" "-15893" "-15791" "-15679" "-15557" "-15426" "-15286" "-15137" "-14978" "-14811" "-14635" "-14449" "-14255" "-14053" "-13842" "-13623" "-13395" "-13160" "-12916" "-12665" "-12406" "-12140" "-11866" "-11585" "-11297" "-11003" "-10702" "-10394" "-10080" "-9760" "-9434" "-9102" "-8765" "-8423" "-8076" "-7723" "-7366" "-7005" "-6639" "-6270" "-5896" "-5520" "-5139" "-4756" "-4370" "-3981" "-3590" "-3196" "-2801" "-2404" "-2006" "-1606" "-1205" "-804" "-402" "0" "402" "804" "1205" "1606" "2006" "2404" "2801" "3196" "3590" "3981" "4370" "4756" "5139" "5520" "5897" "6270" "6640" "7005" "7366" "7723" "8076" "8423" "8765" "9102" "9434" "9760" "10080" "10394" "10702" "11003" "11297" "11585" "11866" "12140" "12406" "12665" "12916" "13160" "13395" "13623" "13842" "14053" "14256" "14449" "14635" "14811" "14978" "15137" "15286" "15426" "15557" "15679" "15791" "15893" "15986" "16069" "16143" "16207" "16261" "16305" "16340" "16364" "16379"

	set -A ZOOM_FACTOR "428" "435" "443" "450" "457" "465" "472" "479" "487" "494" "501" "508" "515" "522" "529" "536" "543" "550" "556" "563" "569" "576" "582" "588" "595" "601" "607" "613" "618" "624" "629" "635" "640" "645" "650" "655" "660" "665" "669" "673" "677" "681" "685" "689" "693" "696" "699" "702" "705" "708" "710" "713" "715" "717" "719" "721" "722" "724" "725" "726" "727" "727" "728" "728" "728" "728" "728" "727" "727" "726" "725" "724" "722" "721" "719" "717" "715" "713" "710" "708" "705" "702" "699" "696" "693" "689" "685" "681" "677" "673" "669" "665" "660" "655" "650" "645" "640" "635" "629" "624" "618" "613" "607" "601" "595" "588" "582" "576" "569" "563" "556" "550" "543" "536" "529" "522" "515" "508" "501" "494" "487" "479" "472" "465" "457" "450" "443" "435" "428" "421" "413" "406" "399" "391" "384" "377" "369" "362" "355" "348" "341" "334" "327" "320" "313" "306" "300" "293" "287" "280" "274" "268" "261" "255" "249" "243" "238" "232" "227" "221" "216" "211" "206" "201" "196" "191" "187" "183" "179" "175" "171" "167" "163" "160" "157" "154" "151" "148" "146" "143" "141" "139" "137" "135" "134" "132" "131" "130" "129" "129" "128" "128" "128" "128" "128" "129" "129" "130" "131" "132" "134" "135" "137" "139" "141" "143" "146" "148" "151" "154" "157" "160" "163" "167" "171" "175" "179" "183" "187" "191" "196" "201" "206" "211" "216" "221" "227" "232" "238" "243" "249" "255" "261" "268" "274" "280" "287" "293" "300" "306" "313" "320" "327" "334" "341" "348" "355" "362" "369" "377" "384" "391" "399" "406" "413" "421"
}

########################################################################

zoom_render()
{
	FACTOR="0"
	ANGLE="0"

	ZOOM_COUNTER="0"
	FINISH=$((`date +%s`+$1))
	while [ ${FINISH} -ge `date +%s` ]; do
# zoom - render
		tput cup 0 0
		SCREEN_UP=""
		SCREEN_DOWN=""
		STEP_X=$((${ZOOM_COSINUS[${ANGLE}]}/${ZOOM_FACTOR[${FACTOR}]}))
		STEP_Y=$((${ZOOM_SINUS[${ANGLE}]}/${ZOOM_FACTOR[${FACTOR}]}))
		XK=$(((${STEP_Y}<<6)*-1))
		YK=$(((${STEP_X}<<4)*-1))
		for Y in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10"; do
			LINE_UP=""
			XT=${XK}
			YT=${YK}
			for X in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39" "40" "41" "42" "43" "44" "45" "46" "47" "48" "49" "50" "51" "52" "53" "54" "55" "56" "57" "58" "59" "60" "61" "62" "63" "64" "65" "66" "67" "68" "69" "70" "71" "72" "73" "74" "75" "76" "77" "78" "79"; do
				XT=$((${STEP_X}+${XT}))
				YT=$((${STEP_Y}+${YT}))
				LINE_UP="${LINE_UP}${ZOOM_TEXTURE[((${YT}>>5)&56)+((${XT}>>8)&7)]}"
			done
			XK=$((${STEP_Y}+${XK}))
			YK=$((${YK}-(${STEP_X})))
			SCREEN_UP="${SCREEN_UP}${LINE_UP}\n"
		done

		for Y in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10"; do
			LINE_DOWN=""
			XT=${XK}
			YT=${YK}
			for X in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39" "40" "41" "42" "43" "44" "45" "46" "47" "48" "49" "50" "51" "52" "53" "54" "55" "56" "57" "58" "59" "60" "61" "62" "63" "64" "65" "66" "67" "68" "69" "70" "71" "72" "73" "74" "75" "76" "77" "78" "79"; do
				XT=$((${STEP_X}+${XT}))
				YT=$((${STEP_Y}+${YT}))
				LINE_DOWN="${LINE_DOWN}${ZOOM_TEXTURE[((${YT}>>5)&56)+((${XT}>>8)&7)]}"
			done
			XK=$((${STEP_Y}+${XK}))
			YK=$((${YK}-(${STEP_X})))
			if [ "${Y}" != "10" ]; then
				SCREEN_DOWN="${SCREEN_DOWN}${LINE_DOWN}\n"
			else
				SCREEN_DOWN="${SCREEN_DOWN}${LINE_DOWN}"
			fi
		done

		SCREEN="                                                                                \n${SCREEN_UP}${SCREEN_DOWN}"
		print "${SCREEN}"
		ZOOM_COUNTER=$((${ZOOM_COUNTER}+1))
		ANGLE=$(((${ANGLE}+3)&255))
		FACTOR=$(((${FACTOR}+2)&255))
	done
}

########################################################################

blobs_init()
{
	set -A BLOB_CHARS " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " "." "." "." "." "." "." "." "." "." "." "." "." "." "." "." "." ":" ":" ":" ":" ":" ":" ":" ":" ":" ":" ":" ":" ":" ":" ":" ":" "+" "+" "+" "+" "+" "+" "+" "+" "+" "+" "+" "+" "+" "+" "+" "+" "*" "*" "*" "*" "*" "*" "*" "*" "*" "*" "*" "*" "*" "*" "*" "*" "x" "x" "x" "x" "x" "x" "x" "x" "x" "x" "x" "x" "x" "x" "x" "x" "X" "X" "X" "X" "X" "X" "X" "X" "X" "X" "X" "X" "X" "X" "X" "X" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#"

	set -A BLOB_PATTERN_0 "7" "7" "7" "7" "7" "7" "7" "7" "7" "7" "7" "7" "7" "7" "7" "7" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10"
	set -A BLOB_PATTERN_1 "7" "7" "7" "7" "7" "7" "7" "7" "7" "7" "7" "7" "7" "7" "7" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10"
	set -A BLOB_PATTERN_2 "7" "7" "7" "7" "7" "7" "7" "7" "7" "7" "7" "7" "7" "7" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10"
	set -A BLOB_PATTERN_3 "7" "7" "7" "7" "7" "7" "7" "7" "7" "7" "7" "7" "7" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10"
	set -A BLOB_PATTERN_4 "7" "7" "7" "7" "7" "7" "7" "7" "7" "7" "7" "7" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10"
	set -A BLOB_PATTERN_5 "7" "7" "7" "7" "7" "7" "7" "7" "7" "7" "7" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10"
	set -A BLOB_PATTERN_6 "7" "7" "7" "7" "7" "7" "7" "7" "7" "7" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11"
	set -A BLOB_PATTERN_7 "7" "7" "7" "7" "7" "7" "7" "7" "7" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11"
	set -A BLOB_PATTERN_8 "7" "7" "7" "7" "7" "7" "7" "7" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11"
	set -A BLOB_PATTERN_9 "7" "7" "7" "7" "7" "7" "7" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11"
	set -A BLOB_PATTERN_10 "7" "7" "7" "7" "7" "7" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11"
	set -A BLOB_PATTERN_11 "7" "7" "7" "7" "7" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11"
	set -A BLOB_PATTERN_12 "7" "7" "7" "7" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11"
	set -A BLOB_PATTERN_13 "7" "7" "7" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12"
	set -A BLOB_PATTERN_14 "7" "7" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12"
	set -A BLOB_PATTERN_15 "7" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12"
	set -A BLOB_PATTERN_16 "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12"
	set -A BLOB_PATTERN_17 "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12"
	set -A BLOB_PATTERN_18 "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12"
	set -A BLOB_PATTERN_19 "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12"
	set -A BLOB_PATTERN_20 "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13"
	set -A BLOB_PATTERN_21 "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13"
	set -A BLOB_PATTERN_22 "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13"
	set -A BLOB_PATTERN_23 "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13"
	set -A BLOB_PATTERN_24 "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13"
	set -A BLOB_PATTERN_25 "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "14"
	set -A BLOB_PATTERN_26 "8" "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14"
	set -A BLOB_PATTERN_27 "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14"
	set -A BLOB_PATTERN_28 "8" "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14"
	set -A BLOB_PATTERN_29 "8" "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14"
	set -A BLOB_PATTERN_30 "8" "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "15" "15" "15" "15"
	set -A BLOB_PATTERN_31 "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15"
	set -A BLOB_PATTERN_32 "8" "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15"
	set -A BLOB_PATTERN_33 "8" "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15"
	set -A BLOB_PATTERN_34 "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "16" "16" "16" "16" "16" "16" "16"
	set -A BLOB_PATTERN_35 "8" "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16"
	set -A BLOB_PATTERN_36 "8" "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16"
	set -A BLOB_PATTERN_37 "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "15" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16"
	set -A BLOB_PATTERN_38 "8" "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "15" "15" "15" "15" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16" "17" "17" "17" "17" "17" "17" "17" "17" "17"
	set -A BLOB_PATTERN_39 "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "15" "15" "15" "15" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16" "16" "17" "17" "17" "17" "17" "17" "17" "17" "17" "17" "17" "17" "17" "17"
	set -A BLOB_PATTERN_40 "8" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "15" "15" "15" "15" "16" "16" "16" "16" "16" "16" "16" "16" "16" "17" "17" "17" "17" "17" "17" "17" "17" "17" "17" "17" "17" "17" "17" "17" "17" "17" "17"
	set -A BLOB_PATTERN_41 "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "15" "15" "15" "16" "16" "16" "16" "16" "16" "16" "16" "16" "17" "17" "17" "17" "17" "17" "17" "17" "17" "17" "17" "17" "17" "18" "18" "18" "18" "18" "18" "18"
	set -A BLOB_PATTERN_42 "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "15" "15" "15" "16" "16" "16" "16" "16" "16" "16" "16" "17" "17" "17" "17" "17" "17" "17" "17" "17" "17" "18" "18" "18" "18" "18" "18" "18" "18" "18" "18" "18" "18" "18"
	set -A BLOB_PATTERN_43 "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "15" "15" "16" "16" "16" "16" "16" "16" "16" "16" "17" "17" "17" "17" "17" "17" "17" "17" "17" "18" "18" "18" "18" "18" "18" "18" "18" "18" "18" "18" "18" "18" "18" "18" "18"
	set -A BLOB_PATTERN_44 "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "15" "15" "16" "16" "16" "16" "16" "16" "16" "17" "17" "17" "17" "17" "17" "17" "17" "18" "18" "18" "18" "18" "18" "18" "18" "18" "18" "18" "19" "19" "19" "19" "19" "19" "19" "19"
	set -A BLOB_PATTERN_45 "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "15" "16" "16" "16" "16" "16" "16" "16" "17" "17" "17" "17" "17" "17" "17" "18" "18" "18" "18" "18" "18" "18" "18" "18" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19"
	set -A BLOB_PATTERN_46 "9" "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "15" "15" "16" "16" "16" "16" "16" "16" "16" "17" "17" "17" "17" "17" "17" "18" "18" "18" "18" "18" "18" "18" "18" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19"
	set -A BLOB_PATTERN_47 "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "15" "15" "16" "16" "16" "16" "16" "16" "17" "17" "17" "17" "17" "17" "18" "18" "18" "18" "18" "18" "18" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19" "20" "20" "20" "20" "20" "20" "20" "20" "20"
	set -A BLOB_PATTERN_48 "9" "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "15" "16" "16" "16" "16" "16" "16" "17" "17" "17" "17" "17" "17" "17" "18" "18" "18" "18" "18" "18" "19" "19" "19" "19" "19" "19" "19" "20" "20" "20" "20" "20" "20" "20" "20" "20" "20" "20" "20" "20" "20"
	set -A BLOB_PATTERN_49 "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "15" "16" "16" "16" "16" "16" "16" "17" "17" "17" "17" "17" "17" "18" "18" "18" "18" "18" "18" "19" "19" "19" "19" "19" "19" "20" "20" "20" "20" "20" "20" "20" "20" "20" "20" "21" "21" "21" "21" "21" "21" "21"
	set -A BLOB_PATTERN_50 "9" "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "15" "16" "16" "16" "16" "16" "16" "17" "17" "17" "17" "17" "18" "18" "18" "18" "18" "18" "19" "19" "19" "19" "19" "19" "20" "20" "20" "20" "20" "20" "20" "21" "21" "21" "21" "21" "21" "21" "21" "21" "21" "21" "21"
	set -A BLOB_PATTERN_51 "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "15" "16" "16" "16" "16" "16" "16" "17" "17" "17" "17" "17" "18" "18" "18" "18" "18" "19" "19" "19" "19" "19" "19" "20" "20" "20" "20" "20" "20" "21" "21" "21" "21" "21" "21" "21" "21" "21" "22" "22" "22" "22" "22" "22"
	set -A BLOB_PATTERN_52 "9" "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "15" "16" "16" "16" "16" "16" "17" "17" "17" "17" "17" "17" "18" "18" "18" "18" "18" "19" "19" "19" "19" "19" "20" "20" "20" "20" "20" "21" "21" "21" "21" "21" "21" "21" "22" "22" "22" "22" "22" "22" "22" "22" "22" "22" "22"
	set -A BLOB_PATTERN_53 "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "16" "16" "16" "16" "16" "17" "17" "17" "17" "17" "18" "18" "18" "18" "18" "19" "19" "19" "19" "19" "20" "20" "20" "20" "20" "21" "21" "21" "21" "21" "21" "22" "22" "22" "22" "22" "22" "22" "22" "23" "23" "23" "23" "23" "23"
	set -A BLOB_PATTERN_54 "9" "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "16" "16" "16" "16" "16" "17" "17" "17" "17" "17" "18" "18" "18" "18" "18" "19" "19" "19" "19" "20" "20" "20" "20" "20" "21" "21" "21" "21" "21" "22" "22" "22" "22" "22" "22" "23" "23" "23" "23" "23" "23" "23" "23" "23" "23" "23"
	set -A BLOB_PATTERN_55 "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "16" "16" "16" "16" "16" "17" "17" "17" "17" "17" "18" "18" "18" "18" "19" "19" "19" "19" "19" "20" "20" "20" "20" "21" "21" "21" "21" "21" "22" "22" "22" "22" "22" "23" "23" "23" "23" "23" "23" "23" "24" "24" "24" "24" "24" "24" "24"
	set -A BLOB_PATTERN_56 "9" "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "16" "16" "16" "16" "16" "17" "17" "17" "17" "17" "18" "18" "18" "18" "19" "19" "19" "19" "20" "20" "20" "20" "20" "21" "21" "21" "21" "22" "22" "22" "22" "23" "23" "23" "23" "23" "23" "24" "24" "24" "24" "24" "24" "24" "24" "24" "24" "24"
	set -A BLOB_PATTERN_57 "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "17" "17" "18" "18" "18" "18" "19" "19" "19" "19" "20" "20" "20" "20" "21" "21" "21" "21" "22" "22" "22" "22" "23" "23" "23" "23" "23" "24" "24" "24" "24" "24" "24" "25" "25" "25" "25" "25" "25" "25" "25"
	set -A BLOB_PATTERN_58 "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "16" "16" "16" "16" "16" "17" "17" "17" "17" "18" "18" "18" "18" "19" "19" "19" "19" "20" "20" "20" "20" "21" "21" "21" "21" "22" "22" "22" "23" "23" "23" "23" "24" "24" "24" "24" "24" "25" "25" "25" "25" "25" "25" "25" "26" "26" "26" "26" "26"
	set -A BLOB_PATTERN_59 "9" "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "16" "16" "16" "16" "16" "17" "17" "17" "17" "18" "18" "18" "18" "19" "19" "19" "19" "20" "20" "20" "20" "21" "21" "21" "22" "22" "22" "22" "23" "23" "23" "24" "24" "24" "24" "25" "25" "25" "25" "25" "26" "26" "26" "26" "26" "26" "26" "26" "26" "27"
	set -A BLOB_PATTERN_60 "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "16" "16" "16" "16" "16" "17" "17" "17" "17" "18" "18" "18" "18" "19" "19" "19" "19" "20" "20" "20" "21" "21" "21" "21" "22" "22" "22" "23" "23" "23" "23" "24" "24" "24" "25" "25" "25" "25" "26" "26" "26" "26" "26" "27" "27" "27" "27" "27" "27" "27" "27"
	set -A BLOB_PATTERN_61 "9" "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "17" "18" "18" "18" "18" "19" "19" "19" "19" "20" "20" "20" "21" "21" "21" "22" "22" "22" "22" "23" "23" "23" "24" "24" "24" "25" "25" "25" "25" "26" "26" "26" "27" "27" "27" "27" "27" "28" "28" "28" "28" "28" "28" "28"
	set -A BLOB_PATTERN_62 "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "17" "17" "18" "18" "18" "19" "19" "19" "19" "20" "20" "20" "21" "21" "21" "22" "22" "22" "23" "23" "23" "24" "24" "24" "25" "25" "25" "25" "26" "26" "26" "27" "27" "27" "27" "28" "28" "28" "28" "28" "29" "29" "29" "29" "29"
	set -A BLOB_PATTERN_63 "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "16" "16" "16" "16" "16" "17" "17" "17" "17" "18" "18" "18" "19" "19" "19" "19" "20" "20" "20" "21" "21" "21" "22" "22" "22" "23" "23" "23" "24" "24" "24" "25" "25" "25" "26" "26" "26" "27" "27" "27" "28" "28" "28" "29" "29" "29" "29" "29" "29" "30" "30" "30" "30"
	set -A BLOB_PATTERN_64 "9" "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "17" "18" "18" "18" "18" "19" "19" "19" "20" "20" "20" "21" "21" "21" "22" "22" "22" "23" "23" "23" "24" "24" "25" "25" "25" "26" "26" "26" "27" "27" "27" "28" "28" "28" "29" "29" "29" "30" "30" "30" "30" "30" "31" "31" "31" "31"
	set -A BLOB_PATTERN_65 "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "16" "16" "16" "16" "16" "17" "17" "17" "18" "18" "18" "18" "19" "19" "19" "20" "20" "20" "21" "21" "21" "22" "22" "22" "23" "23" "23" "24" "24" "25" "25" "25" "26" "26" "27" "27" "27" "28" "28" "29" "29" "29" "30" "30" "30" "30" "31" "31" "31" "31" "31" "32" "32" "32"
	set -A BLOB_PATTERN_66 "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "17" "18" "18" "18" "19" "19" "19" "20" "20" "20" "20" "21" "21" "22" "22" "22" "23" "23" "23" "24" "24" "25" "25" "26" "26" "26" "27" "27" "28" "28" "29" "29" "29" "30" "30" "30" "31" "31" "31" "32" "32" "32" "32" "33" "33" "33" "33"
	set -A BLOB_PATTERN_67 "9" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "17" "18" "18" "18" "18" "19" "19" "19" "20" "20" "20" "21" "21" "22" "22" "22" "23" "23" "23" "24" "24" "25" "25" "26" "26" "27" "27" "27" "28" "28" "29" "29" "30" "30" "31" "31" "31" "32" "32" "32" "33" "33" "33" "33" "34" "34" "34" "34"
	set -A BLOB_PATTERN_68 "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "17" "18" "18" "18" "19" "19" "19" "20" "20" "20" "21" "21" "21" "22" "22" "23" "23" "23" "24" "24" "25" "25" "26" "26" "27" "27" "28" "28" "29" "29" "30" "30" "31" "31" "31" "32" "32" "33" "33" "34" "34" "34" "34" "35" "35" "35" "35" "35"
	set -A BLOB_PATTERN_69 "10" "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "14" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "17" "18" "18" "18" "19" "19" "19" "20" "20" "20" "21" "21" "21" "22" "22" "23" "23" "23" "24" "24" "25" "25" "26" "26" "27" "27" "28" "28" "29" "29" "30" "30" "31" "31" "32" "32" "33" "33" "34" "34" "35" "35" "35" "36" "36" "36" "36" "36" "37"
	set -A BLOB_PATTERN_70 "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "18" "18" "18" "18" "19" "19" "19" "20" "20" "20" "21" "21" "22" "22" "22" "23" "23" "24" "24" "25" "25" "26" "26" "27" "27" "28" "28" "29" "29" "30" "31" "31" "32" "32" "33" "33" "34" "34" "35" "35" "36" "36" "37" "37" "37" "38" "38" "38" "38"
	set -A BLOB_PATTERN_71 "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "17" "18" "18" "18" "19" "19" "19" "20" "20" "20" "21" "21" "21" "22" "22" "23" "23" "24" "24" "25" "25" "26" "26" "27" "27" "28" "28" "29" "30" "30" "31" "31" "32" "33" "33" "34" "34" "35" "36" "36" "37" "37" "38" "38" "38" "39" "39" "39" "39" "39"
	set -A BLOB_PATTERN_72 "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "18" "18" "18" "18" "19" "19" "19" "20" "20" "21" "21" "21" "22" "22" "23" "23" "24" "24" "25" "25" "26" "26" "27" "27" "28" "28" "29" "30" "30" "31" "32" "32" "33" "34" "34" "35" "35" "36" "37" "37" "38" "39" "39" "40" "40" "40" "41" "41" "41" "41"
	set -A BLOB_PATTERN_73 "10" "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "17" "18" "18" "18" "19" "19" "19" "20" "20" "20" "21" "21" "22" "22" "22" "23" "23" "24" "24" "25" "25" "26" "27" "27" "28" "28" "29" "30" "30" "31" "32" "32" "33" "34" "34" "35" "36" "37" "37" "38" "39" "39" "40" "41" "41" "42" "42" "42" "43" "43" "43"
	set -A BLOB_PATTERN_74 "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "18" "18" "18" "18" "19" "19" "19" "20" "20" "21" "21" "21" "22" "22" "23" "23" "24" "24" "25" "25" "26" "26" "27" "28" "28" "29" "30" "30" "31" "32" "32" "33" "34" "35" "35" "36" "37" "38" "39" "39" "40" "41" "42" "42" "43" "43" "44" "44" "45" "45" "45"
	set -A BLOB_PATTERN_75 "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "18" "18" "18" "19" "19" "19" "20" "20" "20" "21" "21" "22" "22" "23" "23" "23" "24" "25" "25" "26" "26" "27" "27" "28" "29" "29" "30" "31" "32" "32" "33" "34" "35" "36" "37" "37" "38" "39" "40" "41" "42" "42" "43" "44" "45" "45" "46" "46" "47" "47" "47"
	set -A BLOB_PATTERN_76 "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "17" "18" "18" "18" "19" "19" "19" "20" "20" "21" "21" "21" "22" "22" "23" "23" "24" "24" "25" "25" "26" "27" "27" "28" "29" "29" "30" "31" "32" "32" "33" "34" "35" "36" "37" "38" "39" "40" "40" "41" "42" "43" "44" "45" "46" "47" "47" "48" "49" "49" "49" "49"
	set -A BLOB_PATTERN_77 "10" "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "18" "18" "18" "19" "19" "19" "20" "20" "20" "21" "21" "22" "22" "23" "23" "24" "24" "25" "25" "26" "26" "27" "28" "28" "29" "30" "31" "31" "32" "33" "34" "35" "36" "37" "38" "39" "40" "41" "42" "43" "44" "45" "46" "47" "48" "49" "50" "50" "51" "51" "52" "52"
	set -A BLOB_PATTERN_78 "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "16" "16" "16" "17" "17" "17" "17" "18" "18" "18" "19" "19" "19" "20" "20" "21" "21" "21" "22" "22" "23" "23" "24" "24" "25" "25" "26" "27" "27" "28" "29" "30" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39" "40" "41" "42" "43" "45" "46" "47" "48" "49" "50" "51" "52" "53" "54" "54" "55" "55"
	set -A BLOB_PATTERN_79 "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "17" "18" "18" "18" "19" "19" "20" "20" "20" "21" "21" "22" "22" "23" "23" "24" "24" "25" "25" "26" "26" "27" "28" "29" "29" "30" "31" "32" "33" "34" "34" "35" "37" "38" "39" "40" "41" "42" "44" "45" "46" "48" "49" "50" "51" "53" "54" "55" "56" "57" "57" "58" "58"
	set -A BLOB_PATTERN_80 "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "18" "18" "18" "19" "19" "19" "20" "20" "20" "21" "21" "22" "22" "23" "23" "24" "24" "25" "25" "26" "27" "27" "28" "29" "30" "31" "31" "32" "33" "34" "35" "36" "37" "39" "40" "41" "42" "44" "45" "47" "48" "50" "51" "52" "54" "55" "57" "58" "59" "60" "61" "62" "62"
	set -A BLOB_PATTERN_81 "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "18" "18" "18" "19" "19" "19" "20" "20" "21" "21" "21" "22" "22" "23" "23" "24" "25" "25" "26" "26" "27" "28" "29" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "40" "41" "42" "44" "45" "47" "48" "50" "52" "53" "55" "57" "58" "60" "61" "63" "64" "65" "66" "66"
	set -A BLOB_PATTERN_82 "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "16" "16" "16" "17" "17" "17" "17" "18" "18" "18" "19" "19" "20" "20" "20" "21" "21" "22" "22" "23" "23" "24" "24" "25" "25" "26" "27" "27" "28" "29" "30" "31" "31" "32" "33" "34" "35" "37" "38" "39" "40" "42" "43" "45" "47" "48" "50" "52" "54" "56" "58" "60" "62" "63" "65" "67" "68" "69" "70" "71"
	set -A BLOB_PATTERN_83 "10" "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "18" "18" "18" "19" "19" "19" "20" "20" "20" "21" "21" "22" "22" "23" "23" "24" "24" "25" "26" "26" "27" "28" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "39" "40" "41" "43" "45" "46" "48" "50" "52" "54" "56" "58" "60" "63" "65" "67" "69" "71" "73" "74" "76" "76"
	set -A BLOB_PATTERN_84 "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "18" "18" "18" "19" "19" "19" "20" "20" "21" "21" "21" "22" "22" "23" "23" "24" "25" "25" "26" "27" "27" "28" "29" "30" "30" "31" "32" "33" "34" "36" "37" "38" "39" "41" "42" "44" "46" "48" "50" "52" "54" "56" "58" "61" "64" "66" "69" "71" "74" "76" "79" "80" "82" "83"
	set -A BLOB_PATTERN_85 "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "18" "18" "18" "19" "19" "19" "20" "20" "21" "21" "22" "22" "23" "23" "24" "24" "25" "25" "26" "27" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "39" "40" "42" "43" "45" "47" "49" "51" "53" "56" "58" "61" "64" "67" "70" "73" "76" "79" "82" "85" "87" "89" "90"
	set -A BLOB_PATTERN_86 "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "18" "18" "18" "19" "19" "19" "20" "20" "21" "21" "22" "22" "23" "23" "24" "24" "25" "26" "26" "27" "28" "29" "29" "30" "31" "32" "33" "34" "35" "37" "38" "39" "41" "42" "44" "46" "48" "50" "52" "55" "58" "60" "64" "67" "70" "74" "78" "81" "85" "89" "92" "95" "98" "99"
	set -A BLOB_PATTERN_87 "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "15" "15" "15" "15" "15" "16" "16" "16" "17" "17" "17" "17" "18" "18" "18" "19" "19" "20" "20" "20" "21" "21" "22" "22" "23" "23" "24" "24" "25" "26" "26" "27" "28" "29" "30" "30" "31" "32" "34" "35" "36" "37" "39" "40" "42" "43" "45" "47" "49" "51" "54" "57" "60" "63" "66" "70" "74" "78" "83" "87" "92" "97" "101" "105" "108" "110"
	set -A BLOB_PATTERN_88 "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "13" "14" "14" "14" "14" "15" "15" "15" "15" "15" "16" "16" "16" "17" "17" "17" "17" "18" "18" "19" "19" "19" "20" "20" "20" "21" "21" "22" "22" "23" "23" "24" "25" "25" "26" "27" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "38" "39" "41" "42" "44" "46" "48" "50" "53" "55" "58" "62" "65" "69" "73" "78" "83" "88" "94" "100" "105" "111" "117" "121" "124"
	set -A BLOB_PATTERN_89 "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "18" "18" "18" "19" "19" "19" "20" "20" "21" "21" "21" "22" "22" "23" "24" "24" "25" "25" "26" "27" "28" "28" "29" "30" "31" "32" "33" "34" "35" "37" "38" "40" "41" "43" "45" "47" "49" "51" "54" "57" "60" "63" "67" "71" "76" "81" "87" "94" "101" "108" "116" "124" "131" "137" "141"
	set -A BLOB_PATTERN_90 "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "18" "18" "18" "19" "19" "19" "20" "20" "21" "21" "22" "22" "23" "23" "24" "24" "25" "25" "26" "27" "28" "28" "29" "30" "31" "32" "33" "34" "36" "37" "38" "40" "42" "43" "45" "47" "50" "52" "55" "58" "61" "65" "69" "74" "79" "85" "92" "100" "108" "117" "128" "138" "149" "158" "164"
	set -A BLOB_PATTERN_91 "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "18" "18" "18" "19" "19" "19" "20" "20" "21" "21" "22" "22" "23" "23" "24" "24" "25" "26" "26" "27" "28" "29" "29" "30" "31" "32" "33" "35" "36" "37" "39" "40" "42" "44" "46" "48" "50" "53" "56" "59" "63" "67" "71" "76" "82" "89" "97" "105" "116" "128" "141" "156" "171" "185" "196"
	set -A BLOB_PATTERN_92 "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "18" "18" "18" "19" "19" "19" "20" "20" "21" "21" "22" "22" "23" "23" "24" "24" "25" "26" "26" "27" "28" "29" "30" "31" "31" "33" "34" "35" "36" "38" "39" "41" "42" "44" "46" "49" "51" "54" "57" "60" "64" "68" "73" "79" "85" "92" "101" "111" "124" "138" "156" "176" "200" "223" "242"
	set -A BLOB_PATTERN_93 "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "18" "18" "18" "19" "19" "19" "20" "20" "21" "21" "22" "22" "23" "23" "24" "24" "25" "26" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "38" "39" "41" "43" "45" "47" "49" "51" "54" "57" "61" "65" "69" "74" "80" "87" "95" "105" "117" "131" "149" "171" "200" "235" "255" "255"
	set -A BLOB_PATTERN_94 "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "18" "18" "18" "19" "19" "19" "20" "20" "21" "21" "22" "22" "23" "23" "24" "24" "25" "26" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "38" "39" "41" "43" "45" "47" "49" "52" "55" "58" "62" "66" "70" "76" "82" "89" "98" "108" "121" "137" "158" "185" "223" "255" "255" "255"
	set -A BLOB_PATTERN_95 "10" "10" "10" "10" "10" "10" "11" "11" "11" "11" "11" "11" "11" "12" "12" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "16" "16" "16" "16" "17" "17" "17" "18" "18" "18" "19" "19" "19" "20" "20" "21" "21" "22" "22" "23" "23" "24" "24" "25" "26" "27" "27" "28" "29" "30" "31" "32" "33" "34" "35" "37" "38" "39" "41" "43" "45" "47" "49" "52" "55" "58" "62" "66" "71" "76" "83" "90" "99" "110" "124" "141" "164" "196" "242" "255" "255" "255"

	set -A BLOB_SINUS_112 "56" "57" "57" "58" "59" "59" "60" "61" "61" "62" "63" "63" "64" "65" "65" "66" "67" "67" "68" "69" "69" "70" "70" "71" "72" "72" "73" "73" "74" "74" "75" "75" "76" "76" "77" "77" "78" "78" "78" "79" "79" "80" "80" "80" "81" "81" "81" "82" "82" "82" "82" "83" "83" "83" "83" "83" "83" "84" "84" "84" "84" "84" "84" "84" "84" "84" "84" "84" "84" "84" "84" "84" "83" "83" "83" "83" "83" "83" "82" "82" "82" "82" "81" "81" "81" "80" "80" "80" "79" "79" "78" "78" "78" "77" "77" "76" "76" "75" "75" "74" "74" "73" "73" "72" "72" "71" "70" "70" "69" "69" "68" "67" "67" "66" "65" "65" "64" "63" "63" "62" "61" "61" "60" "59" "59" "58" "57" "57" "56" "55" "55" "54" "53" "53" "52" "51" "51" "50" "49" "49" "48" "47" "47" "46" "45" "45" "44" "43" "43" "42" "42" "41" "40" "40" "39" "39" "38" "38" "37" "37" "36" "36" "35" "35" "34" "34" "34" "33" "33" "32" "32" "32" "31" "31" "31" "30" "30" "30" "30" "29" "29" "29" "29" "29" "29" "28" "28" "28" "28" "28" "28" "28" "28" "28" "28" "28" "28" "28" "28" "28" "29" "29" "29" "29" "29" "29" "30" "30" "30" "30" "31" "31" "31" "32" "32" "32" "33" "33" "34" "34" "34" "35" "35" "36" "36" "37" "37" "38" "38" "39" "39" "40" "40" "41" "42" "42" "43" "43" "44" "45" "45" "46" "47" "47" "48" "49" "49" "50" "51" "51" "52" "53" "53" "54" "55" "55"

	set -A BLOB_SINUS_170 "85" "86" "86" "87" "87" "88" "88" "89" "89" "90" "90" "91" "91" "92" "92" "93" "93" "94" "94" "94" "95" "95" "96" "96" "97" "97" "98" "98" "98" "99" "99" "99" "100" "100" "101" "101" "101" "102" "102" "102" "102" "103" "103" "103" "104" "104" "104" "104" "104" "105" "105" "105" "105" "105" "105" "105" "106" "106" "106" "106" "106" "106" "106" "106" "106" "106" "106" "106" "106" "106" "106" "106" "106" "105" "105" "105" "105" "105" "105" "105" "104" "104" "104" "104" "104" "103" "103" "103" "102" "102" "102" "102" "101" "101" "101" "100" "100" "99" "99" "99" "98" "98" "98" "97" "97" "96" "96" "95" "95" "94" "94" "94" "93" "93" "92" "92" "91" "91" "90" "90" "89" "89" "88" "88" "87" "87" "86" "86" "85" "84" "84" "83" "83" "82" "82" "81" "81" "80" "80" "79" "79" "78" "78" "77" "77" "76" "76" "76" "75" "75" "74" "74" "73" "73" "72" "72" "72" "71" "71" "71" "70" "70" "69" "69" "69" "68" "68" "68" "68" "67" "67" "67" "66" "66" "66" "66" "66" "65" "65" "65" "65" "65" "65" "65" "64" "64" "64" "64" "64" "64" "64" "64" "64" "64" "64" "64" "64" "64" "64" "64" "64" "65" "65" "65" "65" "65" "65" "65" "66" "66" "66" "66" "66" "67" "67" "67" "68" "68" "68" "68" "69" "69" "69" "70" "70" "71" "71" "71" "72" "72" "72" "73" "73" "74" "74" "75" "75" "76" "76" "76" "77" "77" "78" "78" "79" "79" "80" "80" "81" "81" "82" "82" "83" "83" "84" "84"

	for Y in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39" "40" "41" "42" "43" "44" "45" "46" "47" "48" "49" "50" "51" "52" "53" "54" "55" "56" "57" "58" "59" "60" "61" "62" "63" "64" "65" "66" "67" "68" "69" "70" "71" "72" "73" "74" "75" "76" "77" "78" "79" "80" "81" "82" "83" "84" "85" "86" "87" "88" "89" "90" "91" "92" "93" "94" "95"; do
		for X in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39" "40" "41" "42" "43" "44" "45" "46" "47" "48" "49" "50" "51" "52" "53" "54" "55" "56" "57" "58" "59" "60" "61" "62" "63" "64" "65" "66" "67" "68" "69" "70" "71" "72" "73" "74" "75" "76" "77" "78" "79" "80" "81" "82" "83" "84" "85" "86" "87" "88" "89" "90" "91" "92" "93" "94" "95"; do
			TMPY=$((191-${Y}))
			TMPX=$((191-${X}))
			eval BLOB_TABLE_${Y}[${X}]=\${BLOB_PATTERN_${Y}[${X}]}
			eval BLOB_TABLE_${Y}[${TMPX}]=\${BLOB_PATTERN_${Y}[${X}]}
			eval BLOB_TABLE_${TMPY}[${X}]=\${BLOB_PATTERN_${Y}[${X}]}
			eval BLOB_TABLE_${TMPY}[${TMPX}]=\${BLOB_PATTERN_${Y}[${X}]}
		done
	done
	BLOB_POS_X[0]="0"
	BLOB_POS_Y[0]="0"
	BLOB_POS_X[1]="0"
	BLOB_POS_Y[1]="0"
	BLOB_POS_X[2]="0"
	BLOB_POS_Y[2]="0"
	BLOB_STEP_X[0]="254"
	BLOB_STEP_Y[0]="255"
	BLOB_STEP_X[1]="3"
	BLOB_STEP_Y[1]="5"
	BLOB_STEP_X[2]="1"
	BLOB_STEP_Y[2]="255"
}

########################################################################

blobs_render()
{
	FINISH=$((`date +%s`+$1))
	BLOB_COUNTER="0"
	while [ ${FINISH} -ge `date +%s` ]; do
# blob - calculate
		SEEK0_X=${BLOB_SINUS_112[${BLOB_POS_X[0]}]}
		SEEK0_Y=${BLOB_SINUS_170[${BLOB_POS_Y[0]}]}
		SEEK1_X=${BLOB_SINUS_112[${BLOB_POS_X[1]}]}
		SEEK1_Y=${BLOB_SINUS_170[${BLOB_POS_Y[1]}]}
		SEEK2_X=${BLOB_SINUS_112[${BLOB_POS_X[2]}]}
		SEEK2_Y=${BLOB_SINUS_170[${BLOB_POS_Y[2]}]}
		BLOB_POS_X[0]=$(((${BLOB_POS_X[0]}+${BLOB_STEP_X[0]})&255))
		BLOB_POS_Y[0]=$(((${BLOB_POS_Y[0]}+${BLOB_STEP_Y[0]})&255))
		BLOB_POS_X[1]=$(((${BLOB_POS_X[1]}+${BLOB_STEP_X[1]})&255))
		BLOB_POS_Y[1]=$(((${BLOB_POS_Y[1]}+${BLOB_STEP_Y[1]})&255))
		BLOB_POS_X[2]=$(((${BLOB_POS_X[2]}+${BLOB_STEP_X[2]})&255))
		BLOB_POS_Y[2]=$(((${BLOB_POS_Y[2]}+${BLOB_STEP_Y[2]})&255))
		for Y in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21"; do
			for X in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39" "40" "41" "42" "43" "44" "45" "46" "47" "48" "49" "50" "51" "52" "53" "54" "55" "56" "57" "58" "59" "60" "61" "62" "63" "64" "65" "66" "67" "68" "69" "70" "71" "72" "73" "74" "75" "76" "77" "78" "79"; do
				LOCAL0_X=$((${X}+${SEEK0_X}))
				LOCAL0_Y=$((${Y}+${SEEK0_Y}))
				LOCAL1_X=$((${X}+${SEEK1_X}))
				LOCAL1_Y=$((${Y}+${SEEK1_Y}))
				LOCAL2_X=$((${X}+${SEEK2_X}))
				LOCAL2_Y=$((${Y}+${SEEK2_Y}))
				eval TABLE_${Y}[${X}]=\${0+BLOB_TABLE_${LOCAL0_Y}[${LOCAL0_X}]+BLOB_TABLE_${LOCAL1_Y}[${LOCAL1_X}]+BLOB_TABLE_${LOCAL2_Y}[${LOCAL2_X}]}
			done
		done
# blob - render
		tput cup 0 0
		SCREEN_UP=""
		SCREEN_DOWN=""
		for Y in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10"; do
			LINE_UP=""
			for X in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39" "40" "41" "42" "43" "44" "45" "46" "47" "48" "49" "50" "51" "52" "53" "54" "55" "56" "57" "58" "59" "60" "61" "62" "63" "64" "65" "66" "67" "68" "69" "70" "71" "72" "73" "74" "75" "76" "77" "78" "79"; do
				eval VALUE=\${TABLE_${Y}[${X}]}
				if [ "${VALUE}" -gt "255" ]; then
					CHAR="#"
				else
					CHAR=${BLOB_CHARS[${VALUE}]}
				fi
				LINE_UP="${LINE_UP}${CHAR}"
			done
			SCREEN_UP="${SCREEN_UP}${LINE_UP}\n"
		done

		for Y in "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21"; do
			LINE_DOWN=""
			for X in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39" "40" "41" "42" "43" "44" "45" "46" "47" "48" "49" "50" "51" "52" "53" "54" "55" "56" "57" "58" "59" "60" "61" "62" "63" "64" "65" "66" "67" "68" "69" "70" "71" "72" "73" "74" "75" "76" "77" "78" "79"; do
				eval VALUE=\${TABLE_${Y}[${X}]}
				if [ "${VALUE}" -gt "255" ]; then
					CHAR="#"
				else
					CHAR=${BLOB_CHARS[${VALUE}]}
				fi
				LINE_DOWN="${LINE_DOWN}${CHAR}"
			done
			if [ "${Y}" != "21" ]; then
				SCREEN_DOWN="${SCREEN_DOWN}${LINE_DOWN}\n"
			else
				SCREEN_DOWN="${SCREEN_DOWN}${LINE_DOWN}"
			fi
		done
		SCREEN="                                                                                \n${SCREEN_UP}${SCREEN_DOWN}"
		print "${SCREEN}"
		BLOB_COUNTER=$((${BLOB_COUNTER}+1))
	done
}

########################################################################

wiggle_init()
{
	set -A WIGGLE_SINUS "10" "10" "10" "11" "11" "11" "11" "12" "12" "12" "12" "12" "13" "13" "13" "13" "13" "14" "14" "14" "14" "14" "15" "15" "15" "15" "15" "16" "16" "16" "16" "16" "16" "17" "17" "17" "17" "17" "17" "17" "17" "18" "18" "18" "18" "18" "18" "18" "18" "18" "18" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19" "19" "18" "18" "18" "18" "18" "18" "18" "18" "18" "18" "17" "17" "17" "17" "17" "17" "17" "17" "16" "16" "16" "16" "16" "16" "15" "15" "15" "15" "15" "14" "14" "14" "14" "14" "13" "13" "13" "13" "13" "12" "12" "12" "12" "12" "11" "11" "11" "11" "10" "10" "10" "10" "10" "9" "9" "9" "9" "8" "8" "8" "8" "8" "7" "7" "7" "7" "7" "6" "6" "6" "6" "6" "5" "5" "5" "5" "5" "4" "4" "4" "4" "4" "4" "3" "3" "3" "3" "3" "3" "3" "3" "2" "2" "2" "2" "2" "2" "2" "2" "2" "2" "1" "1" "1" "1" "1" "1" "1" "1" "1" "1" "1" "1" "1" "1" "1" "1" "1" "1" "1" "1" "1" "1" "1" "1" "1" "1" "1" "2" "2" "2" "2" "2" "2" "2" "2" "2" "2" "3" "3" "3" "3" "3" "3" "3" "3" "4" "4" "4" "4" "4" "4" "5" "5" "5" "5" "5" "6" "6" "6" "6" "6" "7" "7" "7" "7" "7" "8" "8" "8" "8" "8" "9" "9" "9" "9" "10" "10"

	set -A WIGGLE_PATTERN_LEFT " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " "-" "+" "H" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#"

	set -A WIGGLE_PATTERN_RIGHT " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " "." "o" "O" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#" "#"
}

########################################################################

wiggle_render()
{
	INDEX_LEFT1="0"
	INDEX_LEFT2="0"
	INDEX_LEFT3="0"
	INDEX_LEFT4="0"
	INDEX_RIGHT1="0"
	INDEX_RIGHT2="0"
	INDEX_RIGHT3="0"
	INDEX_RIGHT4="0"

	WIGGLE_COUNTER="0"
	FINISH=$((`date +%s`+$1))
	while [ ${FINISH} -ge `date +%s` ]; do
# wiggle - render
		tput cup 0 0
		SCREEN_UP=""
		SCREEN_DOWN=""
		INDEX_LEFT1=$(((${INDEX_LEFT1}+250)%256))
		INDEX_LEFT2=$(((${INDEX_LEFT2}+3)%256))
		INDEX_LEFT3=${INDEX_LEFT1}
		INDEX_LEFT4=${INDEX_LEFT2}
		INDEX_RIGHT1=$(((${INDEX_RIGHT1}+253)%256))
		INDEX_RIGHT2=$(((${INDEX_RIGHT2}+5)%256))
		INDEX_RIGHT3=${INDEX_RIGHT1}
		INDEX_RIGHT4=${INDEX_RIGHT2}
		for Y in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10"; do
			INDEX_LEFT3=$(((${INDEX_LEFT3}+11)%256))
			INDEX_LEFT4=$(((${INDEX_LEFT4}+17)%256))
			INDEX_RIGHT3=$(((${INDEX_RIGHT3}+30)%256))
			INDEX_RIGHT4=$(((${INDEX_RIGHT4}+224)%256))
			LINE_UP=""
			TEMP_LEFT=$((${WIGGLE_SINUS[${INDEX_LEFT3}]}+${WIGGLE_SINUS[${INDEX_LEFT4}]}))
			TEMP_RIGHT=$((${WIGGLE_SINUS[${INDEX_RIGHT3}]}+${WIGGLE_SINUS[${INDEX_RIGHT4}]}))
			for X in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39"; do
				LINE_UP="${LINE_UP}${WIGGLE_PATTERN_LEFT[${X}+${TEMP_LEFT}]}"
			done
			for X in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39"; do
				LINE_UP="${LINE_UP}${WIGGLE_PATTERN_RIGHT[40-${X}+${TEMP_RIGHT}]}"
			done
			SCREEN_UP="${SCREEN_UP}${LINE_UP}\n"
		done
		for Y in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10"; do
			INDEX_LEFT3=$(((${INDEX_LEFT3}+11)%256))
			INDEX_LEFT4=$(((${INDEX_LEFT4}+17)%256))
			INDEX_RIGHT3=$(((${INDEX_RIGHT3}+30)%256))
			INDEX_RIGHT4=$(((${INDEX_RIGHT4}+224)%256))
			LINE_DOWN=""
			TEMP_LEFT=$((${WIGGLE_SINUS[${INDEX_LEFT3}]}+${WIGGLE_SINUS[${INDEX_LEFT4}]}))
			TEMP_RIGHT=$((${WIGGLE_SINUS[${INDEX_RIGHT3}]}+${WIGGLE_SINUS[${INDEX_RIGHT4}]}))
			for X in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39"; do
				LINE_DOWN="${LINE_DOWN}${WIGGLE_PATTERN_LEFT[${X}+${TEMP_LEFT}]}"
			done
			for X in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39"; do
				LINE_DOWN="${LINE_DOWN}${WIGGLE_PATTERN_RIGHT[40-${X}+${TEMP_RIGHT}]}"
			done
			if [ "${Y}" != "10" ]; then
				SCREEN_DOWN="${SCREEN_DOWN}${LINE_DOWN}\n"
			else
				SCREEN_DOWN="${SCREEN_DOWN}${LINE_DOWN}"
			fi
		done
		SCREEN="                                                                                \n${SCREEN_UP}${SCREEN_DOWN}"
		print "${SCREEN}"
		WIGGLE_COUNTER=$((${WIGGLE_COUNTER}+1))
	done
}

########################################################################

clock_init()
{
	set -A CLOCK_POS_X "5" "12" "24" "31" "43" "50" "62" "69" "-1"

	set -A CLOCK_POS_Y "1" "6" "11" "16"

	set -A CLOCK_POWER_2 "8" "4" "2" "1"

	for A in `seq 0 879`; do
		CLOCK_TAB_UP[${A}]=" "
		CLOCK_TAB_DOWN[${A}]=" "
	done
}

########################################################################

clock_render()
{
	FINISH=$((`date +%s`+$1))
	CLOCK_COUNTER="0"
	while [ ${FINISH} -ge `date +%s` ]; do
		tput cup 0 0
# clock - calculate
		COLUMN_COUNT="0"
		TIME=`date +%H%M%S%N | fold -w1`
		for A in ${TIME}; do
			if [ ${CLOCK_POS_X[${COLUMN_COUNT}]} == "-1" ]; then
				break;
			fi
			for B in "0" "1" "2" "3"; do
				if [ ${A} -ge ${CLOCK_POWER_2[${B}]} ]; then
					A=$((${A}-${CLOCK_POWER_2[${B}]}))
					CHAR="O"
				else
					CHAR="."
				fi
				for Y0 in "0" "1" "2" "3"; do
					for X0 in "0" "1" "2" "3" "4" "5"; do
						X1=$((${X0}+${CLOCK_POS_X[${COLUMN_COUNT}]}))
						Y1=$((${Y0}+${CLOCK_POS_Y[${B}]}))
						if [ ${Y1} -ge "11" ]; then
							CLOCK_TAB_DOWN[$(((${Y1}-11)*80+${X1}))]=${CHAR}
						else
							CLOCK_TAB_UP[$((${Y1}*80+${X1}))]=${CHAR}
						fi
					done
				done
			done
			COLUMN_COUNT=$((${COLUMN_COUNT}+1))
		done
# clock - render
		SCREEN_UP=""
		SCREEN_DOWN=""
		for Y in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10"; do
			LINE_UP=""
			for X in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39" "40" "41" "42" "43" "44" "45" "46" "47" "48" "49" "50" "51" "52" "53" "54" "55" "56" "57" "58" "59" "60" "61" "62" "63" "64" "65" "66" "67" "68" "69" "70" "71" "72" "73" "74" "75" "76" "77" "78" "79"; do
				LINE_UP="${LINE_UP}${CLOCK_TAB_UP[$((${Y}*80+${X}))]}"
			done
			SCREEN_UP="${SCREEN_UP}${LINE_UP}\n"
		done
		for Y in "0" "1" "2" "3" "4" "5" "6" "7" "8"; do
			LINE_DOWN=""
			for X in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39" "40" "41" "42" "43" "44" "45" "46" "47" "48" "49" "50" "51" "52" "53" "54" "55" "56" "57" "58" "59" "60" "61" "62" "63" "64" "65" "66" "67" "68" "69" "70" "71" "72" "73" "74" "75" "76" "77" "78" "79"; do
				LINE_DOWN="${LINE_DOWN}${CLOCK_TAB_DOWN[$((${Y}*80+${X}))]}"
			done
			SCREEN_DOWN="${SCREEN_DOWN}${LINE_DOWN}\n"
		done
		SCREEN="                                                                                \n                                                                                \n${SCREEN_UP}${SCREEN_DOWN}                                                                                "
		print "${SCREEN}"
		CLOCK_COUNTER=$((${CLOCK_COUNTER}+1))
	done
}

########################################################################

tunnel_init()
{
	set -A TUNNEL_TEXTURE "#" "#" "#" "#" "#" "#" "#" "#" "." "." "." "." "." "." "." "." "#" "#" "#" "#" "#" "#" "#" "#" "." "." "." "." "." "." "." "." " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " "." "." "." "." "." "." "." "." "." "." "." "." "." "." "." "."

	set -A TUNNEL_SCHAPE "12" "12" "12" "13" "13" "14" "14" "15" "15" "15" "0" "1" "1" "2" "2" "3" "4" "5" "5" "6" "7" "8" "10" "11" "12" "14" "15" "1" "3" "6" "9" "12" "0" "5" "12" "5" "32" "32" "32" "32" "32" "32" "32" "5" "12" "5" "0" "12" "9" "6" "3" "1" "15" "14" "12" "11" "10" "8" "7" "6" "5" "5" "4" "3" "2" "2" "1" "1" "0" "15" "15" "15" "14" "14" "13" "13" "12" "12" "12" "11" "12" "12" "12" "13" "13" "14" "14" "15" "15" "15" "0" "1" "1" "2" "2" "3" "4" "5" "5" "6" "7" "8" "9" "11" "12" "14" "15" "1" "3" "6" "8" "12" "15" "4" "10" "2" "32" "32" "32" "32" "32" "32" "32" "2" "10" "4" "15" "12" "8" "6" "3" "1" "15" "14" "12" "11" "9" "8" "7" "6" "5" "5" "4" "3" "2" "2" "1" "1" "0" "15" "15" "15" "14" "14" "13" "13" "12" "12" "12" "11" "12" "12" "12" "13" "13" "14" "14" "14" "15" "15" "0" "0" "1" "2" "2" "3" "4" "4" "5" "6" "7" "8" "9" "10" "12" "13" "15" "1" "3" "5" "7" "10" "14" "2" "6" "12" "32" "32" "32" "32" "32" "32" "32" "12" "6" "2" "14" "10" "7" "5" "3" "1" "15" "13" "12" "10" "9" "8" "7" "6" "5" "4" "4" "3" "2" "2" "1" "0" "0" "15" "15" "14" "14" "14" "13" "13" "12" "12" "12" "11" "12" "12" "12" "13" "13" "14" "14" "14" "15" "15" "0" "0" "1" "2" "2" "3" "4" "4" "5" "6" "7" "8" "9" "10" "11" "13" "14" "0" "2" "4" "6" "8" "11" "14" "1" "4" "5" "32" "32" "32" "32" "32" "5" "4" "1" "14" "11" "8" "6" "4" "2" "0" "14" "13" "11" "10" "9" "8" "7" "6" "5" "4" "4" "3" "2" "2" "1" "0" "0" "15" "15" "14" "14" "14" "13" "13" "12" "12" "12" "11" "12" "12" "12" "13" "13" "13" "14" "14" "15" "15" "0" "0" "1" "1" "2" "3" "3" "4" "5" "6" "6" "7" "8" "10" "11" "12" "13" "15" "0" "2" "4" "6" "8" "10" "11" "12" "11" "6" "48" "48" "48" "6" "11" "12" "11" "10" "8" "6" "4" "2" "0" "15" "13" "12" "11" "10" "8" "7" "6" "6" "5" "4" "3" "3" "2" "1" "1" "0" "0" "15" "15" "14" "14" "13" "13" "13" "12" "12" "12" "11" "12" "12" "12" "13" "13" "13" "14" "14" "15" "15" "0" "0" "1" "1" "2" "2" "3" "4" "4" "5" "6" "7" "8" "9" "10" "11" "12" "14" "15" "0" "2" "3" "4" "5" "6" "5" "3" "13" "48" "48" "48" "13" "3" "5" "6" "5" "4" "3" "2" "0" "15" "14" "12" "11" "10" "9" "8" "7" "6" "5" "4" "4" "3" "2" "2" "1" "1" "0" "0" "15" "15" "14" "14" "13" "13" "13" "12" "12" "12" "11" "11" "12" "12" "12" "13" "13" "14" "14" "14" "15" "15" "0" "0" "1" "1" "2" "3" "3" "4" "5" "6" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "0" "1" "1" "1" "15" "12" "6" "48" "48" "48" "6" "12" "15" "1" "1" "1" "0" "15" "14" "13" "12" "11" "10" "9" "8" "7" "6" "6" "5" "4" "3" "3" "2" "1" "1" "0" "0" "15" "15" "14" "14" "14" "13" "13" "12" "12" "12" "11" "11" "11" "12" "12" "12" "13" "13" "13" "14" "14" "15" "15" "0" "0" "1" "1" "2" "2" "3" "4" "4" "5" "6" "6" "7" "8" "9" "10" "11" "11" "12" "13" "13" "14" "13" "12" "10" "7" "1" "48" "48" "48" "1" "7" "10" "12" "13" "14" "13" "13" "12" "11" "11" "10" "9" "8" "7" "6" "6" "5" "4" "4" "3" "2" "2" "1" "1" "0" "0" "15" "15" "14" "14" "13" "13" "13" "12" "12" "12" "11" "11" "11" "12" "12" "12" "13" "13" "13" "14" "14" "14" "15" "15" "0" "0" "1" "1" "2" "2" "3" "4" "4" "5" "6" "6" "7" "8" "8" "9" "10" "10" "11" "11" "11" "10" "9" "6" "3" "14" "48" "48" "48" "14" "3" "6" "9" "10" "11" "11" "11" "10" "10" "9" "8" "8" "7" "6" "6" "5" "4" "4" "3" "2" "2" "1" "1" "0" "0" "15" "15" "14" "14" "14" "13" "13" "13" "12" "12" "12" "11" "11" "11" "11" "12" "12" "12" "13" "13" "13" "14" "14" "15" "15" "15" "0" "0" "1" "1" "2" "2" "3" "4" "4" "5" "5" "6" "7" "7" "8" "8" "8" "8" "8" "8" "7" "5" "3" "15" "11" "48" "48" "48" "11" "15" "3" "5" "7" "8" "8" "8" "8" "8" "8" "7" "7" "6" "5" "5" "4" "4" "3" "2" "2" "1" "1" "0" "0" "15" "15" "15" "14" "14" "13" "13" "13" "12" "12" "12" "11" "11" "11" "11" "11" "12" "12" "12" "12" "13" "13" "14" "14" "14" "15" "15" "0" "0" "0" "1" "1" "2" "2" "3" "3" "4" "4" "5" "5" "6" "6" "6" "6" "6" "6" "5" "4" "2" "0" "13" "8" "48" "48" "48" "8" "13" "0" "2" "4" "5" "6" "6" "6" "6" "6" "6" "5" "5" "4" "4" "3" "3" "2" "2" "1" "1" "0" "0" "0" "15" "15" "14" "14" "14" "13" "13" "12" "12" "12" "12" "11" "11" "11"
}

########################################################################

tunnel_render()
{
	SEEK="0"

	FINISH=$((`date +%s`+$1))
	TUNNEL_COUNTER="0"
	while [ ${FINISH} -ge `date +%s` ]; do
		tput cup 0 0
# tunnel - render
		SCREEN_UP=""
		SCREEN_DOWN=""
		for Y in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10"; do
			LINE=""
			for X in "0" "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20" "21" "22" "23" "24" "25" "26" "27" "28" "29" "30" "31" "32" "33" "34" "35" "36" "37" "38" "39" "40" "41" "42" "43" "44" "45" "46" "47" "48" "49" "50" "51" "52" "53" "54" "55" "56" "57" "58" "59" "60" "61" "62" "63" "64" "65" "66" "67" "68" "69" "70" "71" "72" "73" "74" "75" "76" "77" "78" "79"; do
				LINE="${LINE}${TUNNEL_TEXTURE[$((${TUNNEL_SCHAPE[$((${Y}*80+${X}))]}+${SEEK}))]}"
			done
			SCREEN_UP="${LINE}\n${SCREEN_UP}"
			if [ "${Y}" != "10" ]; then
				SCREEN_DOWN="${SCREEN_DOWN}${LINE}\n"
			else
				SCREEN_DOWN="${SCREEN_DOWN}${LINE}"
			fi
		done
		SCREEN="                                                                                \n${SCREEN_UP}${SCREEN_DOWN}"
		print "${SCREEN}"
		SEEK=$(((${SEEK}+1)&15))
		TUNNEL_COUNTER=$((${TUNNEL_COUNTER}+1))
	done
}

########################################################################

lastscreen()
{
	clear
	tput cup 0 0
	echo " you have been watching:                                                                               "
	echo "                                                                                "
	echo "                                                                                "
	echo "                      ---+++###  U N R E A L I S E D  ###+++---                 "
	echo "                                                                                "
	echo "                                                                                "
	echo "                                      a demo by                                 "
	echo "                                                                                "
	echo "                                         mec                                    "
	echo "                                                                                "
	echo "                                                                                "
	echo "  ----------------------------------------------------------------------------  "
	echo "                                                                                "
	echo "                                  T H A N K   Y O U                             "
	echo "                                                                                "
	echo "                                        a n d                                   "
	echo "                                                                                "
	echo "                                 G O O D   N I G H T                            "
	echo "                                                                                "
	echo "                                                                                "
	echo "  ----------------------------------------------------------------------------  "
	echo "                                                                      mec, MMXI "

	while [ "1" = "1" ]; do
		sleep 10
	done
}

########################################################################
###                        M A I N    P A R T                        ###
########################################################################

clear

echo "Checking environment..."
check

echo "Initializing..."
fire_init
zoom_init
blobs_init
wiggle_init
clock_init
tunnel_init

play
trap quit EXIT INT TERM
blobs_render 6
clock_render 0
blobs_render 5
clock_render 1
blobs_render 7
sleep 2
wiggle_render 10
zoom_render 16
fire_render 12
clock_render 10
tunnel_render 10
zoom_render 10
wiggle_render 11
tunnel_render 5
fire_render 10
zoom_render 6
fire_render 16
blobs_render 16
lastscreen
echo "FIRE: ${FIRE_COUNTER}"
echo "ZOOM: ${ZOOM_COUNTER}"
echo "BLOB: ${BLOB_COUNTER}"
echo "WIGGLE: ${WIGGLE_COUNTER}"
echo "CLOCK: ${CLOCK_COUNTER}"
echo "TUNNEL: ${TUNNEL_COUNTER}"

########################################################################
###                              E N D                               ###
########################################################################
