#include "texture_generate.h"
#include <string.h> //memset

void pangotext(PangoLayout *layout, const char* txt, const char* font) {
    PangoFontDescription *desc;
    pango_layout_set_text(layout, txt, -1);
    desc = pango_font_description_from_string(font);
    pango_layout_set_font_description(layout, desc);
    pango_font_description_free(desc);
}

void rendertext(cairo_t *cr, const char* txt, const char* font) {
	PangoLayout *layout;
	layout = pango_cairo_create_layout(cr);

	pangotext(layout, txt, font);

    cairo_set_antialias(cr, CAIRO_ANTIALIAS_GRAY);
	cairo_new_path(cr);
	cairo_move_to(cr, 0, 0);
	//cairo_set_line_width(cr, 0.5);

	cairo_set_source_rgba(cr, 1.0, 1.0, 1.0, 1.0);
	pango_cairo_update_layout(cr, layout);

	pango_cairo_layout_path(cr, layout);
    cairo_fill_preserve(cr);
	//cairo_stroke_preserve(cr);

	g_object_unref(layout);
}

void get_pixel_size(const char* txt, const char* font, int *w, int *h) {
    PangoLayout *layout;
    cairo_t *cr;
    cairo_surface_t *surface;

    //pango constructs need cairo context which needs surface, create temporary one
    surface = cairo_image_surface_create(CAIRO_FORMAT_ARGB32, 0, 0);
    cr = cairo_create(surface);
    layout = pango_cairo_create_layout(cr);

    //generate text with pango
    pangotext(layout, txt, font);

    //get pixel size for real rendering surface
    pango_layout_get_pixel_size(layout, w, h);
    
    //cleanup
    g_object_unref(layout);
    cairo_destroy(cr);
    cairo_surface_destroy(surface);
}

image_t* create_text_image(const char* txt, const char* font) {
    image_t *img;
    cairo_t *cr;
    cairo_surface_t *surface;

    img = malloc(sizeof(image_t));

    get_pixel_size(txt, font, &img->width, &img->height);

    img->stride = cairo_format_stride_for_width(CAIRO_FORMAT_ARGB32, img->width);
    img->idata = malloc(img->stride * img->height);
    memset(img->idata, 0, img->stride * img->height);

    surface = cairo_image_surface_create_for_data(img->idata, CAIRO_FORMAT_ARGB32, img->width, img->height, img->stride);
    cr = cairo_create(surface);

    cairo_set_source_rgba(cr, 1.0, 1.0, 1.0, 0.0);
    cairo_paint(cr);
    rendertext(cr, txt, font);

    cairo_destroy(cr);
/*    cairo_surface_write_to_png(surface, "out2.png");*/
    cairo_surface_destroy(surface);

    /*printf("\n(C alkaa)\n");
    printf("%p\n%p\n", img->idata, img);
    printf("%d\n%d\n%d\n", img->width, img->height, img->stride);
    printf("\n(C päättyy)\n");*/
    return img;
}

void destroy_text_image(image_t *img) {
    free(img->idata);
    img->idata = NULL;
    free(img);
    img = NULL;
}
