module Main where

import Graphics.GPipe
import Graphics.GPipe.Texture.Load
import Graphics.UI.GLUT hiding (RGB8, RGBA8)
import Graphics.UI.GLUT.Window 
import Graphics.UI.GLUT.Callbacks 
import System.Exit (exitWith, ExitCode(ExitSuccess))
import Data.IORef
import Control.Monad.State
import Textures
import Env
import Types
import ImageDump
import Foreign.Ptr
import qualified Scheduler as SC
import qualified Util as U
import qualified DisplayUtils as DU

import TextEvents (rawTextEvents)

main :: IO ()
main = do
    getArgsAndInitialize
    env <- initEnv
    putStrLn "Creating window..."

    textEvents <- mapM U.load rawTextEvents
    haskellTexture <- loadTexture RGBA8 "haskell_bg.png"
    letterTexture <- loadTexture RGBA8 "letters.png"
    let cube = DU.generateCube 1 1
    let hresCube = DU.generateCube 11 11
    sceneValues <- return $ U.SceneValues haskellTexture letterTexture cube hresCube textEvents

--    renderOffline env sceneValues (1920:.1200:.())

    newWindow "Instanssi Invtro 2011"
        (100:.100:.())
        (720:.420:.())
        (renderFrame env sceneValues)
        initWindow
    fullScreen
    cursor $= None -- Hides mouse pointer.
    keyboardMouseCallback $= (Just (keyHandler env))
    putStrLn "Entering mainloop..."
    mainLoop 

renderOffline :: Env -> U.SceneValues -> Vec2 Int -> IO ()
renderOffline env sceneValues (w:.h:.()) = do
    let ptr = imageAlloc w h
    let frames = [ (frame, (fromIntegral frame) / 60  * 1000) | frame <- [1000..3200] ]
    let fbfunc = (\t -> SC.renderFrame (w:.h:.()) t sceneValues)

    _ <- mapM_ (\frame -> eject ptr (w:.h:.()) fbfunc frame) frames
    return ()

eject :: WordPtr -> Vec2 Int -> (Float -> Taulu) -> (Int, Float) -> IO ()    
eject ptr size fbfunc (n, time) = do
    putStrLn $ "Frame " ++ show n ++ " (" ++ (take 4 $ show time) ++ "s)"
    getFrameBufferColor UnsignedInt8_8_8_8 size (fbfunc time) (wordPtrToPtr ptr)
    imageWrite n ptr

renderFrame :: Env -> U.SceneValues -> Vec2 Int -> IO (Taulu)
renderFrame env sceneValues size = do
    updateEnv env
    frameinfo <- readIORef env
    t <- return $ time frameinfo
    return $ SC.renderFrame size t sceneValues

initWindow :: Window -> IO ()
initWindow win = idleCallback $= Just (postRedisplay (Just win))

-- |Doesn't exit the friendly way, but seems to work.
keyPress env (Char '\ESC') = do
    putStrLn "ESC pressed, exiting..."
    exitWith ExitSuccess

keyPress env (SpecialKey KeyLeft) = do
    seek (-1000) env --rewind
    return ()

keyPress env (SpecialKey KeyRight) = do
    seek 1000 env --skip
    return ()
    
keyPress env _ = do
    return ()

keyHandler env key _ _ _ = do
    keyPress env key
