#include <stdio.h>
#include <png++/png.hpp>
#include <iostream>
#include <sstream>
#include <iomanip>

using namespace std;


#define NUM_CHANNELS 4
#define CHANNEL_SIZE 1
#define PACKET_SIZE (NUM_CHANNELS*CHANNEL_SIZE)

static int width, height;

extern "C" unsigned int* image_alloc(int w, int h) { 
    unsigned int* ptr = (unsigned int*)malloc(w*h*PACKET_SIZE);
    if (!ptr) {
        printf("ABANDON SHIP!\n");
    }
    width = w;
    height = h;
    return ptr;
}

extern "C" void image_write(int N, unsigned int* ptr) {
    unsigned char* pixels = (unsigned char*)ptr;
    int w = width; int h = height;

    png::image< png::rgb_pixel > img(w, h);
    for (int j = 0; j < h; ++j) {
        for (int i = 0; i < w; ++i) {
            int coord = (h-j-1)*w*4+i*4;
            img[j][i] = png::rgb_pixel(pixels[coord+3],pixels[coord+2],pixels[coord+1]);
        }
    }
    stringstream formatter;
    formatter << "framedump";
    formatter << setw(5) << setfill('0') << N << ".png";
    
    img.write(formatter.str());
}


extern "C" void image_free(unsigned int* ptr) {
    if (ptr) {
        printf("Cleaning up\n");
        free(ptr);
    } else {
        printf("Alarm, pointer missing\n");
    }
}

void write_img(unsigned char* pixels, int w, int h, const std::string& prefix, int n) {

}


