import Graphics.GPipe
import Data.Vec hiding (map, sum, foldl)
import Data.Vec.LinAlg.Transform3D
import Data.IORef
import Data.Monoid
import Graphics.UI.GLUT (Window, mainLoop, postRedisplay, idleCallback, getArgsAndInitialize, ($=))
import System.Random    


main :: IO ()
main = do
    getArgsAndInitialize
    timeRef <- newIORef 0.0
    newWindow "Motion blur" (100:.100:.()) (800:.600:.()) (renderFrame timeRef) initWindow
    mainLoop
    where
        initWindow win = idleCallback $= Just (postRedisplay (Just win))

        renderFrame timeRef size = do
            time <- readIORef timeRef
            writeIORef timeRef (time + (1/60))
            return $ outFrameBuffer time size

            
quad :: PrimitiveStream Triangle (Vec4 (Vertex Float), Vec2 (Vertex Float))
quad = toGPUStream TriangleStrip $ zip vertices uvCoords
    where vertices = [ i:.j:.0:.1:.() :: Vec4 Float | i <- [-1,1], j <- [-1,1] ]
          uvCoords = [ i:.j:.() :: Vec2 Float | i <- [0,1], j <- [0,1] ]

uvPlane :: FragmentStream (Vec2 (Fragment Float))
uvPlane = rasterizeBack $ quad
            
outFrameBuffer :: Float -> Vec2 Int -> (FrameBuffer RGBFormat () ())
outFrameBuffer time size = paint out $ emptyFB
    where out = fmap (drawHypno $ toGPU time) uvPlane
          paint = paintColor NoBlending (RGB $ vec True)
          emptyFB = newFrameBufferColor (RGB 0)

drawHypno :: Fragment Float -> (Vec2 (Fragment Float)) -> Color RGBFormat (Fragment Float)
drawHypno time uv = RGB $ ifB (m <* 0.5) (0.6:.0.1:.0.3:.()) (1.0:.0.2:.0.4:.())
    where 
        (u:.v:.()) = uv * 2.0 - 1.0
        a = atan' u v
        r = norm $ u:.v:.()
        m = smoothstep 0 0.2 $ sin (a * 10 + r * 20 + time * 10)
        
        
atan' x y = ifB (x >* 0) a $ ifB ((x <* 0) &&* (y >=* 0)) (a + pi) (a - pi)
    where a = atan (y / x)
    
          
