module Main where

import Graphics.GPipe
import Graphics.GPipe.Texture.Load
import Graphics.UI.GLUT (Window, mainLoop, postRedisplay, idleCallback, getArgsAndInitialize, fullScreen, ($=))
import Graphics.UI.GLUT.Window (Cursor(None), cursor)
import Graphics.UI.GLUT.Callbacks (Key(Char),keyboardMouseCallback)
import System.Exit (exitWith, ExitCode(ExitSuccess))
import Data.IORef
import Control.Monad.State
import Textures
import Env
import DisplayUtils as DU
import CubeScene
import Types

main :: IO ()
main = do
    getArgsAndInitialize
    env <- initEnv
    putStrLn "Creating window..."
    cubeTex <- loadTexture RGBA8 "transparent_box.png"
    newWindow "Instanssi Invtro 2011"
        (100:.100:.())
        (1280:.720:.())
        (renderFrame env cubeTex)
        initWindow
    fullScreen
    cursor $= None -- Hides mouse pointer.
    keyboardMouseCallback $= (Just escExiter)
    putStrLn "Entering mainloop..."
    mainLoop

renderFrame :: Env -> Texture2D RGBAFormat -> Vec2 Int -> IO Taulu
renderFrame env tex size = do
    updateEnv env
    frameinfo <- readIORef env
    return $ cubeFrame bg (time frameinfo) size tex --renderCubes (time frameinfo)
  where
    bg = emptyFB 0.0 0.0 0.0 0.0

initWindow :: Window -> IO ()
initWindow win = idleCallback $= Just (postRedisplay (Just win))

-- |Doesn't exit the friendly way, but seems to work.
escExiter (Char '\ESC') _ _ _ = do
  putStrLn "ESC pressed, exiting..."
  exitWith ExitSuccess
escExiter _ _ _ _ = return ()
