module Types where

import Graphics.GPipe
import Data.Vec (Mat44)
-- Ajatuksena on, että efekteille annetaan aikaikkuna näkyvyydelle ja intensiteettifunktio.
-- Efekti saa parametrina kolme arvoa, jotka ovat:
--  Vahvuus: ikkunafunktion arvo, hyvä vaikkapa läpinäkyvyyden asettamiseksi
--  Aika: absoluuttinen aika ikkunan alusta, efektin alkuaika on siis ikkunan alkuaika
--  Suhteellisuus: suhteellinen aika ikkunan sisällä väliltä [0,1], efektin saa venymään aikaikkunaan

type Aika = Float
type Vahvuus = Float
type Suhteellisuus = Float

type Kuva = FragmentStream (Color RGBAFormat (Fragment Float))
type Taulu = FrameBuffer RGBAFormat DepthFormat ()
type Raapustin = Kuva -> Taulu -> Taulu
type Ikkuna = (Aika -> Aika -> Aika -> Vahvuus)
type Olotila = (Vahvuus, Aika, Suhteellisuus)
type Kurkistus = (Aika -> Olotila)
type Maisema = (Olotila -> Kuva) 
type Vitkutin = (Kurkistus, Maisema)

data SpanishGalleon = SpanishGalleon { 
    pohja :: [Vitkutin], -- Aivan alin
    tausta :: [Vitkutin], -- Vähän ylempänä, hyvä tekstuureille, spiraaleille, metapalloille
    geometria :: [Vitkutin], -- Keskivaiheilla, piirretään Z-testauksen kanssa (3D-kappaleille)
    edusta :: [Vitkutin] -- Päällä, tekstille ynnä muulle
}

type ModelPos = Vec3 (Fragment Float)
type WorldPos = Vec3 (Fragment Float)
type WorldNormal = Vec3 (Fragment Float)
type ParamCoord = Vec2 (Fragment Float)    

type Transform = (Mat44 Float, Mat44 Float, Mat44 Float)
type Geometry = PrimitiveStream Triangle (Vec3 (Vertex Float), Vec3 (Vertex Float), Vec2 (Vertex Float))
type GeometryTransformed = PrimitiveStream Triangle (VertexPosition, (Vec3 (Vertex Float), (Vec3 (Vertex Float)), Vec3 (Vertex Float), Vec2 (Vertex Float)))
type Fragments = FragmentStream (ModelPos, WorldPos, WorldNormal, ParamCoord)
