{-# OPTIONS_GHC -optc-D_REENTRANT #-}
{-# LANGUAGE ForeignFunctionInterface #-}

module TextGen where

import Foreign
import Foreign.C

data Image = Image { idata::Ptr CUChar, width::CInt, height::CInt, stride::CInt }

instance Storable Image where
  alignment _ = alignment(undefined :: Ptr ())
  sizeOf _ = (24)
  peek ptr = do
    idata <- (\hsc_ptr -> peekByteOff hsc_ptr 0) ptr
    width <- (\hsc_ptr -> peekByteOff hsc_ptr 8) ptr
    height <- (\hsc_ptr -> peekByteOff hsc_ptr 12) ptr
    stride <- (\hsc_ptr -> peekByteOff hsc_ptr 16) ptr
    return (Image idata width height stride)
  poke ptr (Image idata width height stride) = do
    (\hsc_ptr -> pokeByteOff hsc_ptr 0) ptr idata
    (\hsc_ptr -> pokeByteOff hsc_ptr 8) ptr width
    (\hsc_ptr -> pokeByteOff hsc_ptr 12) ptr height
    (\hsc_ptr -> pokeByteOff hsc_ptr 16) ptr stride

foreign import ccall "texture_generate.h create_text_image" createTextImage :: 
    CString -> CString -> IO (Ptr Image)


