module TextEvents (rawTextEvents) where

import Util
import Data.Vec

--0-7.0  (välissä 3.5), 7.0->14.0 kuorot mukaan
introt = [
    RawFlashText "Se käänty =D"                   5 (0.0:.(0.0):.())    $ FlashTimes 0    0.2 1.2 2.5,
    RawFlashText "\"I think that it's"            7 (0.0:.(0.32):.())   $ FlashTimes 3.2  3.8 12  15,
    RawFlashText "extraordinarily important that" 7 (0:.0.15:.())       $ FlashTimes 5    5.5 13  15,
    RawFlashText "we in computer science"         7 (0:.(-0.01):.())    $ FlashTimes 6.9  7.4 13  15,
    RawFlashText "keep fun in computing.\""       7 (0:.(-0.18):.())    $ FlashTimes 9.1  9.6 13  15,
    RawFlashText "-Alan Perlis"                   7 ((0.5):.(-0.4):.()) $ FlashTimes 11  11.5 13  15
  ]

--14.0-21.0
--nostetta
instanssihq = [
    RawFlashText "Instanssi" 20 (0:.0:.()) $ FlashTimes 14 14.5 20 21,
    RawFlashText "Jyväskylä, 13.-15.5.2011" 7 ((0.2):.(-0.16):.()) $ FlashTimes 14 14.5 20 21,

--21.0-28.0 pieni fiilistely
    RawFlashText "Beginner demoparty" 11 ((-0.3):.(-0.2):.()) $ FlashTimes 21 21 25 26.5,
    RawFlashText "Mitä on taiteellinen laskenta?" 6 ((-0.1):.(-0.31):.()) $ FlashTimes 23 25 28 28
  ]

--hiljasempi
--28.3-35.4


--aukeaa
--35.4-49.2
--hiljasempi huilujammailu
sisaltoa = [
    RawFlashText "Kalvosulkeisia" 14 ((-0.1):.(0.2):.()) $ FlashTimes 28 29 34 35,
    RawFlashText "Työpajoja  " 14 ((0.1):.(0.0):.())  $ FlashTimes 29 30 35 36,
    RawFlashText "Kompoja    " 14 ((-0.3):.(0.4):.()) $ FlashTimes 35 36 46 47,

    RawFlashText "Demokompo   "                   11 ((-0.1):.(0.2):.())    $ FlashTimes 36 37 40 41,
    RawFlashText "Ohjelmoitu, reaaliaikainen teos" 6 (0.2:.(0.08):.()) $ FlashTimes 36 37 40 41,
    RawFlashText "Salivalaistus ohjelmoitavissa  " 6 (0.2:.(0.0):.()) $ FlashTimes 36 37 40 41,

    RawFlashText "Robocode    "                   11 ((-0.1):.(-0.1):.()) $ FlashTimes 39 40 43 44,
    RawFlashText "Ammu, älä tule ammutuksi       " 6 (0.2:.(-0.22):.())    $ FlashTimes 39 40 43 44,
    RawFlashText "Hyvä syy kirjoittaa Javaa ;-)  " 6 (0.2:.(-0.3):.())     $ FlashTimes 39 40 43 44,

    RawFlashText "Summamutikka"                   11 ((-0.1):.(0.2):.())    $ FlashTimes 42 43 46 47,
    RawFlashText "Tavoitteena hämmennys          " 6 (0.2:.(0.08):.()) $ FlashTimes 42 43 46 47,

    RawFlashText "Musiikki    "                   11 ((-0.1):.(-0.1):.())  $ FlashTimes 44 45 48 49,
    RawFlashText "Grafiikka   "                   11 ((-0.1):.(-0.4):.()) $ FlashTimes 45 46 49 50
  ]

hotlambdalovin = [
    RawFlashImage "hll.png"          0.6 (0.0:.0.5:.()) $ FlashTimes 49 51 55 56,
    RawFlashText "Hot Lambda Lovin'" 11 (0.0:.0.0:.()) $ ctimes 51 5 2,
    RawFlashText "Ohjelmointi     $ eladith    " 5 (0.0:.(-0.1):.()) $ ctimes 51   5 1,
    RawFlashText "Lisärivit       $ deggis     " 5 (0.0:.(-0.17):.()) $ ctimes 51.5 5 1,
    RawFlashText "Musiikki        $ King Thrill" 5 (0.0:.(-0.24):.()) $ ctimes 52   5 1,
    RawFlashText "Lyriikat        $ zipola     " 5 (0.0:.(-0.31):.()) $ ctimes 52.5 5 1,
    RawFlashText "Värisuunnittelu $ jypa       " 5 (0.0:.(-0.38):.()) $ ctimes 53   5 1,
    RawFlashText "Pikselit ja pensselit: Haskell & GPipe" 5 (0:.(-0.8):.()) $ ctimes 53.5 5 1                
  ]


outrot = [
    RawFlashText "Instanssi 2011 Voionmaan lukiolla " 8 ((-0.2):.(-0.5):.())  $ ctimes 67 7.33 1,
    RawFlashText "Jyväskylän keskustassa            " 6 ((-0.2):.(-0.6):.()) $ ctimes 67 7.5 1,

    RawFlashImage "instanssi_logo.png"            1.1 ((-0.4):.(0.30):.())  $ FlashTimes 65 68 100 100,
    RawFlashText "facebook.com/instanssi          " 6 ((-0.4):.(-0.10):.()) $ ctimes 68    5   1,
    RawFlashText " twitter.com/instanssi          " 6 ((-0.4):.(-0.18):.())  $ ctimes 68.33 5   1,
    RawFlashText "            #instanssi / IRCNet " 6 ((-0.4):.(-0.34):.())  $ ctimes 69    5   1,
    RawFlashText "             instanssi.org      " 6 ((-0.4):.(-0.26):.()) $ ctimes 68.66 5   1
  ]

x8 = 0.3

ctimes alku kesto fadet = FlashTimes (alku-fadet) alku (alku+kesto) (alku+kesto+fadet)

--49.2-64.0
--epixit kuoroin
--64.0-67.5
--loppufeidaus
--67.5-71.0
--patarumputumppum
--71.0->
--tyhjää

rawTextEvents = concat [introt, instanssihq, sisaltoa, hotlambdalovin, outrot]

