-----------------------------------------------------------------------------
--
-- Module:      SimpleScene
-- Author:      Hot Lambda Lovin' (2011)
--
-- Description: Draws simple scenes, text.
--
-----------------------------------------------------------------------------

module SimpleScene (drawSceneItem) where

import Graphics.GPipe
import Data.Vec hiding (map, sum, foldl)
import Data.Vec.LinAlg.Transform3D
import Env
import Types
import qualified Util as U
import qualified DisplayUtils as DU

-- FIME: Copy-paste monster. text / image scenes are just textures with same metainfos.
drawSceneItem :: Taulu -> U.SceneItem -> Time -> Taulu
drawSceneItem bg (U.FlashText texture scale dim position times) millis
  | secs < (U.begin times) || secs > (U.end times)     = bg
  | otherwise                                          = paint rendering bg
  where
    secs      = millis/1000
    size      = textSize dim scale
    paint     = DU.blend
    rendering = DU.screenText texture (vec 1) alpha position size
    alpha = intensity times secs
drawSceneItem bg (U.FlashImage texture scale dim position times) millis
  | secs < (U.begin times) || secs > (U.end times) = bg
  | otherwise                                      = paint rendering bg
  where
    secs      = millis/1000
    size      = calcMarqueeSize dim scale
    paint     = DU.blend
    rendering = DU.screenTexture texture alpha position size
    alpha = intensity times secs

intensity times time 
  | time < (U.stable times)  = (time-(U.begin times))/((U.stable times)-(U.begin times))
  | time < (U.fadeout times) = 1.0
  | otherwise                = 1.0-(time-(U.fadeout times))/((U.end times)-(U.fadeout times))

-- FIXME: rename: nothing marquee spesific here anymore
calcMarqueeSize :: Vec2 Int -> Float -> Vec2 Float
calcMarqueeSize (w:.h:.()) scaling = (width:.height:.())
  where
    width  = scaling
    height = 1.3 * ((fromIntegral h)/(fromIntegral w)) * scaling

textSize :: Vec2 Int -> Float -> Vec2 Float
textSize (w:.h:.()) scale = (w':.h':.()) * vec (((scale / (fromIntegral (round (scale * 7))))) / 100)
    where w' = 0.7 * fromIntegral w
          h' = fromIntegral h
