module MetaCircleScene (showSomeHaskell, showSomeBalls) where

import Graphics.GPipe
import Data.Vec hiding (map, sum, foldl)
import Data.Vec.LinAlg.Transform3D()
import Util
import Types
import qualified DisplayUtils as DU

showSomeHaskell :: SceneValues -> Maisema
showSomeHaskell vals (vahvuus,_,_) = DU.texturePleaseF (haskellTexture vals) (vahvuus * 0.5)

showSomeBalls :: Vec3 Float -> Maisema
showSomeBalls bg (vahvuus, aika, _) = fmap (pipe) DU.uvPlane
    where showMeLess x = RGBA bg' (toGPU vahvuus * (1-x))
          pipe = showMeLess . ballsyAlpha (toGPU aika * 800)
          bg'  = toGPU bg

ballsyAlpha :: Fragment Float -> (Vec2 (Fragment Float)) -> Fragment Float
ballsyAlpha time uv = smoothstep 0.85 0.9 (sin $ str * 15)
    where str = metacircles (uv * 2 - 1) (fooPoints (time/800))

drawBalls :: Fragment Float -> (Vec2 (Fragment Float)) -> Color RGBAFormat (Fragment Float)
drawBalls time uv = RGBA (vec c) 1.0
    where c = ballsyAlpha time uv

fooPoints :: Fragment Float -> [Vec2 (Fragment Float)]
fooPoints time = map animate points
    where points = [(0.9:.0.23:.()), (0.2:.0.4:.()), (0.5:.0.7:.()), (0.3:.0.45:.()), ((-0.8):.(-0.9):.()), ((0.1):.(0.9):.())]
          animate (x0:.y0:.()) = ((sin$time*x0):.(cos$time*y0):.()) * (x0:.y0:.())

field :: (Floating a, Ord a, Num a) => Vec2 a -> Vec2 a -> a
field point blob = 0.18 * cos' d
    where d = min 3.14 (norm $ (blob - point) * vec 7)
          cos' x = (cos x) * 0.5 + 0.5

metacircles :: (Floating a, Ord a, Num a) => Vec2 a -> [Vec2 a] -> a
metacircles point blobs = sum $ map (field point) blobs
