module MatrixScene (matrixEffect) where

import Graphics.GPipe
import Data.Vec hiding (map, sum, foldl)
import Data.Vec.LinAlg.Transform3D
import Data.Monoid
import qualified DisplayUtils as DU
import MathUtil
import Types


matrixEffect :: Texture2D RGBAFormat -> Maisema    
matrixEffect tex (vahvuus,_,time) = pipe DU.uvPlane
    where pipe = fmap (\x -> RGBA (1:.0:.0.7:.()) (x * alpha)) . fmap (matrix time' tex) 
          time' = toGPU $ time * 3
          alpha = toGPU vahvuus

matrix :: Fragment Float -> Texture2D RGBAFormat -> Vec2 (Fragment Float) -> Fragment Float    
matrix time tex (u:.v:.()) = a * sum [ stripe time (u:.v:.()) (noise (x * 2) * 4 + 1) x | x <- input ]
    where input = map ((/ 36) . fromIntegral) [1..36]
          RGBA _ a = sample (Sampler Linear Wrap) tex ((u*8):.(v*10):.())

          

stripe time (u:.v:.()) start pos = hcheck
    where l = 0.25
          w = 0.0125
          window = sawW (time-start-l) (time-start) (v')
          v' = (floor' $ v * 40) / 40
          hcheck = ifB ((u <* pos) &&* ((u + w) >* pos)) window 0

noise value = 0.1 * sum [ sin $ value * x**1.7 + value * x / 0.7 | x <- input ]
    where input = map (fromIntegral) [0..10]
