module LayerEffects (addShadow) where

import Graphics.GPipe
import Data.Vec as Vec hiding (sum, foldl)
import Data.Vec.LinAlg.Transform3D
import Data.Monoid
import qualified DisplayUtils as DU
import MathUtil
import Types

-- WARNING Resizing the window while applying any of the layereffects might end the world

addShadow :: Vec2 Int -> Kuva -> Kuva
addShadow koko kuva = mappend (fmap (blur small) DU.uvPlane) (DU.texturePlease orig 1) 
    where 
        orig = toTexture koko kuva
        ((w:.h:.()), small) = (downSampleN 4 (koko, orig))
        blur t (u:.v:.()) = RGBA (0:.0:.0:.()) (a)
            where
                dx = 1 / fromIntegral w
                dy = 1 / fromIntegral h
                (r:.g:.b:.a:.()) = sampleOffsets t [u,u+dx,u-dx] [v,v+dy,v-dy]

toTexture s fb = fromFrameBufferColor RGBA8 s (DU.blend fb DU.tyhjyys) :: Texture2D RGBAFormat
sample' tex uv = (\(RGBA (r:.g:.b:.()) a)  -> (r:.g:.b:.a:.())) (sample (Sampler Linear Wrap) tex uv)

sampleOffsets :: Texture2D RGBAFormat -> [Fragment Float] -> [Fragment Float] -> Vec4 (Fragment Float)
sampleOffsets tex uu vv = ((/ n) . sum) [ sample' tex (u:.v:.()) | u <- uu, v <- vv ]
    where n = fromIntegral $ Prelude.length uu * Prelude.length vv

downSampleN :: Int -> (Vec2 Int, Texture2D RGBAFormat) -> (Vec2 Int, Texture2D RGBAFormat)
downSampleN n stuff = Prelude.last $ Prelude.take n $ iterate (downSample) stuff

downSample :: (Vec2 Int, Texture2D RGBAFormat) -> (Vec2 Int, Texture2D RGBAFormat)
downSample ((w:.h:.()), tex) = (wh', toTexture wh' out)
    where
        foo = round . (/ (2::Float)) . fromIntegral
        wh' = ((foo w):.(foo h):.())
        (dx:.dy:.()) = Vec.map ((/ 1) . fromIntegral) (w:.h:.()) :: Vec2 (Fragment Float)
        out = fmap (colorize . collect) DU.uvPlane
        colorize (r:.g:.b:.a:.()) = RGBA (r:.g:.b:.()) a
        collect (u:.v:.()) = sampleOffsets tex [u',u'+dx] [v',v'+dy]
            where 
               u' = u - (dx / 2)
               v' = v - (dy / 2)
