module HypnoScene (hypnoShutter, dimRim, fadingWalls, ringEffect, überHypnoChaosEffect, singleSpiral) where

import Graphics.GPipe
import Data.Vec hiding (map, sum, foldl)
import Data.Vec.LinAlg.Transform3D
import Data.Monoid
import qualified DisplayUtils as DU
import MathUtil
import Types

addPolar input = fmap (foo) input
    where foo uv = (uv, polar (uv * 2.0 - 1.0))

hypnoShutter :: Maisema    
hypnoShutter olotila = pipe DU.uvPlane
    where pipe = (tresholdColor 0.4 0.5 $ vec 0). (shutter' olotila) . addPolar

shutter' (_, _, time) input = fmap ((foo . toGPU) time) input
    where foo t (uv,ra) = spiralShutter t (ra)

tresholdColor low high c input = fmap (foo) input
    where foo x = RGBA (toGPU c) (smoothstep low high x)

spiralShutter :: Fragment Float -> Vec2 (Fragment Float) -> Fragment Float        
spiralShutter time (r:.a:.()) = mix 0 c (smoothstep 0.3 0.8 r)
    where
        firstSpirals = map (\x -> (x, spiral (2 ** (x-1)) (5 * x) (r:.(a+t):.()))) [fromIntegral x | x <- [1..6]]
        lastSpiral = softW 1 5 9 t * spiral 32 (-25) (r:.(a+t):.())
        c = (sum . map (\(t', f) -> softW 0.2 (t'-1) (t'+1) t * f)) firstSpirals + lastSpiral
        t = time * 9 

dimRim :: (Fragment Float -> Fragment Float) -> Maisema
dimRim f (vahvuus,_,_) = pipe DU.uvPlane
    where pipe = fmap dim . addPolar
          dim (_, (r:.a:.())) = RGBA (vec 0) (f $ (r * 0.7) - (1 - (toGPU vahvuus)))

fadingWalls :: Vec3 Float -> Maisema
fadingWalls (rgb) olotila = pipe DU.uvPlane
    where pipe = fmap (colorize olotila) . fmap (sweep olotila) 
          colorize (vahvuus,_,_) x = RGBA (toGPU rgb) (x * toGPU vahvuus) 
          sweep (_,_,time) (u:.v:.()) = antialias
            where x = mod' 1.2 (u+(v*t*0.02))
                  t = toGPU time
                  limit = (1 - u) * 0.02
                  antialias = ifB (x <* limit) (mix limit u $ 1 - (smoothstep 0 limit x)) x


ringEffect :: Vec2 Float -> Vec3 Float -> Maisema
ringEffect pos color (_,_,time) = pipe DU.uvPlane
    where pipe = fmap (RGBA $ toGPU color) . fmap (rings $ toGPU time) . addPolar . fmap (moveUV $ toGPU pos)
          moveUV pos uv = uv - pos

rings time ((u:.v:.()), (rad:.ang:.())) =  window
    where window = (1.4 - rad) * sawW t' (t'+0.2) (rad ** 0.5)
          t' = time * 1.2 


überHypnoChaosEffect :: Maisema
überHypnoChaosEffect (alpha,_,time) = pipe DU.uvPlane
    where pipe = (tresholdColor 0.0 0.2 $ 0.1:.0.0:.0.07:.()) . fmap (überHypno time') . addPolar . fmap (distortUV time')
          time' = toGPU $ time * 21

distortUV  :: Fragment Float -> Vec2 (Fragment Float) -> Vec2 (Fragment Float)          
distortUV time (u:.v:.()) = (u:.v:.()) + d1
    where d1 = ((sin $ u * 10):.(sin $ v * 7):.()) * (vec $ softEW 0.2 0.5 13 14 time)

überHypno :: Fragment Float -> (Vec2 (Fragment Float), Vec2 (Fragment Float)) -> Fragment Float
überHypno t ((u:.v:.()), (rad:.ang:.())) = sum effects
    where 
        effects = [ (softEW 0.6 2 (fromIntegral x) (fromIntegral x+1) t) * f | (x,f) <- zip [2..] funcs ]
        funcs = [f1,f2,f3,f4,f5,f6,f7,f8,f9,f10,f11,f12,f13,f14,f15,f16,f17]
        f1 = spiral 10 10 (rad:.(v+t):.())
        f2 = spiral 17 (-12) (rad:.(v+t+rad):.())
        f3 = spiral 10 10 (ang:.(v-t):.())
        f4 = spiral 15 30 (rad:.(ang+t):.())
        f5 = spiral 15 (-50) (rad:.(ang-t):.())
        f6 = sin ((rad * 10) / (sin $ (ang + t) * 5))
        f7 = sin $ 10 * (u+v+t) 
        f8 = sin $ 10 * (u*v+t)
        f9 = spiral 2 20 (rad:.(ang+t):.())
        f10 = spiral 3 (-19) ((rad*u+t):.(ang-t*v):.())
        f11 = spiral 10 10 (u:.(v+t*2):.())                                          
        f12 = spiral 4 3 ((ang+t):.(v*(ang+t)):.())
        f13 = sin ((rad - t) * 5)
        f14 = spiral 40 10 (ang:.(rad+t):.()) 
        f15 = spiral 3 (-20) (ang:.(rad+t):.())
        f16 = spiral 30 8 (ang:.(rad+t):.())
        f17 = spiral 20 5 (ang:.(rad+t):.())

singleSpiral :: Maisema
singleSpiral (_,_,time) = pipe DU.uvPlane
    where pipe = fmap (RGBA $ toGPU (0.6:.0.2:.0.1:.())) . fmap (effect $ toGPU time) . addPolar
          effect time (_, (rad:.ang:.())) = smoothstep 0.2 0.5 $ (rectW (time-0.4) (time) (rad*0.2)) * spiral 3 (-20) (ang:.(rad+time):.())
        

