module Env where

import Graphics.UI.GLUT (elapsedTime)
import Graphics.GPipe
import Data.IORef
import Data.StateVar

type Time = Float
type Frame = Int
type Env = IORef (Time, Time, Frame)

initEnv :: IO Env
initEnv = newIORef (0, 0, 0)

updateEnv :: Env -> IO ()
updateEnv env = do
    values <- readIORef env
    ms <- (get elapsedTime) -- Using GLUT elapsedTime to figure millisecond count.
    writeIORef env $ (\(time, offset, frame) -> (fromIntegral ms, offset, frame + 1)) values

seek :: Time -> Env -> IO ()
seek offset' env = do
    values <- readIORef env
    writeIORef env $ (\(time, offset, frame) -> (time, offset+offset',frame)) values

time :: (Time, Time, Frame) -> Time
time (time', offset, frame) = time' + offset


