module CubeScene2 (genLonkero) where

import Graphics.GPipe
import qualified Data.Vec as Vec
import Data.Vec (Mat33, Mat44, vec, n3, transpose, invert)
import Data.Vec.LinAlg.Transform3D
import Data.Monoid
import qualified DisplayUtils as DU
import MathUtil
import Types
import Data.Maybe

genLonkero :: Geometry -> Maisema
genLonkero cube (_,time,_) = maisema
    where
        df a b x = (a*(blockcos 0.4 $ time' - x), (b-a)*0.1, b*(blockcos 0.1 $ time' - x))
        distortFuncs = [df 0.07 0.15, df (-0.05) 0.2, df 0.05 (-0.12), df 0.1 (-0.22)]
        tentacles = concat [ lonkeroMat 10 a f  | (a,f) <- zip [0,pi/2..pi*2] distortFuncs ]
            ++ [(0, identity :: Mat44 Float)]

        maisema = (fmap colorCube . DU.toFrags) (joined)
        joined = mconcat $ map (kuutio') tentacles
        kuutio' (d,model) = (DU.transformPlease (proj, view, addFancyness d model) . rewriteUV (d:.0:.())) cube

        addFancyness d model = model `multmm` movein d
        movein d = translation $ (0:.0:.(300):.()) * (vec $ softEW 0.3 2 (-1) 0 (time' - d*2))

        proj = perspective 0.1 100 (pi / 3) 1.3
        view = moveright `multmm` translation (0:.0:.(-50):.()) `multmm` tiltup `multmm` rotationY time' `multmm` dampenRot
        moveright = translation $ (12:.(-2):.0:.()) * (vec moveW)
        tiltup = (rotationX $ 0.6 * moveW) `multmm` (rotationZ $ 0.4 * moveW)
        dampenRot = rotationY $ ((-time') * 0.7) * moveW                                                        
        moveW = softEW 0.2 3 10 100 time'
        time' = time + ((23 - time) * (triEW 3 23 100 time))

colorCube (model, world, n, (d:._:.())) = RGBA (vec (color)) 1
    where color = (diffuse * 0.05 * light) + midLight + sideLight - shadow - midCube
          midCube = ifB (d <* 0.05) (diffuse - 2) 0
          light = max 0 $ n `dot` (normalize $ 0:.1:.1:.())
          diffuse = norm model
          midRatio = n `dot` (normalize (-world))
          midLight = (1 - d) * max 0 midRatio
          sideLight = ifB (((abs midRatio) <* 0.7) &&* (d >* 0.05)) ((smoothstep 0 1 (1 - Vec.maximum (abs world) / 12)) ** 2) 0
          shadow = ifB ((midRatio >* 0.7) &&* (d >* 0.15)) (((abs $ diffuse - 1.7) ** (d+0.3)) * max 0 ((0.7-d)*2)) 0


rewriteUV :: Vec2 Float -> Geometry -> Geometry
rewriteUV uv geom = fmap (rewrite) geom
    where rewrite (v,n,_) = (v,n,toGPU uv)

lonkeroMat :: Int -> Float -> (Float -> (Float, Float, Float)) -> [(Float, Mat44 Float)]    
lonkeroMat num dir distortf = map (\(d,m) -> (d,centerPivot m)) $ tail $ Prelude.take num $ matrices   
    where
        offset = (0:.0:.3:.())
        initialMat = rotationY dir `multmm` translation (offset / 2)
        centerPivot m = m `multmm` translation (offset / (-2))
        matrices = iterate step (0, initialMat)
        step (pos, prev) = (pos + 0.1, prev `multmm` distortM (distortf pos) `multmm` translation offset)


distortM :: (Float, Float, Float) -> Mat44 Float    
distortM (a, b, c) = foldl1 f matrices
    where f acc m = m `multmm` acc
          matrices = [rotationY a, rotationZ b, rotationX c]



