module CubeScene (cubeFrame2) where

import Graphics.GPipe
import qualified Data.Vec as Vec
import Data.Vec.LinAlg.Transform3D
import Data.Vec.Nat
import Data.IORef
import Data.Monoid
import Graphics.UI.GLUT (Window, mainLoop, postRedisplay, idleCallback, getArgsAndInitialize, ($=))
import System.Random    
import Env
import Types
import MathUtil
import qualified Data.Vec as Vec
import Data.Vec (vec)
import qualified DisplayUtils as DU

cubeFrame2 :: Geometry -> Maisema
cubeFrame2 geom (_,t,_) = showSomeCube geom t


enlight (_, _, norm, uv) = RGBA (0.7:.0.0:.0.86:.() * vec dim) a
     where uv' = uv * 2 - 1
           d = Vec.maximum $ abs uv'
           a = step 0.9 d
           dim = 1 - (a - (smoothstep 0.95 0.9 d))


showSomeCube :: Geometry -> Aika -> Kuva
showSomeCube cube time = (fmap (enlight) . DU.toFrags . DU.transformPlease tr . spherify sphereness) cube
    where tr = (proj, view, model)
          proj = perspective 1 100 (pi/3) 1
          view = translation (0.5:.0.1:.(-2):.())
          model = movein `multmm` moveout `multmm` initialAngle `multmm` merryGoRound `multmm` scaling (vec 0.25)
          merryGoRound = rotationVec (normalize ((sin (angle*1.2)):.(cos (angle*0.8)):.(tan angle):.())) angle
          initialAngle = rotationVec (normalize (1.0:.0.7:.0.0:.())) 1.0
          angle = time
          sphereness = sum [ s * (softEW 0.2 1 t (t+4) time) | (s,t) <- [(1, 9), (-1, 14), (6, 19)] ]
          movein = translation $ (5:.0:.0:.()) * (vec $ softEW 0.1 2 (-5) (-1) time)                        
          moveout = translation $ (5:.0:.0:.()) * (vec $ softEW 0.1 5 31 40 time)                                                               
                                                                                                        
-- Moves vertices to the surface of a unit sphere with ratio of 1, does nothing with 0
-- Interesting effects with valus outside and between 0 and 1
spherify :: Float -> Geometry -> Geometry
spherify ratio geom = fmap (cubify) geom
    where 
        ratio' = toGPU ratio
        cubify (v, n, uv) = (cartesian $ (mix r 1 ratio'):.i:.a:.(), n', uv)
            where
                (r:.i:.a:.()) = spherical v                                                                
                n' = lerp n (normalize $ cartesian $ r:.i:.a:.()) (Vec.vec ratio')
