package Ragedemo01;
import processing.core.PApplet;


/**
 * A class for drawing some grass to the bottom of the parent programs screen.
 * 
 * 
 * TODO for next versions
 * ----------------------
 *   - no hard-coded screen size (1280 x 720)
 * 
 * 
 * @version 002
 * @author RageManifesto
 *
 */
public class RageGrass extends PApplet{

	PApplet parent;
	Blade[] items;
	private int amountOfBlades;
	
	
	private class Blade{
		
		PApplet parent;
		float x = 500;
		float y = 720;
		float angle1 = 0.0f;
		float angle2 = 0.0f;
		float segLength = 2f;
		float anglemodifier = 0.0f;
		float anglemodifierInput = 0.0f;
		float anglemodifierChangeAmount = 0.0f;
		float baseBendingAmount = 0.0f;
		float bendingAmount = 0.0f;
		int segments;
		int segmentColors[][];
		int[] initialColor;
		float strokeWeight = 8.0f;
		private final int colorShiftAmount = 5;

		
		public Blade(PApplet p){
			
			this.parent = p;
			this.segments = (int)parent.random(8f, 30f);
			this.baseBendingAmount = 0.03f;
			this.bendingAmount = 0.002f;
			this.x = parent.random(0f, 1280f);
			this.anglemodifierInput = parent.random(-1f, 1f);
			this.anglemodifierChangeAmount = parent.random(0.01f, 0.06f);
			this.strokeWeight = (float) this.segments/4;
			
			this.segLength = parent.random(3f, 6f);
			
			this.initialColor = new int[]{(int)parent.random(0f, 50f), (int)parent.random(70f, 130f), (int)parent.random(0f, 50f) };
            this.segmentColors = new int[this.segments+1][3];
            
            this.segmentColors[0] = this.initialColor;
            
            for ( int l = 1; l <= this.segments; l++ ) {
            	
            	this.segmentColors[l] = giveNextColor(this.segmentColors[l-1]);
            }	
		}
		

		private int[] giveNextColor(int[] thisColor) {
			int[] newColor = new int[3];
			int a;
			for ( int k = 0; k < thisColor.length; k++ ) {
				
				a = thisColor[k];		
				a += colorShiftAmount;
				if ( a > 255 ) a = 255;
				newColor[k] = a;
			}
			return newColor;
		}
		
		
		public void draw(){
			
	        this.anglemodifierInput += this.anglemodifierChangeAmount;
			anglemodifier = (float) Math.sin(this.anglemodifierInput);
			  
			angle1 = ((((this.baseBendingAmount * anglemodifier) + parent.HALF_PI ) * parent.PI) - 0.3f);
			angle2 = (this.bendingAmount * angle1 + anglemodifier* ( this.bendingAmount * 10 ) - this.bendingAmount*4);
			
			parent.pushMatrix();
			segment(x, y, angle1, 0); 
			
			for ( int k = 1; k <= this.segments; k++ ) {
			
			    segment(segLength, 0, angle2, k);
			}
			
			parent.popMatrix();
			
		}
		
		
		private void segment(float x, float y, float a, int index) {
			  parent.translate(x, y);
			  
			  parent.rotate(a);
			  parent.strokeWeight(this.strokeWeight);
			  parent.stroke(this.segmentColors[index][0], this.segmentColors[index][1], this.segmentColors[index][2], 255);
			  parent.line(-5, 0, segLength, 0);
			}
	}
	
	/**
	 * Initializes the effect
	 * 
	 * @param p reference to the parent program
	 * @param amount amount of grass blades
	 */
	public RageGrass(PApplet p, int amount){
		this.parent = p;
		
		this.amountOfBlades = amount;
		
		this.items = new Blade[amountOfBlades];
		
		for ( int j = 0; j < amountOfBlades; j++ ) {
			items[j] = new Blade(this.parent);
		}
		
	}


	@Override
	public void draw() {
		
		for ( int i = 0; i < items.length; i++ ) {
			
			this.items[i].draw();
		}	
	}	
}
