package Ragedemo01;

import processing.core.PApplet;


/**
 * Draws some cheap-looking stuff on the screen. Almost a direct & rushed copy of the RageClouds class.
 * Hardcoded for 1280x720
 * 
 * 
 * @version 001
 * @author Rage Manifesto
 *
 */
public class RageCheapStuff extends PApplet {

	private PApplet parent;
	private float posX;
	private float posY;
	private float speed;
	private float pieceSize;
	private int pieceAmount;
	private int[] coord_x;
	private int[] coord_y;
	private float[] pieceSizeInputModifier;
	private int[][] colors;
	
	
	RageCheapStuff(PApplet p, float initialPos_x, float initialPos_y, float speed, float pieceSize, int cloudPieces) {
		
		this.parent = p;
		this.posX = initialPos_x;
		this.posY = initialPos_y;
		this.speed = speed;
		this.pieceSize = pieceSize;
		this.pieceAmount = cloudPieces;
		
		this.coord_x = new int[cloudPieces];
		this.coord_y = new int[cloudPieces];
		this.pieceSizeInputModifier = new float[cloudPieces];
			
		for ( int i = 0; i < cloudPieces; i++ ) {
			this.coord_x[i] = (int)(parent.random(0f, 900f));
			this.coord_y[i] = (int)(parent.random(-420f, 420f));
			this.pieceSizeInputModifier[i] = parent.random(-30f, 30f);
			
		}
		
		this.colors = new int[cloudPieces][3];
		
		for ( int i=0; i < cloudPieces; i++ ) {
			
			this.colors[i][0] = (int)parent.random(120f, 255f);
			this.colors[i][1] = (int)parent.random(120f, 255f);
			this.colors[i][2] = (int)parent.random(120f, 255f);
		}
	}
	
	
	public void draw() {
		
		posX += speed;
		if (posX < -200 ) posX = 1480;
		float psiz;
		
		//parent.fill(225, 225, 225);
		parent.noStroke();
		
		parent.ellipse(posX, posY, pieceSize, pieceSize);
		for ( int i = 0; i < pieceAmount; i++ ) {
			pieceSizeInputModifier[i] += 0.015f;
			psiz = (float) (pieceSize + Math.sin(pieceSizeInputModifier[i])*100);
			parent.fill(colors[i][0], colors[i][1], colors[i][2], 100);
			parent.ellipse(posX + coord_x[i], posY + coord_y[i], psiz, psiz);
		}	
	}
}
