/*
 * Decompiled with CFR 0.152.
 */
package Ragedemo01;

import processing.core.PApplet;

public class RageFlowers {
    private PApplet parent;
    private float strokeWeight;
    private float baseLineLength1;
    private float angle1 = 0.0f;
    private float angle2 = 0.0f;
    private float angleModificationInput = 0.0f;
    private float strokeAlpha;
    private int baseLocation_x;
    private int baseLocation_y;
    private int numberOfArms;
    private int numberOfPiecesPerArm;
    private float morphingSpeed;
    private float sizeChangeAmount;
    private float rotation;
    private float rotator;
    private float rot = 0.0f;
    private int[] baseColor;
    private int[][] colors;
    private float baseDistance;
    private int movement_x;
    private int movement_y;
    private int loc_x;
    private int loc_y;
    private float initialMorphState;
    private int maxSize;
    private float baseLineLengthModifier;
    private final float pi = 3.14159f;
    private final float pi2 = 6.2832f;
    private final int colorShiftAmount = 20;

    public RageFlowers(PApplet p, int x, int y, int x_speed, int y_speed, float distance, float rotation, int numberOfArms, int numberOfPiecesPerArm, float morphingSpeed, float sizeModifier, float sizeChangeModifier, int alpha, int strokeWeight, int maxSize) {
        this.parent = p;
        this.rotation = rotation;
        this.strokeWeight = strokeWeight;
        this.baseLineLength1 = sizeModifier;
        this.baseLocation_x = x / 2;
        this.baseLocation_y = y / 2;
        this.loc_x = x / 2;
        this.loc_y = y / 2;
        this.movement_x = x_speed;
        this.movement_y = y_speed;
        this.numberOfArms = numberOfArms;
        this.numberOfPiecesPerArm = numberOfPiecesPerArm;
        this.morphingSpeed = 1.0f;
        this.strokeAlpha = alpha;
        this.sizeChangeAmount = sizeChangeModifier;
        this.baseDistance = distance;
        this.maxSize = maxSize;
        this.baseColor = new int[]{(int)this.parent.random(0.0f, 255.0f), (int)this.parent.random(0.0f, 255.0f), (int)this.parent.random(0.0f, 255.0f)};
        this.colors = new int[numberOfPiecesPerArm + 1][3];
        this.colors[0] = this.baseColor;
        int i = 1;
        while (i < numberOfPiecesPerArm) {
            this.colors[i] = this.giveNextColor(this.colors[i - 1]);
            ++i;
        }
        this.initialMorphState = 0.0f;
    }

    private int[] giveNextColor(int[] thisColor) {
        int[] newColor = new int[3];
        int k = 0;
        while (k < thisColor.length) {
            int a = thisColor[k];
            if ((a += (int)this.parent.random(0.0f, 20.0f)) > 255) {
                a = (int)this.parent.random(0.0f, 255.0f);
            }
            newColor[k] = a;
            ++k;
        }
        return newColor;
    }

    public void printColors() {
        int i = 0;
        while (i < this.colors.length) {
            int j = 0;
            while (j < this.colors[i].length) {
                ++j;
            }
            ++i;
        }
    }

    public void update() {
    }

    public void draw() {
        this.rot += this.rotation;
        this.rotator = (float)Math.sin(this.rot);
        this.loc_x += this.movement_x;
        this.loc_y += this.movement_y;
        if (this.loc_y > 1100) {
            this.loc_y = this.baseLocation_y - 150;
            this.loc_x = this.baseLocation_x;
        }
        if (this.loc_x > 1600) {
            this.loc_y = this.baseLocation_y - 150;
            this.loc_x = this.baseLocation_x;
            this.movement_x = -this.movement_x;
        }
        if (this.loc_x < -550) {
            this.loc_y = this.baseLocation_y - 150;
            this.loc_x = this.baseLocation_x;
            this.movement_x = -this.movement_x;
        }
        this.angleModificationInput += 0.005f;
        this.angle1 = this.initialMorphState + this.angleModificationInput * 0.5f * 3.14159f;
        this.angle2 = this.initialMorphState + this.angleModificationInput * 6.2832f;
        this.baseLineLengthModifier = (this.angle1 % 6.2832f - 3.14159f) * -10.0f;
        this.baseLineLength1 = this.baseLineLengthModifier > 0.0f ? (this.baseLineLength1 += this.sizeChangeAmount * (this.baseLineLengthModifier * 0.1f)) : (this.baseLineLength1 -= this.sizeChangeAmount * (this.baseLineLengthModifier * -0.1f));
        float j = 1.0f;
        while (j <= (float)this.numberOfArms) {
            this.parent.pushMatrix();
            this.parent.translate((float)this.baseLocation_x, (float)this.baseLocation_y, this.baseDistance);
            this.draw1stLine(this.loc_x, this.loc_y, this.angle2 + 6.28318f * (j / (float)this.numberOfArms), (int)j - 1);
            int i = 0;
            while (i < this.numberOfPiecesPerArm) {
                this.parent.translate(0.0f, 0.0f, (this.baseDistance + (float)i * 10.0f) * 0.01f);
                this.drawLine(this.baseLineLength1, 0.0f, this.angle1 * this.morphingSpeed, i);
                ++i;
            }
            this.parent.popMatrix();
            j += 1.0f;
        }
    }

    private void draw1stLine(float x, float y, float a, int index) {
        this.parent.translate(x, y);
        this.parent.rotate(a + this.rotator);
        this.parent.stroke((float)this.colors[0][0], (float)this.colors[0][1], (float)this.colors[0][2], this.strokeAlpha);
        this.parent.strokeWeight(this.strokeWeight);
        this.parent.line(0.0f, 0.0f, this.baseLineLength1, 0.0f);
    }

    private void drawLine(float x, float y, float a, int index) {
        this.parent.translate(x, y);
        this.parent.rotate(a);
        this.parent.stroke((float)this.colors[index][0], (float)this.colors[index][1], (float)this.colors[index][2], this.strokeAlpha);
        this.parent.strokeWeight(this.strokeWeight);
        this.parent.line(0.0f, 0.0f, this.baseLineLength1, 0.0f);
    }
}

