/*
 * Decompiled with CFR 0.152.
 */
package intro;

import intro.Effu;
import intro.Metaballs;
import intro.Particle;
import java.util.ArrayList;
import java.util.Random;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;

public class ParticleSystem
extends Effu {
    ArrayList<Particle> particles;
    Metaballs mBalls;
    Random r;
    PGraphics pg;
    PGraphics bg;
    int particleJitter = 5;
    int cubeShaker = 60;
    int cubeJitter = 2;
    float ry = 0.0f;
    float rx = 0.0f;
    float rz = 0.0f;
    float rdy = 0.02f;
    float rdx = 0.06f;
    float rdz = 0.008f;
    float fac = -0.04f;
    int parCap = 15000;
    int parSum = 0;
    int parIter = 1;
    int start;
    int bgc = this.start = 25;
    int fillc = this.start;
    int strokec = this.start;
    int strokebc = this.start;

    ParticleSystem(PApplet parent) {
        super(parent);
        this.r = new Random(1L);
        this.pg = this.p.createGraphics(this.p.width, this.p.height, "processing.core.PGraphics3D");
        this.particles = new ArrayList();
        this.bg = this.p.createGraphics(this.p.width, this.p.height, "processing.core.PGraphics3D");
        this.mBalls = new Metaballs(this.p);
    }

    @Override
    public void draw(float demotime, boolean beat) {
        this.update();
        if (demotime > 41500.0f) {
            this.drawMetaballs(demotime, beat);
        }
        if (demotime > 105000.0f) {
            this.drawCube(beat);
        }
        int minus = 0;
        this.pg.beginDraw();
        this.pg.background(0);
        for (Particle particle : this.particles) {
            int x = (int)((float)particle.x + particle.xp);
            int y = (int)((float)particle.y + particle.yp);
            try {
                minus = this.bg.pixels[this.bg.width * y + x];
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.pg.strokeWeight(particle.size);
            this.pg.stroke((float)(particle.r + particle.rp) - this.p.red(minus), (float)(particle.g + particle.gp) - this.p.green(minus), (float)(particle.b + particle.bp) - this.p.blue(minus));
            this.pg.point((float)x, (float)y);
        }
        this.pg.endDraw();
        this.p.image((PImage)this.pg, 0.0f, 0.0f, (float)this.p.width, (float)this.p.height);
    }

    private void update() {
        this.addParticles();
        float add = 1.15E-4f;
        if (this.fac + add < -4.0E-4f) {
            this.fac += add;
        }
        for (Particle particle : this.particles) {
            particle.x += (int)(particle.dx * (float)particle.speed);
            particle.y += (int)(particle.dy * (float)particle.speed);
            if (particle.x < 0 || particle.x > this.p.width) {
                particle.dx *= -1.0f;
            }
            if (particle.y < 0 || particle.y > this.p.height) {
                particle.dy *= -1.0f;
            }
            double distance = Math.pow(Math.sqrt(Math.pow(particle.x - this.p.width / 2, 2.0) + Math.pow(particle.y - this.p.height / 2, 2.0)), 2.0) * (double)this.fac;
            particle.rp = (int)distance;
            particle.gp = (int)distance;
            particle.bp = (int)distance;
            particle.xp = this.r.nextInt(this.particleJitter);
            particle.yp = this.r.nextInt(this.particleJitter);
        }
    }

    private void addParticles() {
        if (this.parSum < this.parCap) {
            this.parSum += this.parIter++;
            int i = 0;
            while (i < this.parIter) {
                Particle particle = new Particle();
                particle.x = this.r.nextInt(this.p.width);
                particle.y = this.r.nextInt(this.p.height);
                particle.dx = this.r.nextFloat();
                if (this.r.nextBoolean()) {
                    particle.dx *= -1.0f;
                }
                particle.dy = this.r.nextFloat();
                if (this.r.nextBoolean()) {
                    particle.dy *= -1.0f;
                }
                particle.yp = 0.0f;
                particle.xp = 0.0f;
                particle.r = (int)(this.r.nextFloat() * 26.0f + 62.0f);
                particle.g = (int)(this.r.nextFloat() * 26.0f + 81.0f);
                particle.b = (int)(this.r.nextFloat() * 26.0f + 140.0f);
                particle.bp = 0;
                particle.gp = 0;
                particle.rp = 0;
                particle.size = this.r.nextFloat() * 20.0f;
                particle.speed = 5;
                this.particles.add(particle);
                ++i;
            }
        }
    }

    private void drawCube(boolean beat) {
        this.bg.beginDraw();
        this.bg.ambientLight(255.0f, 255.0f, 255.0f);
        this.bg.lightFalloff(1.0f, 0.0f, 0.0f);
        this.bg.directionalLight(150.0f, 150.0f, 150.0f, 0.0f, 0.0f, 1.0f);
        this.bg.directionalLight(250.0f, 250.0f, 250.0f, -1.0f, 0.0f, 0.0f);
        this.bg.lightSpecular(200.0f, 200.0f, 200.0f);
        this.bg.translate((float)(this.p.width / 2 + this.r.nextInt(this.cubeJitter) - this.cubeJitter / 2), (float)(this.p.height / 2 + this.r.nextInt(this.cubeJitter) - this.cubeJitter / 2), (float)this.r.nextInt(this.cubeJitter));
        this.bg.rotateY(this.ry);
        this.bg.rotateX(this.rx);
        this.bg.rotateZ(this.rz);
        this.ry += this.rdy;
        this.rx += this.rdx;
        this.rz += this.rdz;
        if (this.bgc > 1) {
            --this.bgc;
        } else {
            this.cubeJitter = this.cubeShaker;
        }
        this.bg.background(this.bgc);
        if (this.fillc < 50) {
            ++this.fillc;
        }
        this.bg.fill((float)this.fillc, (float)this.fillc, (float)this.fillc);
        this.bg.strokeWeight(20.0f);
        if (this.strokec > 20) {
            --this.strokec;
        }
        if (this.strokebc > 1) {
            --this.strokebc;
        }
        this.bg.stroke((float)this.strokec, (float)this.strokec, (float)this.strokebc);
        this.bg.box(300.0f);
        this.bg.endDraw();
        this.bg.loadPixels();
    }

    private void drawMetaballs(float demotime, boolean beat) {
        this.mBalls.draw(demotime, beat);
        this.bg.beginDraw();
        this.bg.image((PImage)this.mBalls.pg, 0.0f, 0.0f, (float)this.bg.width, (float)this.bg.height);
        this.bg.endDraw();
    }
}

