/*
 * Decompiled with CFR 0.152.
 */
package intro;

import intro.Effu;
import intro.Metaball;
import java.util.ArrayList;
import java.util.Random;
import processing.core.PApplet;
import processing.core.PGraphics;

public class Metaballs
extends Effu {
    public PGraphics pg;
    private ArrayList<Metaball> balls;
    int bg = 255;
    int bc = 255;
    float factor = 0.9f;
    float ballP = 0.0f;

    Metaballs(PApplet parent) {
        super(parent);
        Random r = new Random(9L);
        this.pg = this.p.createGraphics(this.p.width / 6, this.p.width / 6, "processing.core.PGraphics3D");
        this.balls = new ArrayList();
        int i = 0;
        while (i < 3) {
            Metaball b = new Metaball();
            b.x = r.nextInt(this.pg.width);
            b.y = r.nextInt(this.pg.height);
            b.dx = r.nextFloat();
            if (r.nextBoolean()) {
                b.dx *= -1.0f;
            }
            b.dy = r.nextFloat();
            if (r.nextBoolean()) {
                b.dy *= -1.0f;
            }
            b.speed = (int)(r.nextFloat() * 3.0f + 3.0f);
            b.size = (int)(r.nextFloat() * 15.0f + 15.0f);
            this.balls.add(b);
            ++i;
        }
    }

    @Override
    void draw(float demotime, boolean beat) {
        if (demotime > 86000.0f) {
            this.ballP += 0.5f;
        }
        for (Metaball ball : this.balls) {
            ball.x = (int)((float)ball.x + ball.dx * (float)ball.speed);
            ball.y = (int)((float)ball.y + ball.dy * (float)ball.speed);
            if (ball.x <= 0 || ball.x >= this.pg.width) {
                ball.dx *= -1.0f;
            }
            if (ball.y > 0 && ball.y < this.pg.height) continue;
            ball.dy *= -1.0f;
        }
        this.pg.beginDraw();
        this.pg.loadPixels();
        this.pg.background(this.bg);
        if (this.bg > 1) {
            --this.bg;
        }
        if (this.bc > 80) {
            this.bc -= 2;
        }
        int y = 0;
        while (y < this.pg.height) {
            int x = 0;
            while (x < this.pg.width) {
                double sum = 0.0;
                for (Metaball ball : this.balls) {
                    if (!((sum += (double)((float)ball.size + this.ballP) / Math.sqrt(Math.pow(ball.x - x, 2.0) + Math.pow(ball.y - y, 2.0))) > 0.9) || !(sum > 1.0)) continue;
                    this.pg.pixels[y * this.pg.width + x] = this.p.color((int)((double)this.bc / (sum * (double)this.factor)));
                }
                ++x;
            }
            ++y;
        }
        this.pg.updatePixels();
        this.pg.endDraw();
    }
}

