
setNumNoteSamples(6000) -- slower
--setNumNoteSamples(4000) -- faster

majorscale = {0, 2, 4, 5, 7, 9, 11, 12}
minorarpeggio = {0, 3, 7, 3, 0, 3, 7, 3}
majorarpeggio = {0, 4, 7, 4, 0, 4, 7, 4}
bassline = {0, 0, -1, 0, 12, 0, -1, 12 }

function emptytracker()
    for i=0,63,1 do
        setTrackerNote(i, 0, -1, -1)
        setTrackerNote(i, 1, -1, -1)
        setTrackerNote(i, 2, -1, -1)
        setTrackerNote(i, 3, -1, -1)
    end
end

function writeMelodyToTrack(s,t)
    for i=0,63,1 do
        setTrackerNote(i, t, s[i%8 + 1], math.floor(i/8) % 2 + 1)
    end
end

emptytracker()

writeMelodyToTrack(minorarpeggio, 0)
writeMelodyToTrack(bassline, 1)

---

function setSlowRandomWaveform(elementID, nSeg)
    rndtbl = {}
    for i=1,nSeg,1 do
        rndtbl[i] = math.random(200) * 0.01 - 1.0
    end
    
    function wavefn(t)
        segSize = 2*math.pi / nSeg
        segID = math.floor(t / segSize)
        return rndtbl[segID]
    end
    
    setWaveform(getSelectedElement(), 200)
end

function setPeriodicallyChangingRandomWaveform(numSeconds, nSeg)
    prevT = 0
    function sbUpdate(t)
        if math.floor(t/numSeconds) ~= prevT then
            setSlowRandomWaveform(getSelectedElement(), nSeg)
            prevT = math.floor(t/numSeconds)
        end
    end
end
