float4x4 objectToWorldMatrix;
float4x4 worldToCameraMatrix;
float4x4 projMatrix;
float4x4 textureMatrix;

float2 center;
float2 radius;
float strength;
float bias;

Texture2D txDiffuse;

SamplerState samLinear
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};

struct VS_IN
{
    float4 pos : POSITION;
    float3 normal: NORMAL;
    float4 col : COLOR;
    float2 texCoord : TEXCOORD;
    float3 tangent: TANGENT;
    float3 binormal: BINORMAL;
};

struct PS_IN
{
    float4 pos : SV_POSITION;
    float4 col : COLOR;
    float2 texCoord: TEXCOORD0;
};

PS_IN VS( VS_IN input )
{
    PS_IN output = (PS_IN)0;

    uint MipLevel;
    uint Width;
    uint Height;
    uint Elements;
    uint Depth;
    uint NumberOfLevels;
    uint NumberOfSamples;
    txDiffuse.GetDimensions(Width, Height);

    float4 worldTPos = mul(float4(0, 0, 0, 1), objectToWorldMatrix);

    float2 displaceTexCoord = worldTPos.xy/100.0f;
    float4 displaceSample = txDiffuse.Load(int3(displaceTexCoord.x*Width, displaceTexCoord.y*Height, 0));
    displaceSample *= 10;
	displaceSample.b = displaceSample.b * radius.x + radius.y;

    float4x4 rotateTransform;
    rotateTransform[0].xyzw =  float4(cos(displaceSample.b), sin(displaceSample.b), 0, 0);
    rotateTransform[1].xyzw =  float4(-sin(displaceSample.b), cos(displaceSample.b), 0, 0);
    rotateTransform[2].xyzw = float4(0, 0, 1, 0);
    rotateTransform[3].xyzw = float4(0, 0, 0, 1);

    float4x4 scaleTransform;
    scaleTransform[0].xyzw = center.x * float4(displaceSample.r, 0, 0, 0);
    scaleTransform[1].xyzw = center.y * float4(0, displaceSample.g, 0, 0);
    scaleTransform[2].xyzw = float4(0, 0, 1, 0);
    scaleTransform[3].xyzw = float4(0, 0, 0, 1);


    input.pos = mul(input.pos, rotateTransform);
    input.pos = mul(input.pos, scaleTransform);
    input.pos = mul(input.pos, objectToWorldMatrix);
    output.pos = mul(input.pos, worldToCameraMatrix);
    output.pos = mul(output.pos, projMatrix);

    output.col = input.col;
    output.texCoord = mul(float4(input.texCoord.xy, 0, 1), textureMatrix).xy;

    return output;
}

float4 PS( PS_IN input ) : SV_Target
{
//    return txDiffuse.Sample(samLinear, input.texCoord) * input.col;
    return input.col;
}

technique10 Render
{
    pass P0
    {
        SetGeometryShader( 0 );
        SetVertexShader( CompileShader( vs_4_0, VS() ) );
        SetPixelShader( CompileShader( ps_4_0, PS() ) );
    }
}
