
#version 330

layout(location = 0) out vec3 texOut;
layout(location = 1) out vec3 accOut;
in vec2 uv;
uniform sampler2DMS tex;
uniform sampler2DMS blur;
uniform sampler2DMS acc;
uniform sampler2DMS depth;

uniform float exposure;
uniform float maxbright;
uniform float accumulation;
uniform float mixnew;
uniform float mixold;
uniform float mixbloom;
uniform float accnew;
uniform float accold;
uniform float accbloom;

void main(void)
{
	vec3 g=vec3(0.0);
	vec3 a=vec3(0.0);
	vec3 b=vec3(0.0);
	float d = 10.0;
	for(int i=0;i<8;i++){
		g += texelFetch(tex, ivec2(gl_FragCoord.xy), i).rgb;
		d = min(d, texelFetch(depth, ivec2(gl_FragCoord.xy), i).r);
	}
	g *= 0.125;


	//Could potentially use the depth buffer for DoF, no scenes to test it on atm though.

	b += texelFetch(blur, ivec2(gl_FragCoord.xy), 0).rgb;
	a += texelFetch(acc, ivec2(gl_FragCoord.xy), 0).rgb;
	vec3 f = g*mixnew+b*mixbloom+a*mixold;
	texOut = f*exposure * (exposure / (maxbright + 1.0)) / (exposure + 1.0);
	accOut = g*accnew+b*accbloom+a*accold;
}
