
#version 150

out vec4 out_Color;
in vec2 uv;
uniform sampler2DMS tex;
uniform float exposure;
uniform float maxbright;
uniform float distort;
uniform vec2 res;

void main(void)
{
	vec3 g=vec3(0.0);
	vec2 p = gl_FragCoord.xy;
	p.x-=res.x/2;
	p.y-=res.y/2;
	p.x /= res.x;
	p.y /= res.y;
	float d = sqrt(p.x*p.x+p.y*p.y);
	d=d;
	float du = d*3;
	float r = atan(p.x,p.y);
	p = vec2(sin(r)*d,cos(r)*d);
	p.x *= res.x;
	p.y *= res.y;
	
	p.x+=res.x/2;
	p.y+=res.y/2;
	
	for(int i=0;i<8;i++){
		g = texelFetch(tex, ivec2(
			mod(p,res)
		), i).rgb;
	}
	g *= 0.125;
	vec4 f = vec4(g.r,g.g,g.b,1.0);
	out_Color = f*exposure * (exposure / (maxbright + 1.0)) / (exposure + 1.0);
	//out_Color *= out_Color;
	out_Color = out_Color*(2-distort*0.1+.8-du*du)*max(distort*0.1-.8,0)+out_Color*clamp(1-distort*0.1+.8,0,1);

}
