/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;

public class Player {
    static double G = 0.075;
    private double x;
    private double y;
    private double oldX;
    private double oldY;
    private double vy = 0.0;
    private double vx = 0.0;
    private int width = 50;
    private int height = 100;
    private Image normalImage;
    private ImageIcon hitImage;
    private boolean landed;
    private int jumpCounter = 2;
    private boolean moveRight;
    private boolean moveLeft;
    private boolean moveUp;
    private boolean moveDown;
    private boolean isHit;
    private boolean facingRight = true;
    private double health = 100.0;
    private int lives = 3;
    static final int TROLL = 0;
    static final int TROLL_2 = 1;
    private int xOffset;
    private Image leftImage;
    private Image rightImage;
    private Image currentImage;
    private Image rightHitImage;
    private Image leftHitImage;
    private Image attackLeft;
    private Image attackRight;
    private Image[] walkLeft = new Image[6];
    private Image[] walkRight = new Image[6];
    private Image[] currentImageArray;
    private int animationCounter;
    private int animationIndex;
    private int animationSpeed = 10;
    private boolean attacking;
    private int attackCooldown = 0;
    private int hammers;
    private Image head;

    public Player(double x, double y, int type) {
        this.x = x;
        this.y = y;
        switch (type) {
            case 0: {
                this.head = new ImageIcon(this.getClass().getResource("trollHead.png")).getImage();
                this.walkRight[0] = new ImageIcon(this.getClass().getResource("trollWalkLeft0.png")).getImage();
                this.walkRight[1] = new ImageIcon(this.getClass().getResource("trollWalkLeft1.png")).getImage();
                this.walkRight[2] = new ImageIcon(this.getClass().getResource("trollWalkLeft2.png")).getImage();
                this.walkRight[3] = new ImageIcon(this.getClass().getResource("trollWalkLeft3.png")).getImage();
                this.walkRight[4] = new ImageIcon(this.getClass().getResource("trollWalkLeft2.png")).getImage();
                this.walkRight[5] = new ImageIcon(this.getClass().getResource("trollWalkLeft1.png")).getImage();
                this.walkLeft[0] = new ImageIcon(this.getClass().getResource("trollWalkRight0.png")).getImage();
                this.walkLeft[1] = new ImageIcon(this.getClass().getResource("trollWalkRight1.png")).getImage();
                this.walkLeft[2] = new ImageIcon(this.getClass().getResource("trollWalkRight2.png")).getImage();
                this.walkLeft[3] = new ImageIcon(this.getClass().getResource("trollWalkRight3.png")).getImage();
                this.walkLeft[4] = new ImageIcon(this.getClass().getResource("trollWalkRight2.png")).getImage();
                this.walkLeft[5] = new ImageIcon(this.getClass().getResource("trollWalkRight1.png")).getImage();
                this.attackLeft = new ImageIcon(this.getClass().getResource("trollAttackLeftHandske.png")).getImage();
                this.attackRight = new ImageIcon(this.getClass().getResource("trollAttackRightHandske.png")).getImage();
                break;
            }
            case 1: {
                this.head = new ImageIcon(this.getClass().getResource("aloneHead.png")).getImage();
                this.walkRight[0] = new ImageIcon(this.getClass().getResource("troll2_0.png")).getImage();
                this.walkRight[1] = new ImageIcon(this.getClass().getResource("troll2_1.png")).getImage();
                this.walkRight[2] = new ImageIcon(this.getClass().getResource("troll2_2.png")).getImage();
                this.walkRight[3] = new ImageIcon(this.getClass().getResource("troll2_3.png")).getImage();
                this.walkRight[4] = new ImageIcon(this.getClass().getResource("troll2_2.png")).getImage();
                this.walkRight[5] = new ImageIcon(this.getClass().getResource("troll2_1.png")).getImage();
                this.walkLeft[0] = new ImageIcon(this.getClass().getResource("troll3_0.png")).getImage();
                this.walkLeft[1] = new ImageIcon(this.getClass().getResource("troll3_1.png")).getImage();
                this.walkLeft[2] = new ImageIcon(this.getClass().getResource("troll3_2.png")).getImage();
                this.walkLeft[3] = new ImageIcon(this.getClass().getResource("troll3_3.png")).getImage();
                this.walkLeft[4] = new ImageIcon(this.getClass().getResource("troll3_2.png")).getImage();
                this.walkLeft[5] = new ImageIcon(this.getClass().getResource("troll3_1.png")).getImage();
                this.attackLeft = new ImageIcon(this.getClass().getResource("troll3_attack.png")).getImage();
                this.attackRight = new ImageIcon(this.getClass().getResource("troll2_attack.png")).getImage();
            }
        }
    }

    public void setAttacking(boolean b) {
        this.attacking = b;
    }

    public void updateAnimation() {
        if (Math.abs(this.vx) < 0.01 && !this.moveRight && !this.moveLeft || this.jumpCounter != 2) {
            this.animationIndex = 0;
        } else {
            --this.animationCounter;
            if (this.animationCounter <= 0) {
                this.animationCounter = this.animationSpeed;
                ++this.animationIndex;
                if (this.animationIndex >= this.walkLeft.length - 1) {
                    this.animationIndex = 0;
                }
            }
        }
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public void jump() {
        if (this.jumpCounter > 0) {
            this.vy = -5.0;
            --this.jumpCounter;
        }
    }

    public void moveX() {
        if (this.moveRight) {
            this.x += 1.0;
            this.facingRight = true;
        }
        if (this.moveLeft) {
            this.x -= 1.0;
            this.facingRight = false;
        }
        this.x += this.vx;
        if (this.isHit) {
            if (this.vx < 0.001 && this.vx > -0.001) {
                this.isHit = false;
            } else if (this.vx > 0.0) {
                this.vx -= 0.01;
            } else if (this.vx < 0.0) {
                this.vx += 0.01;
            }
        }
    }

    public void getHit(int vx, double d) {
        this.vx = vx;
        this.health -= d;
        this.isHit = true;
    }

    public void updateOldPos() {
        this.oldX = this.x;
        this.oldY = this.y;
    }

    public void moveY() {
        this.vy += G;
        this.y += this.vy;
    }

    public void collideX() {
        this.x = this.oldX;
        if (this.vx != 0.0) {
            this.vx = -this.vx;
        }
    }

    public void collideY() {
        this.vy = 0.0;
        this.y = this.oldY;
    }

    public void decreaseLives() {
        --this.lives;
    }

    public void setFullHealth() {
        this.health = 100.0;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public boolean isFacingRight() {
        return this.facingRight;
    }

    public void setMoveRight(boolean moveRight) {
        this.moveRight = moveRight;
    }

    public void setMoveLeft(boolean moveLeft) {
        this.moveLeft = moveLeft;
    }

    public void setMoveUp(boolean moveUp) {
        this.moveUp = moveUp;
    }

    public void setMoveDown(boolean moveDown) {
        this.moveDown = moveDown;
    }

    public void footCollision() {
        this.jumpCounter = 2;
    }

    public double getHealth() {
        return this.health;
    }

    public void killPlayer() {
        this.health = -999999.0;
    }

    public void draw(Graphics g) {
        g.setColor(Color.BLACK);
        g.drawString("Troll hammers: " + this.hammers, (int)this.x, (int)this.y);
        g.setColor(Color.RED);
        g.fillRect((int)this.x, (int)this.y - 20, 50, 10);
        g.setColor(Color.GREEN);
        g.fillRect((int)this.x, (int)this.y - 20, (int)(50.0 * this.health / 100.0), 10);
        g.setColor(Color.BLACK);
        if (this.lives == 3) {
            g.drawImage(this.head, (int)this.x, (int)this.y - 30, null);
            g.drawImage(this.head, (int)this.x + 15, (int)this.y - 30, null);
        } else if (this.lives == 2) {
            g.drawImage(this.head, (int)this.x, (int)this.y - 30, null);
        }
        this.xOffset = 0;
        if (!(this.facingRight || this.moveUp || this.moveDown || this.attackCooldown <= 0)) {
            this.xOffset = -50;
        }
        if (this.attackCooldown > 0 && !this.moveUp && !this.moveDown) {
            if (this.facingRight) {
                g.drawImage(this.attackRight, (int)this.x + this.xOffset, (int)this.y, null);
            } else {
                g.drawImage(this.attackLeft, (int)this.x + this.xOffset, (int)this.y, null);
            }
        } else if (this.facingRight) {
            g.drawImage(this.walkRight[this.animationIndex], (int)this.x + this.xOffset, (int)this.y, null);
        } else {
            g.drawImage(this.walkLeft[this.animationIndex], (int)this.x + this.xOffset, (int)this.y, null);
        }
    }

    public void setAttackCooldown() {
        this.attackCooldown = 50;
    }

    public void decreaseAttackCooldown() {
        if (this.attackCooldown >= 0) {
            --this.attackCooldown;
        }
    }

    public int getAttackCooldown() {
        return this.attackCooldown;
    }

    public void addHammer() {
        ++this.hammers;
    }

    public int getHammers() {
        return this.hammers;
    }

    public void decreseHammers() {
        --this.hammers;
    }

    public void updateMoveUpDown() {
    }

    public int getLives() {
        return this.lives;
    }

    public int getFacing() {
        if (this.moveLeft) {
            return 3;
        }
        if (this.moveRight) {
            return 1;
        }
        if (this.moveUp) {
            return 0;
        }
        if (this.moveDown) {
            return 2;
        }
        if (this.facingRight) {
            return 1;
        }
        if (!this.facingRight) {
            return 3;
        }
        return -999;
    }
}

