/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;

public class Item {
    private double x;
    private double y;
    private double oldX;
    private double oldY;
    private double speed = 1.0;
    private int width = 50;
    private int height = 50;
    private int type;
    private boolean landed;
    private Image image;

    public Item(double x, double y, int type) {
        this.x = x;
        this.y = y;
        this.type = type;
        switch (type) {
            case 0: {
                this.image = new ImageIcon(this.getClass().getResource("hammare.png")).getImage();
            }
        }
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void move() {
        this.oldX = this.x;
        this.oldY = this.y;
        this.y += this.speed;
    }

    public void returnToOldPos() {
        this.x = this.oldX;
        this.y = this.oldY;
    }

    public void pickUp(Player p) {
        switch (this.type) {
            case 0: {
                p.addHammer();
            }
        }
    }

    public void draw(Graphics g) {
        switch (this.type) {
            case 0: {
                g.drawImage(this.image, (int)this.x, (int)this.y, null);
                break;
            }
            default: {
                g.setColor(Color.YELLOW);
                g.fillRect((int)this.x, (int)this.y, this.width, this.height);
            }
        }
    }

    public void setLanded(boolean b) {
        this.landed = b;
    }

    public boolean hasLanded() {
        return this.landed;
    }

    public void moveBack() {
        this.y -= this.speed;
    }
}

