/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import javax.swing.ImageIcon;

public class Attack {
    private double x;
    private double y;
    private int height;
    private int width;
    private int damage;
    private int attackLength = 100;
    private Player player;
    private boolean remove = false;
    private int distanceFromPlayer = 50;
    private boolean melee;
    private double speed;
    private Image borrUp;
    private Image borrDown;
    private int dir;
    private boolean hammer = true;
    private int hitBack = 0;

    public Attack(int x, int y, int w, int h, int d, int l, Player p, double s, boolean b, int hb) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        this.damage = d;
        this.attackLength = l;
        this.player = p;
        this.melee = false;
        this.speed = s;
        this.hammer = b;
        this.hitBack = hb;
    }

    public Attack(int w, int h, int d, int l, Player p, int dfp, int hb) {
        this.width = w;
        this.height = h;
        this.damage = d;
        this.attackLength = l;
        this.player = p;
        this.distanceFromPlayer = dfp;
        this.melee = true;
        this.hitBack = hb;
        this.borrUp = new ImageIcon(this.getClass().getResource("borrUp.png")).getImage();
        this.borrDown = new ImageIcon(this.getClass().getResource("borrDown.png")).getImage();
    }

    public void decreaseAttackLength() {
        --this.attackLength;
        if (this.attackLength <= 0) {
            this.remove = true;
        }
    }

    public void remove() {
        this.remove = true;
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getAttackLength() {
        return this.attackLength;
    }

    public double getDamage() {
        return this.damage;
    }

    public int getHitBack() {
        return this.hitBack;
    }

    public void setPosition() {
        if (this.melee) {
            this.dir = this.player.getFacing();
            switch (this.dir) {
                case 0: {
                    this.distanceFromPlayer = Math.abs(this.distanceFromPlayer);
                    this.x = (int)this.player.getX();
                    this.y = (int)(this.player.getY() - 50.0);
                    break;
                }
                case 1: {
                    this.distanceFromPlayer = Math.abs(this.distanceFromPlayer);
                    this.x = (int)(this.player.getX() + (double)this.distanceFromPlayer);
                    this.y = (int)(this.player.getY() + 22.0);
                    break;
                }
                case 2: {
                    this.distanceFromPlayer = Math.abs(this.distanceFromPlayer);
                    this.x = (int)this.player.getX();
                    this.y = (int)(this.player.getY() + 50.0);
                    break;
                }
                case 3: {
                    this.distanceFromPlayer = -Math.abs(this.distanceFromPlayer);
                    this.x = (int)(this.player.getX() + (double)this.distanceFromPlayer);
                    this.y = (int)(this.player.getY() + 22.0);
                }
            }
        } else {
            this.x += this.speed;
        }
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean shouldBeRemoved() {
        return this.remove;
    }

    public boolean isHammer() {
        return this.hammer;
    }

    public void draw(Graphics g) {
        if (this.dir == 0) {
            g.drawImage(this.borrUp, (int)this.x, (int)this.y, null);
        } else if (this.dir == 2) {
            g.drawImage(this.borrDown, (int)this.x, (int)this.y, null);
        }
        if (!this.melee) {
            if (this.hammer) {
                AffineTransform orig_form = ((Graphics2D)g).getTransform();
                AffineTransform new_form = (AffineTransform)orig_form.clone();
                new_form.rotate(Math.toRadians(-this.attackLength * 5), (int)this.x + 25, (int)this.y + 25);
                ((Graphics2D)g).setTransform(new_form);
                g.drawImage(new ImageIcon(this.getClass().getResource("hammare.png")).getImage(), (int)this.x, (int)this.y, null);
                ((Graphics2D)g).setTransform(orig_form);
            } else {
                g.drawImage(new ImageIcon(this.getClass().getResource("fireBall.png")).getImage(), (int)this.x, (int)this.y, null);
            }
        }
    }

    public int getDistanceFromPlayer() {
        return this.distanceFromPlayer;
    }
}

