uniform float timer;
varying vec3 position;
varying vec4 diffuse,ambientGlobal,ambient,normal;
varying vec3 lightDir,halfVector;
varying float dist;


float noise(vec2 pos,int seed);
float cosInterpolate(vec2 a, float x);
float smooth_2d_noise(vec2 pos,int seed);

float noise(vec2 pos,int seed) {
	float ret = fract(sin(seed+dot(pos,vec2(12.9898,78.233)))*43758.5453)*2.0-0.8;
	return ret;
}

float smooth_2d_noise(vec2 pos,int seed) {
	vec3 a = vec3(0,0,0);
	float ret;
	a.x = (noise(vec2(pos.x-1,pos.y-1),seed) + noise(vec2(pos.x+1,pos.y-1),seed) + noise(vec2(pos.x-1,pos.y+1),seed) + noise(vec2(pos.x+1,pos.y+1),seed)) / 16;
	a.y = (noise(vec2(pos.x-1,pos.y),seed) + noise(vec2(pos.x+1,pos.y),seed) + noise(vec2(pos.x,pos.y-1),seed) + noise(vec2(pos.x,pos.y+1),seed) ) / 8;
	a.z = noise(pos,seed)/4;
	ret = a.x + a.y + a.z;
	return ret;
}

float cosInterpolate(vec2 a, float x) {
	float ft,f,ret;
	float PI = 3.14159265358979323846264;
	ft = (x*PI);
	f = ((1-cos(ft)) * 0.5);
	ret = a.x*(1-f)+a.y*f;
	return ret;
}


float cos_2d_noise(vec2 pos, int seed) {
	vec2 int_pos = floor(pos);
	vec2 frac_pos = pos - int_pos;//fract(pos);
	float ret;
	vec4 v;
	vec2 i;
	
	v.x = smooth_2d_noise(int_pos,seed);	
	v.y = smooth_2d_noise(vec2(int_pos.x+1.0,int_pos.y),seed);
	v.z = smooth_2d_noise(vec2(int_pos.x,int_pos.y+1),seed);
	v.a = smooth_2d_noise(vec2(int_pos.x+1.0,int_pos.y+1.0),seed);
	
	i.x = cosInterpolate(vec2(v.x,v.y),frac_pos.x);
	i.y = cosInterpolate(vec2(v.z,v.a),frac_pos.x);
	
	ret = cosInterpolate(i,frac_pos.y);
	
	return ret;
}


float perlinNoise(vec2 pos,int seed) {
	int i;
	float ret = 0.0;
	float freq,amp;
	int p = 3;
	int n = 3;
	
	for(i=0;i<n;i++) {
		freq = pow(2,i);
		amp = pow(p,i);
		ret += cos_2d_noise(vec2(pos.x*freq,pos.y*freq),seed) *amp;
		ret += 0.1;
	}
	
	return ret;
}




void main() {
   vec4 ecPos;
   vec3 aux;
	float scale=0.005;
	float height = 10;
	float absh = -30;
	float xscale;
	vec2 move = vec2(0,timer);

	float yscale = (abs(gl_Vertex.x-500)*0.001)*absh;

	vec3 v0,v1,v2;
   vec3 n0,n1,fn;

   v0 = gl_Vertex.xyz;
   v1 = gl_Vertex.xyz + vec3(0,0,1);
   v2 = gl_Vertex.xyz + vec3(1,0,1);
 
   v0.y = perlinNoise(move+vec2(v0.x*scale,v0.z*scale),10)*height;
	v1.y = perlinNoise(move+vec2(v1.x*scale,v1.z*scale),10)*height;
	v2.y = perlinNoise(move+vec2(v2.x*scale,v2.z*scale),10)*height;
  	 
	v0.y *= yscale;
	v1.y *= yscale;
	v2.y *= yscale;

	

	n0.x = v0.x-v1.x;
   n0.y = v0.y-v1.y;
   n0.z = v0.z-v1.z;
                        
   n1.x = v1.x-v2.x;
   n1.y = v1.y-v2.y;
   n1.z = v1.z-v2.z;
      
   fn.x = n0.y*n1.z - n0.z*n1.y;
   fn.y = n0.z*n1.x - n0.x*n1.z;
   fn.z = n0.x*n1.y - n0.y*n1.x;
	
	fn=normalize(fn);
	
	gl_Vertex.xyz = v0;


	normal.xyz = normalize(gl_NormalMatrix * gl_Normal*fn);

	ecPos = gl_ModelViewMatrix * gl_Vertex;
	aux = vec3(gl_LightSource[0].position-ecPos);
	lightDir = normalize(aux);
	dist = length(aux);
	halfVector = normalize(gl_LightSource[0].halfVector.xyz);

	diffuse = gl_FrontMaterial.diffuse * gl_LightSource[0].diffuse;
	ambient = gl_FrontMaterial.ambient * gl_LightSource[0].ambient;
	ambientGlobal = gl_LightModel.ambient * gl_FrontMaterial.ambient;

	gl_Position=ftransform();
	gl_TexCoord[0] = gl_MultiTexCoord0;
	position = gl_Position.xyz;

	vec4 viewPos = gl_ModelViewMatrix * gl_Vertex;
	normal.a = -viewPos.z/500.0;
	position.z = normal.a;


	gl_TexCoord[0].st += move;
}
