//depth of field
uniform float focalDistance, focalRange;
varying float Blur;
varying float depth_z;
//lighting
varying vec4 in_diffuse,in_ambientGlobal,in_ambient;
varying vec3 in_normal,in_lightDir,in_halfVector;
varying float in_dist;


void main(void) {
	vec4 ecPos;
	vec3 aux;

	in_normal = normalize(gl_NormalMatrix * gl_Normal);
		
		/* these are the new lines of code to compute the light's direction */
	ecPos = gl_ModelViewMatrix * gl_Vertex;
	aux = vec3(gl_LightSource[0].position-ecPos);
	in_lightDir = normalize(aux);
	in_dist = length(aux);
	
	in_halfVector = normalize(gl_LightSource[0].halfVector.xyz);
		
	/* Compute the diffuse, ambient and globalAmbient terms */
	in_diffuse = gl_FrontMaterial.diffuse * gl_LightSource[0].diffuse;
		
	/* The ambient terms have been separated since one of them */
	/* suffers attenuation */
	in_ambient = gl_FrontMaterial.ambient * gl_LightSource[0].ambient;
	in_ambientGlobal = gl_LightModel.ambient * gl_FrontMaterial.ambient;

	//ending
	gl_FrontColor = gl_Color;
	Blur = clamp(abs(-ecPos.z - focalDistance) / focalRange, 0.0, 1.0);
	gl_Position = ftransform();
	depth_z = gl_Position.z/200.0f;
	depth_z = 1-depth_z;
	gl_TexCoord[0] = gl_MultiTexCoord0;
}
