uniform sampler2D colorMap;
const float blurSize = 1.0/1024.0;
 void main(void) {
   vec4 sum = vec4(0.0);
 
   // blur in y (vertical)
   // take nine samples, with the distance blurSize between them
   sum += texture2D(colorMap, vec2(gl_TexCoord[0].st.x - 4.0*blurSize, gl_TexCoord[0].st.y)) * 0.05;
   sum += texture2D(colorMap, vec2(gl_TexCoord[0].st.x - 3.0*blurSize, gl_TexCoord[0].st.y)) * 0.09;
   sum += texture2D(colorMap, vec2(gl_TexCoord[0].st.x - 2.0*blurSize, gl_TexCoord[0].st.y)) * 0.12;
   sum += texture2D(colorMap, vec2(gl_TexCoord[0].st.x - blurSize, gl_TexCoord[0].st.y)) * 0.15;
   sum += texture2D(colorMap, vec2(gl_TexCoord[0].st.x, gl_TexCoord[0].st.y)) * 0.16;
   sum += texture2D(colorMap, vec2(gl_TexCoord[0].st.x + blurSize, gl_TexCoord[0].st.y)) * 0.15;
   sum += texture2D(colorMap, vec2(gl_TexCoord[0].st.x + 2.0*blurSize, gl_TexCoord[0].st.y)) * 0.12;
   sum += texture2D(colorMap, vec2(gl_TexCoord[0].st.x + 3.0*blurSize, gl_TexCoord[0].st.y)) * 0.09;
   sum += texture2D(colorMap, vec2(gl_TexCoord[0].st.x + 4.0*blurSize, gl_TexCoord[0].st.y)) * 0.05; 
   gl_FragData[0] = sum;
}
