/*
 * Decompiled with CFR 0.152.
 */
package processing.xml;

import java.io.IOException;
import java.io.Reader;
import processing.xml.StdXMLReader;
import processing.xml.XMLEntityResolver;
import processing.xml.XMLParseException;
import processing.xml.XMLValidationException;

class XMLUtil {
    XMLUtil() {
    }

    static void skipComment(StdXMLReader reader) throws IOException, XMLParseException {
        if (reader.read() != '-') {
            XMLUtil.errorExpectedInput(reader.getSystemID(), reader.getLineNr(), "<!--");
        }
        int dashesRead = 0;
        block4: while (true) {
            char ch = reader.read();
            switch (ch) {
                case '-': {
                    ++dashesRead;
                    continue block4;
                }
                case '>': {
                    if (dashesRead == 2) {
                        return;
                    }
                    dashesRead = 0;
                    continue block4;
                }
            }
            dashesRead = 0;
        }
    }

    static void skipTag(StdXMLReader reader) throws IOException, XMLParseException {
        int level = 1;
        while (level > 0) {
            char ch = reader.read();
            switch (ch) {
                case '<': {
                    ++level;
                    break;
                }
                case '>': {
                    --level;
                }
            }
        }
    }

    static String scanPublicID(StringBuffer publicID, StdXMLReader reader) throws IOException, XMLParseException {
        if (!XMLUtil.checkLiteral(reader, "UBLIC")) {
            return null;
        }
        XMLUtil.skipWhitespace(reader, null);
        publicID.append(XMLUtil.scanString(reader, '\u0000', null));
        XMLUtil.skipWhitespace(reader, null);
        return XMLUtil.scanString(reader, '\u0000', null);
    }

    static String scanSystemID(StdXMLReader reader) throws IOException, XMLParseException {
        if (!XMLUtil.checkLiteral(reader, "YSTEM")) {
            return null;
        }
        XMLUtil.skipWhitespace(reader, null);
        return XMLUtil.scanString(reader, '\u0000', null);
    }

    static String scanIdentifier(StdXMLReader reader) throws IOException, XMLParseException {
        char ch;
        StringBuffer result = new StringBuffer();
        while ((ch = reader.read()) == '_' || ch == ':' || ch == '-' || ch == '.' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch > '~') {
            result.append(ch);
        }
        reader.unread(ch);
        return result.toString();
    }

    static String scanString(StdXMLReader reader, char entityChar, XMLEntityResolver entityResolver) throws IOException, XMLParseException {
        StringBuffer result = new StringBuffer();
        int startingLevel = reader.getStreamLevel();
        char delim = reader.read();
        if (delim != '\'' && delim != '\"') {
            XMLUtil.errorExpectedInput(reader.getSystemID(), reader.getLineNr(), "delimited string");
        }
        while (true) {
            String str;
            char ch;
            if ((ch = (str = XMLUtil.read(reader, entityChar)).charAt(0)) == entityChar) {
                if (str.charAt(1) == '#') {
                    result.append(XMLUtil.processCharLiteral(str));
                    continue;
                }
                XMLUtil.processEntity(str, reader, entityResolver);
                continue;
            }
            if (ch == '&') {
                reader.unread(ch);
                str = XMLUtil.read(reader, '&');
                if (str.charAt(1) == '#') {
                    result.append(XMLUtil.processCharLiteral(str));
                    continue;
                }
                result.append(str);
                continue;
            }
            if (reader.getStreamLevel() == startingLevel) {
                if (ch == delim) break;
                if (ch == '\t' || ch == '\n' || ch == '\r') {
                    result.append(' ');
                    continue;
                }
                result.append(ch);
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    static void processEntity(String entity, StdXMLReader reader, XMLEntityResolver entityResolver) throws IOException, XMLParseException {
        boolean externalEntity;
        Reader entityReader = entityResolver.getEntity(reader, entity = entity.substring(1, entity.length() - 1));
        if (entityReader == null) {
            XMLUtil.errorInvalidEntity(reader.getSystemID(), reader.getLineNr(), entity);
        }
        reader.startNewStream(entityReader, !(externalEntity = entityResolver.isExternalEntity(entity)));
    }

    static char processCharLiteral(String entity) throws IOException, XMLParseException {
        if (entity.charAt(2) == 'x') {
            entity = entity.substring(3, entity.length() - 1);
            return (char)Integer.parseInt(entity, 16);
        }
        entity = entity.substring(2, entity.length() - 1);
        return (char)Integer.parseInt(entity, 10);
    }

    static void skipWhitespace(StdXMLReader reader, StringBuffer buffer) throws IOException {
        char ch;
        if (buffer == null) {
            while ((ch = reader.read()) == ' ' || ch == '\t' || ch == '\n') {
            }
        } else {
            while ((ch = reader.read()) == ' ' || ch == '\t' || ch == '\n') {
                if (ch == '\n') {
                    buffer.append('\n');
                    continue;
                }
                buffer.append(' ');
            }
        }
        reader.unread(ch);
    }

    static String read(StdXMLReader reader, char entityChar) throws IOException, XMLParseException {
        char ch = reader.read();
        StringBuffer buf = new StringBuffer();
        buf.append(ch);
        if (ch == entityChar) {
            while (ch != ';') {
                ch = reader.read();
                buf.append(ch);
            }
        }
        return buf.toString();
    }

    static char readChar(StdXMLReader reader, char entityChar) throws IOException, XMLParseException {
        String str = XMLUtil.read(reader, entityChar);
        char ch = str.charAt(0);
        if (ch == entityChar) {
            XMLUtil.errorUnexpectedEntity(reader.getSystemID(), reader.getLineNr(), str);
        }
        return ch;
    }

    static boolean checkLiteral(StdXMLReader reader, String literal) throws IOException, XMLParseException {
        int i = 0;
        while (i < literal.length()) {
            if (reader.read() != literal.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static void errorExpectedInput(String systemID, int lineNr, String expectedString) throws XMLParseException {
        throw new XMLParseException(systemID, lineNr, "Expected: " + expectedString);
    }

    static void errorInvalidEntity(String systemID, int lineNr, String entity) throws XMLParseException {
        throw new XMLParseException(systemID, lineNr, "Invalid entity: `&" + entity + ";'");
    }

    static void errorUnexpectedEntity(String systemID, int lineNr, String entity) throws XMLParseException {
        throw new XMLParseException(systemID, lineNr, "No entity reference is expected here (" + entity + ")");
    }

    static void errorUnexpectedCDATA(String systemID, int lineNr) throws XMLParseException {
        throw new XMLParseException(systemID, lineNr, "No CDATA section is expected here");
    }

    static void errorInvalidInput(String systemID, int lineNr, String unexpectedString) throws XMLParseException {
        throw new XMLParseException(systemID, lineNr, "Invalid input: " + unexpectedString);
    }

    static void errorWrongClosingTag(String systemID, int lineNr, String expectedName, String wrongName) throws XMLParseException {
        throw new XMLParseException(systemID, lineNr, "Closing tag does not match opening tag: `" + wrongName + "' != `" + expectedName + "'");
    }

    static void errorClosingTagNotEmpty(String systemID, int lineNr) throws XMLParseException {
        throw new XMLParseException(systemID, lineNr, "Closing tag must be empty");
    }

    static void errorMissingElement(String systemID, int lineNr, String parentElementName, String missingElementName) throws XMLValidationException {
        throw new XMLValidationException(1, systemID, lineNr, missingElementName, null, null, "Element " + parentElementName + " expects to have a " + missingElementName);
    }

    static void errorUnexpectedElement(String systemID, int lineNr, String parentElementName, String unexpectedElementName) throws XMLValidationException {
        throw new XMLValidationException(2, systemID, lineNr, unexpectedElementName, null, null, "Unexpected " + unexpectedElementName + " in a " + parentElementName);
    }

    static void errorMissingAttribute(String systemID, int lineNr, String elementName, String attributeName) throws XMLValidationException {
        throw new XMLValidationException(3, systemID, lineNr, elementName, attributeName, null, "Element " + elementName + " expects an attribute named " + attributeName);
    }

    static void errorUnexpectedAttribute(String systemID, int lineNr, String elementName, String attributeName) throws XMLValidationException {
        throw new XMLValidationException(4, systemID, lineNr, elementName, attributeName, null, "Element " + elementName + " did not expect an attribute " + "named " + attributeName);
    }

    static void errorInvalidAttributeValue(String systemID, int lineNr, String elementName, String attributeName, String attributeValue) throws XMLValidationException {
        throw new XMLValidationException(5, systemID, lineNr, elementName, attributeName, attributeValue, "Invalid value for attribute " + attributeName);
    }

    static void errorMissingPCData(String systemID, int lineNr, String parentElementName) throws XMLValidationException {
        throw new XMLValidationException(6, systemID, lineNr, null, null, null, "Missing #PCDATA in element " + parentElementName);
    }

    static void errorUnexpectedPCData(String systemID, int lineNr, String parentElementName) throws XMLValidationException {
        throw new XMLValidationException(7, systemID, lineNr, null, null, null, "Unexpected #PCDATA in element " + parentElementName);
    }

    static void validationError(String systemID, int lineNr, String message, String elementName, String attributeName, String attributeValue) throws XMLValidationException {
        throw new XMLValidationException(0, systemID, lineNr, elementName, attributeName, attributeValue, message);
    }
}

