/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.util.Arrays;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PLine;
import processing.core.PMatrix2D;
import processing.core.PPolygon;

public class PGraphics2D
extends PGraphics {
    PMatrix2D ctm = new PMatrix2D();
    PPolygon fpolygon;
    PPolygon spolygon;
    float[][] svertices;
    PPolygon tpolygon;
    int[] vertexOrder;
    PLine line;
    float[][] matrixStack = new float[32][6];
    int matrixStackDepth;
    DirectColorModel cm;
    MemoryImageSource mis;

    protected void allocate() {
        this.pixelCount = this.width * this.height;
        this.pixels = new int[this.pixelCount];
        if (this.primarySurface) {
            this.cm = new DirectColorModel(32, 0xFF0000, 65280, 255);
            this.mis = new MemoryImageSource(this.width, this.height, this.pixels, 0, this.width);
            this.mis.setFullBufferUpdates(true);
            this.mis.setAnimated(true);
            this.image = Toolkit.getDefaultToolkit().createImage(this.mis);
        }
    }

    public boolean canDraw() {
        return true;
    }

    public void beginDraw() {
        if (!this.settingsInited) {
            this.defaultSettings();
            this.fpolygon = new PPolygon(this);
            this.spolygon = new PPolygon(this);
            this.spolygon.vertexCount = 4;
            this.svertices = new float[2][];
        }
        this.resetMatrix();
        this.vertexCount = 0;
    }

    public void endDraw() {
        if (this.mis != null) {
            this.mis.newPixels(this.pixels, (ColorModel)this.cm, 0, this.width);
        }
        this.updatePixels();
    }

    public void beginShape(int kind) {
        this.shape = kind;
        this.vertexCount = 0;
        this.curveVertexCount = 0;
        this.fpolygon.reset(4);
        this.spolygon.reset(4);
        this.textureImage = null;
    }

    public void vertex(float x, float y, float z) {
        PGraphics2D.showDepthWarningXYZ("vertex");
    }

    public void vertex(float x, float y, float z, float u, float v) {
        PGraphics2D.showDepthWarningXYZ("vertex");
    }

    public void breakShape() {
        PGraphics2D.showWarning("This renderer cannot handle concave shapes or shapes with holes.");
    }

    public void endShape(int mode) {
        int i;
        if (this.ctm.isIdentity()) {
            i = 0;
            while (i < this.vertexCount) {
                this.vertices[i][18] = this.vertices[i][0];
                this.vertices[i][19] = this.vertices[i][1];
                ++i;
            }
        } else {
            i = 0;
            while (i < this.vertexCount) {
                this.vertices[i][18] = this.ctm.multX(this.vertices[i][0], this.vertices[i][1]);
                this.vertices[i][19] = this.ctm.multY(this.vertices[i][0], this.vertices[i][1]);
                ++i;
            }
        }
        this.fpolygon.texture(this.textureImage);
        this.spolygon.interpARGB = true;
        this.fpolygon.interpARGB = true;
        switch (this.shape) {
            case 2: {
                if (!this.stroke) break;
                if (this.ctm.m00 == this.ctm.m11 && this.strokeWeight == 1.0f) {
                    int i2 = 0;
                    while (i2 < this.vertexCount) {
                        this.thin_point(this.vertices[i2][18], this.vertices[i2][19], this.strokeColor);
                        ++i2;
                    }
                } else {
                    int i3 = 0;
                    while (i3 < this.vertexCount) {
                        float[] v = this.vertices[i3];
                        this.thick_point(v[18], v[19], v[20], v[13], v[14], v[15], v[16]);
                        ++i3;
                    }
                }
                break;
            }
            case 4: {
                if (!this.stroke) break;
                int increment = this.shape == 4 ? 2 : 1;
                this.draw_lines(this.vertices, this.vertexCount - 1, 1, increment, 0);
                break;
            }
            case 11: {
                int i4;
                if (this.fill || this.textureImage != null) {
                    this.fpolygon.vertexCount = 3;
                    i4 = 1;
                    while (i4 < this.vertexCount - 1) {
                        this.fpolygon.vertices[2][3] = this.vertices[0][3];
                        this.fpolygon.vertices[2][4] = this.vertices[0][4];
                        this.fpolygon.vertices[2][5] = this.vertices[0][5];
                        this.fpolygon.vertices[2][6] = this.vertices[0][6];
                        this.fpolygon.vertices[2][18] = this.vertices[0][18];
                        this.fpolygon.vertices[2][19] = this.vertices[0][19];
                        if (this.textureImage != null) {
                            this.fpolygon.vertices[2][7] = this.vertices[0][7];
                            this.fpolygon.vertices[2][8] = this.vertices[0][8];
                        }
                        int j = 0;
                        while (j < 2) {
                            this.fpolygon.vertices[j][3] = this.vertices[i4 + j][3];
                            this.fpolygon.vertices[j][4] = this.vertices[i4 + j][4];
                            this.fpolygon.vertices[j][5] = this.vertices[i4 + j][5];
                            this.fpolygon.vertices[j][6] = this.vertices[i4 + j][6];
                            this.fpolygon.vertices[j][18] = this.vertices[i4 + j][18];
                            this.fpolygon.vertices[j][19] = this.vertices[i4 + j][19];
                            if (this.textureImage != null) {
                                this.fpolygon.vertices[j][7] = this.vertices[i4 + j][7];
                                this.fpolygon.vertices[j][8] = this.vertices[i4 + j][8];
                            }
                            ++j;
                        }
                        this.fpolygon.render();
                        ++i4;
                    }
                }
                if (!this.stroke) break;
                i4 = 1;
                while (i4 < this.vertexCount) {
                    this.draw_line(this.vertices[0], this.vertices[i4]);
                    ++i4;
                }
                i4 = 1;
                while (i4 < this.vertexCount - 1) {
                    this.draw_line(this.vertices[i4], this.vertices[i4 + 1]);
                    ++i4;
                }
                this.draw_line(this.vertices[this.vertexCount - 1], this.vertices[1]);
                break;
            }
            case 9: 
            case 10: {
                int increment;
                int n = increment = this.shape == 9 ? 3 : 1;
                if (this.fill || this.textureImage != null) {
                    this.fpolygon.vertexCount = 3;
                    int i5 = 0;
                    while (i5 < this.vertexCount - 2) {
                        int j = 0;
                        while (j < 3) {
                            this.fpolygon.vertices[j][3] = this.vertices[i5 + j][3];
                            this.fpolygon.vertices[j][4] = this.vertices[i5 + j][4];
                            this.fpolygon.vertices[j][5] = this.vertices[i5 + j][5];
                            this.fpolygon.vertices[j][6] = this.vertices[i5 + j][6];
                            this.fpolygon.vertices[j][18] = this.vertices[i5 + j][18];
                            this.fpolygon.vertices[j][19] = this.vertices[i5 + j][19];
                            this.fpolygon.vertices[j][20] = this.vertices[i5 + j][20];
                            if (this.textureImage != null) {
                                this.fpolygon.vertices[j][7] = this.vertices[i5 + j][7];
                                this.fpolygon.vertices[j][8] = this.vertices[i5 + j][8];
                            }
                            ++j;
                        }
                        this.fpolygon.render();
                        i5 += increment;
                    }
                }
                if (!this.stroke) break;
                if (this.shape == 10) {
                    this.draw_lines(this.vertices, this.vertexCount - 1, 1, 1, 0);
                } else {
                    this.draw_lines(this.vertices, this.vertexCount - 1, 1, 1, 3);
                }
                this.draw_lines(this.vertices, this.vertexCount - 2, 2, increment, 0);
                break;
            }
            case 16: {
                int i6;
                if (this.fill || this.textureImage != null) {
                    this.fpolygon.vertexCount = 4;
                    i6 = 0;
                    while (i6 < this.vertexCount - 3) {
                        int j = 0;
                        while (j < 4) {
                            int jj = i6 + j;
                            this.fpolygon.vertices[j][3] = this.vertices[jj][3];
                            this.fpolygon.vertices[j][4] = this.vertices[jj][4];
                            this.fpolygon.vertices[j][5] = this.vertices[jj][5];
                            this.fpolygon.vertices[j][6] = this.vertices[jj][6];
                            this.fpolygon.vertices[j][18] = this.vertices[jj][18];
                            this.fpolygon.vertices[j][19] = this.vertices[jj][19];
                            this.fpolygon.vertices[j][20] = this.vertices[jj][20];
                            if (this.textureImage != null) {
                                this.fpolygon.vertices[j][7] = this.vertices[jj][7];
                                this.fpolygon.vertices[j][8] = this.vertices[jj][8];
                            }
                            ++j;
                        }
                        this.fpolygon.render();
                        i6 += 4;
                    }
                }
                if (!this.stroke) break;
                i6 = 0;
                while (i6 < this.vertexCount - 3) {
                    this.draw_line(this.vertices[i6 + 0], this.vertices[i6 + 1]);
                    this.draw_line(this.vertices[i6 + 1], this.vertices[i6 + 2]);
                    this.draw_line(this.vertices[i6 + 2], this.vertices[i6 + 3]);
                    this.draw_line(this.vertices[i6 + 3], this.vertices[i6 + 0]);
                    i6 += 4;
                }
                break;
            }
            case 17: {
                if (this.fill || this.textureImage != null) {
                    this.fpolygon.vertexCount = 4;
                    int i7 = 0;
                    while (i7 < this.vertexCount - 3) {
                        int j = 0;
                        while (j < 4) {
                            int jj = i7 + j;
                            if (j == 2) {
                                jj = i7 + 3;
                            }
                            if (j == 3) {
                                jj = i7 + 2;
                            }
                            this.fpolygon.vertices[j][3] = this.vertices[jj][3];
                            this.fpolygon.vertices[j][4] = this.vertices[jj][4];
                            this.fpolygon.vertices[j][5] = this.vertices[jj][5];
                            this.fpolygon.vertices[j][6] = this.vertices[jj][6];
                            this.fpolygon.vertices[j][18] = this.vertices[jj][18];
                            this.fpolygon.vertices[j][19] = this.vertices[jj][19];
                            this.fpolygon.vertices[j][20] = this.vertices[jj][20];
                            if (this.textureImage != null) {
                                this.fpolygon.vertices[j][7] = this.vertices[jj][7];
                                this.fpolygon.vertices[j][8] = this.vertices[jj][8];
                            }
                            ++j;
                        }
                        this.fpolygon.render();
                        i7 += 2;
                    }
                }
                if (!this.stroke) break;
                this.draw_lines(this.vertices, this.vertexCount - 1, 1, 2, 0);
                this.draw_lines(this.vertices, this.vertexCount - 2, 2, 1, 0);
                break;
            }
            case 20: {
                if (this.isConvex()) {
                    if (this.fill || this.textureImage != null) {
                        this.fpolygon.renderPolygon(this.vertices, this.vertexCount);
                    }
                    if (!this.stroke) break;
                    this.draw_lines(this.vertices, this.vertexCount - 1, 1, 1, 0);
                    if (mode != 2) break;
                    this.draw_line(this.vertices[this.vertexCount - 1], this.vertices[0]);
                    break;
                }
                if (this.fill || this.textureImage != null) {
                    boolean smoov = this.smooth;
                    if (this.stroke) {
                        this.smooth = false;
                    }
                    this.concaveRender();
                    if (this.stroke) {
                        this.smooth = smoov;
                    }
                }
                if (!this.stroke) break;
                this.draw_lines(this.vertices, this.vertexCount - 1, 1, 1, 0);
                if (mode != 2) break;
                this.draw_line(this.vertices[this.vertexCount - 1], this.vertices[0]);
            }
        }
        this.shape = 0;
    }

    private boolean isConvex() {
        if (this.vertexCount < 3) {
            return true;
        }
        int flag = 0;
        int i = 0;
        while (i < this.vertexCount) {
            float[] vj = this.vertices[(i + 1) % this.vertexCount];
            float[] vi = this.vertices[i];
            float[] vk = this.vertices[(i + 2) % this.vertexCount];
            float calc = (vj[18] - vi[18]) * (vk[19] - vj[19]) - (vj[19] - vi[19]) * (vk[18] - vj[18]);
            if (calc < 0.0f) {
                flag |= 1;
            } else if (calc > 0.0f) {
                flag |= 2;
            }
            if (flag == 3) {
                return false;
            }
            ++i;
        }
        if (flag != 0) {
            return true;
        }
        return true;
    }

    protected void concaveRender() {
        if (this.vertexOrder == null || this.vertexOrder.length != this.vertices.length) {
            this.vertexOrder = new int[this.vertices.length];
        }
        if (this.tpolygon == null) {
            this.tpolygon = new PPolygon(this);
        }
        this.tpolygon.reset(3);
        float area = 0.0f;
        int p = this.vertexCount - 1;
        int q = 0;
        while (q < this.vertexCount) {
            area += this.vertices[q][0] * this.vertices[p][1] - this.vertices[p][0] * this.vertices[q][1];
            p = q++;
        }
        if (area == 0.0f) {
            return;
        }
        float[] vfirst = this.vertices[0];
        float[] vlast = this.vertices[this.vertexCount - 1];
        if (Math.abs(vfirst[0] - vlast[0]) < 1.0E-4f && Math.abs(vfirst[1] - vlast[1]) < 1.0E-4f && Math.abs(vfirst[2] - vlast[2]) < 1.0E-4f) {
            --this.vertexCount;
        }
        int i = 0;
        while (i < this.vertexCount) {
            this.vertexOrder[i] = area > 0.0f ? i : this.vertexCount - 1 - i;
            ++i;
        }
        int vc = this.vertexCount;
        int count = 2 * vc;
        int m = 0;
        int v = vc - 1;
        while (vc > 2) {
            double Cx;
            double By;
            double Ay;
            double Cy;
            double Ax;
            double Bx;
            int w;
            boolean snip = true;
            if (count-- <= 0) break;
            int u = v;
            if (vc <= u) {
                u = 0;
            }
            if (vc <= (v = u + 1)) {
                v = 0;
            }
            if (vc <= (w = v + 1)) {
                w = 0;
            }
            if ((double)1.0E-4f > ((Bx = (double)(-10.0f * this.vertices[this.vertexOrder[v]][0])) - (Ax = (double)(-10.0f * this.vertices[this.vertexOrder[u]][0]))) * ((Cy = (double)(10.0f * this.vertices[this.vertexOrder[w]][1])) - (Ay = (double)(10.0f * this.vertices[this.vertexOrder[u]][1]))) - ((By = (double)(10.0f * this.vertices[this.vertexOrder[v]][1])) - Ay) * ((Cx = (double)(-10.0f * this.vertices[this.vertexOrder[w]][0])) - Ax)) continue;
            int p2 = 0;
            while (p2 < vc) {
                if (p2 != u && p2 != v && p2 != w) {
                    double Px = -10.0f * this.vertices[this.vertexOrder[p2]][0];
                    double Py = 10.0f * this.vertices[this.vertexOrder[p2]][1];
                    double ax = Cx - Bx;
                    double ay = Cy - By;
                    double bx = Ax - Cx;
                    double by = Ay - Cy;
                    double cx = Bx - Ax;
                    double cy = By - Ay;
                    double apx = Px - Ax;
                    double apy = Py - Ay;
                    double bpx = Px - Bx;
                    double bpy = Py - By;
                    double cpx = Px - Cx;
                    double cpy = Py - Cy;
                    double aCROSSbp = ax * bpy - ay * bpx;
                    double cCROSSap = cx * apy - cy * apx;
                    double bCROSScp = bx * cpy - by * cpx;
                    if (aCROSSbp >= 0.0 && bCROSScp >= 0.0 && cCROSSap >= 0.0) {
                        snip = false;
                    }
                }
                ++p2;
            }
            if (!snip) continue;
            this.tpolygon.renderTriangle(this.vertices[this.vertexOrder[u]], this.vertices[this.vertexOrder[v]], this.vertices[this.vertexOrder[w]]);
            ++m;
            int s = v;
            int t = v + 1;
            while (t < vc) {
                this.vertexOrder[s] = this.vertexOrder[t];
                ++s;
                ++t;
            }
            count = 2 * --vc;
        }
    }

    public void point(float x, float y, float z) {
        PGraphics2D.showDepthWarningXYZ("point");
    }

    protected void rectImpl(float x1f, float y1f, float x2f, float y2f) {
        if (this.smooth || this.strokeAlpha || this.ctm.isWarped()) {
            super.rectImpl(x1f, y1f, x2f, y2f);
        } else {
            int x1 = (int)(x1f + this.ctm.m02);
            int y1 = (int)(y1f + this.ctm.m12);
            int x2 = (int)(x2f + this.ctm.m02);
            int y2 = (int)(y2f + this.ctm.m12);
            if (this.fill) {
                this.simple_rect_fill(x1, y1, x2, y2);
            }
            if (this.stroke) {
                if (this.strokeWeight == 1.0f) {
                    this.thin_flat_line(x1, y1, x2, y1);
                    this.thin_flat_line(x2, y1, x2, y2);
                    this.thin_flat_line(x2, y2, x1, y2);
                    this.thin_flat_line(x1, y2, x1, y1);
                } else {
                    this.thick_flat_line(x1, y1, this.strokeR, this.strokeG, this.strokeB, this.strokeA, x2, y1, this.strokeR, this.strokeG, this.strokeB, this.strokeA);
                    this.thick_flat_line(x2, y1, this.strokeR, this.strokeG, this.strokeB, this.strokeA, x2, y2, this.strokeR, this.strokeG, this.strokeB, this.strokeA);
                    this.thick_flat_line(x2, y2, this.strokeR, this.strokeG, this.strokeB, this.strokeA, x1, y2, this.strokeR, this.strokeG, this.strokeB, this.strokeA);
                    this.thick_flat_line(x1, y2, this.strokeR, this.strokeG, this.strokeB, this.strokeA, x1, y1, this.strokeR, this.strokeG, this.strokeB, this.strokeA);
                }
            }
        }
    }

    private void simple_rect_fill(int x1, int y1, int x2, int y2) {
        int temp;
        if (y2 < y1) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        if (x2 < x1) {
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (x1 > this.width1 || x2 < 0 || y1 > this.height1 || y2 < 0) {
            return;
        }
        if (x1 < 0) {
            x1 = 0;
        }
        if (x2 > this.width) {
            x2 = this.width;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        if (y2 > this.height) {
            y2 = this.height;
        }
        int ww = x2 - x1;
        if (this.fillAlpha) {
            int y = y1;
            while (y < y2) {
                int index = y * this.width + x1;
                int x = 0;
                while (x < ww) {
                    this.pixels[index] = this.blend_fill(this.pixels[index]);
                    ++index;
                    ++x;
                }
                ++y;
            }
        } else {
            int index;
            int hh = y2 - y1;
            int rowIndex = index = y1 * this.width + x1;
            int i = 0;
            while (i < ww) {
                this.pixels[index + i] = this.fillColor;
                ++i;
            }
            int y = 0;
            while (y < hh) {
                System.arraycopy(this.pixels, rowIndex, this.pixels, index, ww);
                index += this.width;
                ++y;
            }
        }
    }

    protected void ellipseImpl(float x, float y, float w, float h) {
        if (this.smooth || this.strokeWeight != 1.0f || this.fillAlpha || this.strokeAlpha || this.ctm.isWarped()) {
            int i;
            float sy2;
            float sx2;
            float sy1;
            float radiusH = w / 2.0f;
            float radiusV = h / 2.0f;
            float centerX = x + radiusH;
            float centerY = y + radiusV;
            float sx1 = this.screenX(x, y);
            int accuracy = (int)((float)Math.PI * 2 * PApplet.dist(sx1, sy1 = this.screenY(x, y), sx2 = this.screenX(x + w, y + h), sy2 = this.screenY(x + w, y + h)) / 8.0f);
            if (accuracy < 4) {
                return;
            }
            float inc = 720.0f / (float)accuracy;
            float val = 0.0f;
            if (this.fill) {
                boolean savedStroke = this.stroke;
                this.stroke = false;
                this.beginShape();
                i = 0;
                while (i < accuracy) {
                    this.vertex(centerX + cosLUT[(int)val] * radiusH, centerY + sinLUT[(int)val] * radiusV);
                    val += inc;
                    ++i;
                }
                this.endShape(2);
                this.stroke = savedStroke;
            }
            if (this.stroke) {
                boolean savedFill = this.fill;
                this.fill = false;
                val = 0.0f;
                this.beginShape();
                i = 0;
                while (i < accuracy) {
                    this.vertex(centerX + cosLUT[(int)val] * radiusH, centerY + sinLUT[(int)val] * radiusV);
                    val += inc;
                    ++i;
                }
                this.endShape(2);
                this.fill = savedFill;
            }
        } else {
            float hradius = w / 2.0f;
            float vradius = h / 2.0f;
            int centerX = (int)(x + hradius + this.ctm.m02);
            int centerY = (int)(y + vradius + this.ctm.m12);
            int hradiusi = (int)hradius;
            int vradiusi = (int)vradius;
            if (hradiusi == vradiusi) {
                if (this.fill) {
                    this.flat_circle_fill(centerX, centerY, hradiusi);
                }
                if (this.stroke) {
                    this.flat_circle_stroke(centerX, centerY, hradiusi);
                }
            } else {
                if (this.fill) {
                    this.flat_ellipse_internal(centerX, centerY, hradiusi, vradiusi, true);
                }
                if (this.stroke) {
                    this.flat_ellipse_internal(centerX, centerY, hradiusi, vradiusi, false);
                }
            }
        }
    }

    private void flat_circle_stroke(int xC, int yC, int r) {
        int x = 0;
        int y = r;
        int u = 1;
        int v = 2 * r - 1;
        int E = 0;
        while (x < y) {
            this.thin_point(xC + x, yC + y, this.strokeColor);
            this.thin_point(xC + y, yC - x, this.strokeColor);
            this.thin_point(xC - x, yC - y, this.strokeColor);
            this.thin_point(xC - y, yC + x, this.strokeColor);
            ++x;
            if (v < 2 * (E += (u += 2))) {
                --y;
                E -= v;
                v -= 2;
            }
            if (x > y) break;
            this.thin_point(xC + y, yC + x, this.strokeColor);
            this.thin_point(xC + x, yC - y, this.strokeColor);
            this.thin_point(xC - y, yC - x, this.strokeColor);
            this.thin_point(xC - x, yC + y, this.strokeColor);
        }
    }

    private void flat_circle_fill(int xc, int yc, int r) {
        int x = 0;
        int y = r;
        int u = 1;
        int v = 2 * r - 1;
        int E = 0;
        while (x < y) {
            int xx = xc;
            while (xx < xc + x) {
                this.thin_point(xx, yc + y, this.fillColor);
                ++xx;
            }
            xx = xc;
            while (xx < xc + y) {
                this.thin_point(xx, yc - x, this.fillColor);
                ++xx;
            }
            xx = xc - x;
            while (xx < xc) {
                this.thin_point(xx, yc - y, this.fillColor);
                ++xx;
            }
            xx = xc - y;
            while (xx < xc) {
                this.thin_point(xx, yc + x, this.fillColor);
                ++xx;
            }
            ++x;
            if (v < 2 * (E += (u += 2))) {
                --y;
                E -= v;
                v -= 2;
            }
            if (x > y) break;
            xx = xc;
            while (xx < xc + y) {
                this.thin_point(xx, yc + x, this.fillColor);
                ++xx;
            }
            xx = xc;
            while (xx < xc + x) {
                this.thin_point(xx, yc - y, this.fillColor);
                ++xx;
            }
            xx = xc - y;
            while (xx < xc) {
                this.thin_point(xx, yc - x, this.fillColor);
                ++xx;
            }
            xx = xc - x;
            while (xx < xc) {
                this.thin_point(xx, yc + y, this.fillColor);
                ++xx;
            }
        }
    }

    private final void flat_ellipse_symmetry(int centerX, int centerY, int ellipseX, int ellipseY, boolean filling) {
        if (filling) {
            int i = centerX - ellipseX + 1;
            while (i < centerX + ellipseX) {
                this.thin_point(i, centerY - ellipseY, this.fillColor);
                this.thin_point(i, centerY + ellipseY, this.fillColor);
                ++i;
            }
        } else {
            this.thin_point(centerX - ellipseX, centerY + ellipseY, this.strokeColor);
            this.thin_point(centerX + ellipseX, centerY + ellipseY, this.strokeColor);
            this.thin_point(centerX - ellipseX, centerY - ellipseY, this.strokeColor);
            this.thin_point(centerX + ellipseX, centerY - ellipseY, this.strokeColor);
        }
    }

    private void flat_ellipse_internal(int centerX, int centerY, int a, int b, boolean filling) {
        int a2 = a * a;
        int b2 = b * b;
        int x = 0;
        int y = b;
        int s = a2 * (1 - 2 * b) + 2 * b2;
        int t = b2 - 2 * a2 * (2 * b - 1);
        this.flat_ellipse_symmetry(centerX, centerY, x, y, filling);
        do {
            if (s < 0) {
                s += 2 * b2 * (2 * x + 3);
                t += 4 * b2 * (x + 1);
                ++x;
            } else if (t < 0) {
                s += 2 * b2 * (2 * x + 3) - 4 * a2 * (y - 1);
                t += 4 * b2 * (x + 1) - 2 * a2 * (2 * y - 3);
                ++x;
                --y;
            } else {
                s -= 4 * a2 * (y - 1);
                t -= 2 * a2 * (2 * y - 3);
                --y;
            }
            this.flat_ellipse_symmetry(centerX, centerY, x, y, filling);
        } while (y > 0);
    }

    protected void arcImpl(float x, float y, float w, float h, float start, float stop) {
        int stopLUT;
        int startLUT;
        float hr = w / 2.0f;
        float vr = h / 2.0f;
        float centerX = x + hr;
        float centerY = y + vr;
        if (this.fill) {
            boolean savedStroke = this.stroke;
            this.stroke = false;
            startLUT = (int)(-0.5f + start / ((float)Math.PI * 2) * 720.0f);
            stopLUT = (int)(0.5f + stop / ((float)Math.PI * 2) * 720.0f);
            this.beginShape();
            this.vertex(centerX, centerY);
            int i = startLUT;
            while (i < stopLUT) {
                int ii = i % 720;
                if (ii < 0) {
                    ii += 720;
                }
                this.vertex(centerX + cosLUT[ii] * hr, centerY + sinLUT[ii] * vr);
                ++i;
            }
            this.endShape(2);
            this.stroke = savedStroke;
        }
        if (this.stroke) {
            boolean savedFill = this.fill;
            this.fill = false;
            startLUT = (int)(0.5f + start / ((float)Math.PI * 2) * 720.0f);
            stopLUT = (int)(0.5f + stop / ((float)Math.PI * 2) * 720.0f);
            this.beginShape();
            int increment = 1;
            int i = startLUT;
            while (i < stopLUT) {
                int ii = i % 720;
                if (ii < 0) {
                    ii += 720;
                }
                this.vertex(centerX + cosLUT[ii] * hr, centerY + sinLUT[ii] * vr);
                i += increment;
            }
            this.vertex(centerX + cosLUT[stopLUT % 720] * hr, centerY + sinLUT[stopLUT % 720] * vr);
            this.endShape();
            this.fill = savedFill;
        }
    }

    public void box(float size) {
        PGraphics2D.showDepthWarning("box");
    }

    public void box(float w, float h, float d) {
        PGraphics2D.showDepthWarning("box");
    }

    public void sphereDetail(int res) {
        PGraphics2D.showDepthWarning("sphereDetail");
    }

    public void sphereDetail(int ures, int vres) {
        PGraphics2D.showDepthWarning("sphereDetail");
    }

    public void sphere(float r) {
        PGraphics2D.showDepthWarning("sphere");
    }

    public void bezier(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        PGraphics2D.showDepthWarningXYZ("bezier");
    }

    public void curve(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        PGraphics2D.showDepthWarningXYZ("curve");
    }

    protected void imageImpl(PImage image, float x1, float y1, float x2, float y2, int u1, int v1, int u2, int v2) {
        if (x2 - x1 == (float)image.width && y2 - y1 == (float)image.height && !this.tint && !this.ctm.isWarped()) {
            this.simple_image(image, (int)(x1 + this.ctm.m02), (int)(y1 + this.ctm.m12), u1, v1, u2, v2);
        } else {
            super.imageImpl(image, x1, y1, x2, y2, u1, v1, u2, v2);
        }
    }

    private void simple_image(PImage image, int sx1, int sy1, int ix1, int iy1, int ix2, int iy2) {
        block11: {
            int target;
            int source;
            int sy2;
            int sx2;
            block12: {
                block10: {
                    sx2 = sx1 + image.width;
                    sy2 = sy1 + image.height;
                    if (sx1 > this.width1 || sx2 < 0 || sy1 > this.height1 || sy2 < 0) {
                        return;
                    }
                    if (sx1 < 0) {
                        ix1 -= sx1;
                        sx1 = 0;
                    }
                    if (sy1 < 0) {
                        iy1 -= sy1;
                        sy1 = 0;
                    }
                    if (sx2 > this.width) {
                        ix2 -= sx2 - this.width;
                        sx2 = this.width;
                    }
                    if (sy2 > this.height) {
                        iy2 -= sy2 - this.height;
                        sy2 = this.height;
                    }
                    source = iy1 * image.width + ix1;
                    target = sy1 * this.width;
                    if (image.format != 2) break block10;
                    int y = sy1;
                    while (y < sy2) {
                        int tx = 0;
                        int x = sx1;
                        while (x < sx2) {
                            this.pixels[target + x] = this.blend_color(this.pixels[target + x], image.pixels[source + tx++]);
                            ++x;
                        }
                        source += image.width;
                        target += this.width;
                        ++y;
                    }
                    break block11;
                }
                if (image.format != 4) break block12;
                int y = sy1;
                while (y < sy2) {
                    int tx = 0;
                    int x = sx1;
                    while (x < sx2) {
                        this.pixels[target + x] = this.blend_color_alpha(this.pixels[target + x], this.fillColor, image.pixels[source + tx++]);
                        ++x;
                    }
                    source += image.width;
                    target += this.width;
                    ++y;
                }
                break block11;
            }
            if (image.format != 1) break block11;
            target += sx1;
            int tw = sx2 - sx1;
            int y = sy1;
            while (y < sy2) {
                System.arraycopy(image.pixels, source, this.pixels, target, tw);
                source += image.width;
                target += this.width;
                ++y;
            }
        }
    }

    private void thin_point_at(int x, int y, float z, int color) {
        int index = y * this.width + x;
        this.pixels[index] = color;
    }

    private void thin_point_at_index(int offset, float z, int color) {
        this.pixels[offset] = color;
    }

    private void thick_point(float x, float y, float z, float r, float g, float b, float a) {
        this.spolygon.reset(4);
        this.spolygon.interpARGB = false;
        float strokeWidth2 = this.strokeWeight / 2.0f;
        float[] svertex = this.spolygon.vertices[0];
        svertex[18] = x - strokeWidth2;
        svertex[19] = y - strokeWidth2;
        svertex[20] = z;
        svertex[3] = r;
        svertex[4] = g;
        svertex[5] = b;
        svertex[6] = a;
        svertex = this.spolygon.vertices[1];
        svertex[18] = x + strokeWidth2;
        svertex[19] = y - strokeWidth2;
        svertex[20] = z;
        svertex = this.spolygon.vertices[2];
        svertex[18] = x + strokeWidth2;
        svertex[19] = y + strokeWidth2;
        svertex[20] = z;
        svertex = this.spolygon.vertices[3];
        svertex[18] = x - strokeWidth2;
        svertex[19] = y + strokeWidth2;
        svertex[20] = z;
        this.spolygon.render();
    }

    private void thin_flat_line(int x1, int y1, int x2, int y2) {
        int j;
        int offset;
        int ny2;
        int nx2;
        int ny1;
        int nx1;
        int code2;
        int code1 = this.thin_flat_line_clip_code(x1, y1);
        if ((code1 & (code2 = this.thin_flat_line_clip_code(x2, y2))) != 0) {
            return;
        }
        int dip = code1 | code2;
        if (dip != 0) {
            float a1 = 0.0f;
            float a2 = 1.0f;
            float a = 0.0f;
            int i = 0;
            while (i < 4) {
                if ((dip >> i) % 2 == 1) {
                    a = this.thin_flat_line_slope(x1, y1, x2, y2, i + 1);
                    if ((code1 >> i) % 2 == 1) {
                        a1 = Math.max(a, a1);
                    } else {
                        a2 = Math.min(a, a2);
                    }
                }
                ++i;
            }
            if (a1 > a2) {
                return;
            }
            nx1 = (int)((float)x1 + a1 * (float)(x2 - x1));
            ny1 = (int)((float)y1 + a1 * (float)(y2 - y1));
            nx2 = (int)((float)x1 + a2 * (float)(x2 - x1));
            ny2 = (int)((float)y1 + a2 * (float)(y2 - y1));
        } else {
            nx1 = x1;
            nx2 = x2;
            ny1 = y1;
            ny2 = y2;
        }
        boolean yLonger = false;
        int shortLen = ny2 - ny1;
        int longLen = nx2 - nx1;
        if (Math.abs(shortLen) > Math.abs(longLen)) {
            int swap = shortLen;
            shortLen = longLen;
            longLen = swap;
            yLonger = true;
        }
        int decInc = longLen == 0 ? 0 : (shortLen << 16) / longLen;
        if (nx1 == nx2) {
            if (ny1 > ny2) {
                int ty = ny1;
                ny1 = ny2;
                ny2 = ty;
            }
            offset = ny1 * this.width + nx1;
            int j2 = ny1;
            while (j2 <= ny2) {
                this.thin_point_at_index(offset, 0.0f, this.strokeColor);
                offset += this.width;
                ++j2;
            }
            return;
        }
        if (ny1 == ny2) {
            if (nx1 > nx2) {
                int tx = nx1;
                nx1 = nx2;
                nx2 = tx;
            }
            offset = ny1 * this.width + nx1;
            int j3 = nx1;
            while (j3 <= nx2) {
                this.thin_point_at_index(offset++, 0.0f, this.strokeColor);
                ++j3;
            }
            return;
        }
        if (yLonger) {
            if (longLen > 0) {
                longLen += ny1;
                j = 32768 + (nx1 << 16);
                while (ny1 <= longLen) {
                    this.thin_point_at(j >> 16, ny1, 0.0f, this.strokeColor);
                    j += decInc;
                    ++ny1;
                }
                return;
            }
            longLen += ny1;
            j = 32768 + (nx1 << 16);
            while (ny1 >= longLen) {
                this.thin_point_at(j >> 16, ny1, 0.0f, this.strokeColor);
                j -= decInc;
                --ny1;
            }
            return;
        }
        if (longLen > 0) {
            longLen += nx1;
            j = 32768 + (ny1 << 16);
            while (nx1 <= longLen) {
                this.thin_point_at(nx1, j >> 16, 0.0f, this.strokeColor);
                j += decInc;
                ++nx1;
            }
            return;
        }
        longLen += nx1;
        j = 32768 + (ny1 << 16);
        while (nx1 >= longLen) {
            this.thin_point_at(nx1, j >> 16, 0.0f, this.strokeColor);
            j -= decInc;
            --nx1;
        }
    }

    private int thin_flat_line_clip_code(float x, float y) {
        return (y < 0.0f ? 8 : 0) | (y > (float)this.height1 ? 4 : 0) | (x < 0.0f ? 2 : 0) | (x > (float)this.width1 ? 1 : 0);
    }

    private float thin_flat_line_slope(float x1, float y1, float x2, float y2, int border) {
        switch (border) {
            case 4: {
                return -y1 / (y2 - y1);
            }
            case 3: {
                return ((float)this.height1 - y1) / (y2 - y1);
            }
            case 2: {
                return -x1 / (x2 - x1);
            }
            case 1: {
                return ((float)this.width1 - x1) / (x2 - x1);
            }
        }
        return -1.0f;
    }

    private void thick_flat_line(float ox1, float oy1, float r1, float g1, float b1, float a1, float ox2, float oy2, float r2, float g2, float b2, float a2) {
        this.spolygon.interpARGB = r1 != r2 || g1 != g2 || b1 != b2 || a1 != a2;
        float dX = ox2 - ox1 + 1.0E-4f;
        float dY = oy2 - oy1 + 1.0E-4f;
        float len = (float)Math.sqrt(dX * dX + dY * dY);
        float rh = this.strokeWeight / len / 2.0f;
        float dx0 = rh * dY;
        float dy0 = rh * dX;
        float dx1 = rh * dY;
        float dy1 = rh * dX;
        this.spolygon.reset(4);
        float[] svertex = this.spolygon.vertices[0];
        svertex[18] = ox1 + dx0;
        svertex[19] = oy1 - dy0;
        svertex[3] = r1;
        svertex[4] = g1;
        svertex[5] = b1;
        svertex[6] = a1;
        svertex = this.spolygon.vertices[1];
        svertex[18] = ox1 - dx0;
        svertex[19] = oy1 + dy0;
        svertex[3] = r1;
        svertex[4] = g1;
        svertex[5] = b1;
        svertex[6] = a1;
        svertex = this.spolygon.vertices[2];
        svertex[18] = ox2 - dx1;
        svertex[19] = oy2 + dy1;
        svertex[3] = r2;
        svertex[4] = g2;
        svertex[5] = b2;
        svertex[6] = a2;
        svertex = this.spolygon.vertices[3];
        svertex[18] = ox2 + dx1;
        svertex[19] = oy2 - dy1;
        svertex[3] = r2;
        svertex[4] = g2;
        svertex[5] = b2;
        svertex[6] = a2;
        this.spolygon.render();
    }

    private void draw_line(float[] v1, float[] v2) {
        if (this.strokeWeight == 1.0f) {
            if (this.line == null) {
                this.line = new PLine(this);
            }
            this.line.reset();
            this.line.setIntensities(v1[13], v1[14], v1[15], v1[16], v2[13], v2[14], v2[15], v2[16]);
            this.line.setVertices(v1[18], v1[19], v1[20], v2[18], v2[19], v2[20]);
            this.line.draw();
        } else {
            this.thick_flat_line(v1[18], v1[19], v1[13], v1[14], v1[15], v1[16], v2[18], v2[19], v2[13], v2[14], v2[15], v2[16]);
        }
    }

    private void draw_lines(float[][] vertices, int max, int offset, int increment, int skip) {
        if (this.strokeWeight == 1.0f) {
            int i = 0;
            while (i < max) {
                if (skip == 0 || (i + offset) % skip != 0) {
                    float[] a = vertices[i];
                    float[] b = vertices[i + offset];
                    if (this.line == null) {
                        this.line = new PLine(this);
                    }
                    this.line.reset();
                    this.line.setIntensities(a[13], a[14], a[15], a[16], b[13], b[14], b[15], b[16]);
                    this.line.setVertices(a[18], a[19], a[20], b[18], b[19], b[20]);
                    this.line.draw();
                }
                i += increment;
            }
        } else {
            int i = 0;
            while (i < max) {
                if (skip == 0 || (i + offset) % skip != 0) {
                    float[] v1 = vertices[i];
                    float[] v2 = vertices[i + offset];
                    this.thick_flat_line(v1[18], v1[19], v1[13], v1[14], v1[15], v1[16], v2[18], v2[19], v2[13], v2[14], v2[15], v2[16]);
                }
                i += increment;
            }
        }
    }

    private void thin_point(float fx, float fy, int color) {
        int x = (int)(fx + 0.4999f);
        int y = (int)(fy + 0.4999f);
        if (x < 0 || x > this.width1 || y < 0 || y > this.height1) {
            return;
        }
        int index = y * this.width + x;
        if ((color & 0xFF000000) == -16777216) {
            this.pixels[index] = color;
        } else {
            int a2 = color >> 24 & 0xFF;
            int a1 = a2 ^ 0xFF;
            int p2 = this.strokeColor;
            int p1 = this.pixels[index];
            int r = a1 * (p1 >> 16 & 0xFF) + a2 * (p2 >> 16 & 0xFF) & 0xFF00;
            int g = a1 * (p1 >> 8 & 0xFF) + a2 * (p2 >> 8 & 0xFF) & 0xFF00;
            int b = a1 * (p1 & 0xFF) + a2 * (p2 & 0xFF) >> 8;
            this.pixels[index] = 0xFF000000 | r << 8 | g | b;
        }
    }

    public void translate(float tx, float ty) {
        this.ctm.translate(tx, ty);
    }

    public void translate(float tx, float ty, float tz) {
        PGraphics2D.showDepthWarningXYZ("translate");
    }

    public void rotate(float angle) {
        this.ctm.rotate(angle);
    }

    public void rotateX(float angle) {
        PGraphics2D.showDepthWarning("rotateX");
    }

    public void rotateY(float angle) {
        PGraphics2D.showDepthWarning("rotateY");
    }

    public void rotateZ(float angle) {
        PGraphics2D.showDepthWarning("rotateZ");
    }

    public void rotate(float angle, float vx, float vy, float vz) {
        PGraphics2D.showVariationWarning("rotate(angle, x, y, z)");
    }

    public void scale(float s) {
        this.ctm.scale(s);
    }

    public void scale(float sx, float sy) {
        this.ctm.scale(sx, sy);
    }

    public void scale(float x, float y, float z) {
        PGraphics2D.showDepthWarningXYZ("scale");
    }

    public void skewX(float angle) {
        this.ctm.shearX(angle);
    }

    public void skewY(float angle) {
        this.ctm.shearY(angle);
    }

    public void pushMatrix() {
        if (this.matrixStackDepth == 32) {
            throw new RuntimeException("Too many calls to pushMatrix().");
        }
        this.ctm.get(this.matrixStack[this.matrixStackDepth]);
        ++this.matrixStackDepth;
    }

    public void popMatrix() {
        if (this.matrixStackDepth == 0) {
            throw new RuntimeException("Too many calls to popMatrix(), and not enough to pushMatrix().");
        }
        --this.matrixStackDepth;
        this.ctm.set(this.matrixStack[this.matrixStackDepth]);
    }

    public void resetMatrix() {
        this.ctm.reset();
    }

    public void applyMatrix(float n00, float n01, float n02, float n10, float n11, float n12) {
        this.ctm.apply(n00, n01, n02, n10, n11, n12);
    }

    public void applyMatrix(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        PGraphics2D.showDepthWarningXYZ("applyMatrix");
    }

    public void printMatrix() {
        this.ctm.print();
    }

    public float screenX(float x, float y) {
        return this.ctm.m00 * x + this.ctm.m01 * y + this.ctm.m02;
    }

    public float screenY(float x, float y) {
        return this.ctm.m10 * x + this.ctm.m11 * y + this.ctm.m12;
    }

    protected void backgroundImpl() {
        Arrays.fill(this.pixels, this.backgroundColor);
    }

    private final int blend_fill(int p1) {
        int a2 = this.fillAi;
        int a1 = a2 ^ 0xFF;
        int r = a1 * (p1 >> 16 & 0xFF) + a2 * this.fillRi & 0xFF00;
        int g = a1 * (p1 >> 8 & 0xFF) + a2 * this.fillGi & 0xFF00;
        int b = a1 * (p1 & 0xFF) + a2 * this.fillBi & 0xFF00;
        return 0xFF000000 | r << 8 | g | b >> 8;
    }

    private final int blend_color(int p1, int p2) {
        int a2 = p2 >>> 24;
        if (a2 == 255) {
            return p2;
        }
        int a1 = a2 ^ 0xFF;
        int r = a1 * (p1 >> 16 & 0xFF) + a2 * (p2 >> 16 & 0xFF) & 0xFF00;
        int g = a1 * (p1 >> 8 & 0xFF) + a2 * (p2 >> 8 & 0xFF) & 0xFF00;
        int b = a1 * (p1 & 0xFF) + a2 * (p2 & 0xFF) >> 8;
        return 0xFF000000 | r << 8 | g | b;
    }

    private final int blend_color_alpha(int p1, int p2, int a2) {
        a2 = a2 * (p2 >>> 24) >> 8;
        int a1 = a2 ^ 0xFF;
        int r = a1 * (p1 >> 16 & 0xFF) + a2 * (p2 >> 16 & 0xFF) & 0xFF00;
        int g = a1 * (p1 >> 8 & 0xFF) + a2 * (p2 >> 8 & 0xFF) & 0xFF00;
        int b = a1 * (p1 & 0xFF) + a2 * (p2 & 0xFF) >> 8;
        return 0xFF000000 | r << 8 | g | b;
    }
}

